/*
 * Decompiled with CFR 0.152.
 */
package net.mfjassociates.jai;

import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.image.ImageView;
import javafx.util.StringConverter;
import org.apache.commons.math3.util.Precision;

public class PreferencesController {
    public static final String SAVE_COMPRESSION_PREF = "save_compression";
    public static final String DISPLAY_COMPRESSION_PREF = "display_compression";
    public static final float RECOMMENDED_JPEG_QUALITY = 0.75f;
    public static final float RECOMMENDED_DISPLAY_QUALITY = 1.0f;
    private Preferences userPreferences;
    private JaiPreferences jaiPrefs;
    private ImageView imageView;
    @FXML
    private TextField saveCompressionTextField;
    @FXML
    private TextField displayCompressionTextField;
    @FXML
    private DialogPane dialogPane;
    @FXML
    private Label statusMessageLabel;
    @FXML
    private TextField dpiTextField;
    @FXML
    private TextField widthTextField;
    @FXML
    private TextField heightTextField;
    @FXML
    private ComboBox<JaiPreferences.RESIZE_UNIT> resizeUnitsComboBox;
    @FXML
    private Label lastDirectoryLabel;

    public PreferencesController(Preferences aUserPreferences, ImageView anImageView) {
        this.userPreferences = aUserPreferences;
        this.imageView = anImageView;
    }

    public void setDialog(Dialog<JaiPreferences> aDialog) {
        aDialog.setResultConverter(dialogButton -> {
            if (dialogButton == ButtonType.APPLY) {
                this.jaiPrefs.getSaveCompression().setString(this.saveCompressionTextField.getText());
                this.jaiPrefs.getDisplayCompression().setString(this.displayCompressionTextField.getText());
                this.jaiPrefs.getDpi().setString(this.dpiTextField.getText());
                this.jaiPrefs.getResizeWidth().setString(this.widthTextField.getText());
                this.jaiPrefs.getResizeHeight().setString(this.heightTextField.getText());
                this.jaiPrefs.getResizeUnit().setString(((JaiPreferences.RESIZE_UNIT)((Object)((Object)this.resizeUnitsComboBox.getValue()))).name());
                return this.jaiPrefs;
            }
            return null;
        });
    }

    @FXML
    private void initialize() {
        Button button = (Button)this.dialogPane.lookupButton(ButtonType.APPLY);
        if (button != null) {
            button.setDefaultButton(true);
        }
        if ((button = (Button)this.dialogPane.lookupButton(ButtonType.CANCEL)) != null) {
            button.setCancelButton(true);
        }
        this.resizeUnitsComboBox.getItems().clear();
        this.resizeUnitsComboBox.getItems().addAll((Object[])JaiPreferences.RESIZE_UNIT.values());
        this.jaiPrefs = new JaiPreferences(this.userPreferences);
        this.saveCompressionTextField.setTextFormatter(new TextFormatter((StringConverter)new CompressionConverter()));
        this.saveCompressionTextField.setText(this.jaiPrefs.getSaveCompression().getString());
        this.displayCompressionTextField.setTextFormatter(new TextFormatter((StringConverter)new CompressionConverter()));
        this.displayCompressionTextField.setText(this.jaiPrefs.getDisplayCompression().getString());
        this.resizeUnitsComboBox.setValue((Object)this.jaiPrefs.getResizeUnit().get());
        JaiPreference<Float> rw = this.jaiPrefs.getResizeWidth();
        JaiPreference<Float> rh = this.jaiPrefs.getResizeHeight();
        this.resizeUnitsComboBox.getSelectionModel().selectedItemProperty().addListener((obs, oldv, newv) -> {
            if (oldv != null && oldv.equals((Object)JaiPreferences.RESIZE_UNIT.PIXEL) && newv != null && newv.equals((Object)JaiPreferences.RESIZE_UNIT.PERCENT) && this.imageView.getImage() != null) {
                rw.setString(Double.toString((double)this.jaiPrefs.getResizeWidth().get().floatValue() / this.imageView.getImage().getWidth() * 100.0));
                this.widthTextField.setText(rw.getString());
                rh.setString(Double.toString((double)this.jaiPrefs.getResizeHeight().get().floatValue() / this.imageView.getImage().getHeight() * 100.0));
                this.heightTextField.setText(rh.getString());
            }
            if (oldv != null && oldv.equals((Object)JaiPreferences.RESIZE_UNIT.PERCENT) && newv != null && newv.equals((Object)JaiPreferences.RESIZE_UNIT.PIXEL) && this.imageView.getImage() != null) {
                rw.setString(Double.toString((double)this.jaiPrefs.getResizeWidth().get().floatValue() * this.imageView.getImage().getWidth() / 100.0));
                this.widthTextField.setText(rw.getString());
                rh.setString(Double.toString((double)this.jaiPrefs.getResizeHeight().get().floatValue() * this.imageView.getImage().getHeight() / 100.0));
                this.heightTextField.setText(rh.getString());
            }
        });
        SizeConverter sc = new SizeConverter();
        sc.resizeUnitProperty().bind((ObservableValue)this.resizeUnitsComboBox.valueProperty());
        this.widthTextField.setTextFormatter(new TextFormatter((StringConverter)sc));
        if (Precision.equals((float)0.0f, (float)rw.get().floatValue(), (int)4) && this.imageView.getImage() != null) {
            String widthString = Double.toString(this.imageView.getImage().getWidth());
            rw.setString(widthString);
        }
        this.widthTextField.setText(rw.getString());
        sc = new SizeConverter();
        sc.resizeUnitProperty().bind((ObservableValue)this.resizeUnitsComboBox.valueProperty());
        this.heightTextField.setTextFormatter(new TextFormatter((StringConverter)sc));
        if (Precision.equals((float)0.0f, (float)rh.get().floatValue(), (int)4) && this.imageView.getImage() != null) {
            String heightString = Double.toString(this.imageView.getImage().getHeight());
            rh.setString(heightString);
        }
        this.heightTextField.setText(rh.getString());
        this.dpiTextField.setTextFormatter(new TextFormatter((StringConverter)new DpiConverter()));
        this.dpiTextField.setText(this.jaiPrefs.getDpi().getString());
        this.lastDirectoryLabel.setText(this.jaiPrefs.getLastDirectory().getString());
        Platform.runLater(() -> ((TextField)this.saveCompressionTextField).requestFocus());
    }

    @FXML
    private void resetToDefaultsFired(ActionEvent event) throws BackingStoreException {
        this.userPreferences.clear();
        Platform.runLater(() -> this.statusMessageLabel.setText("Preferences reset to defaults and saved"));
        this.initialize();
    }

    public static void main(String[] args) throws BackingStoreException {
        Preferences prefs = Preferences.userNodeForPackage(Object.class);
        Stream.of(prefs.keys()).forEach(key -> System.out.println(String.format("Pref(%1$s)=%2$s", key, prefs.get((String)key, null))));
        JaiPreference a = new JaiPreference(JaiPreferences.PREFERENCES_NAMES.RESIZE_UNITS, prefs);
        System.out.println("MY-PREF(before set)=" + a.getString());
        a.setString(JaiPreferences.RESIZE_UNIT.PERCENT.name());
        System.out.println("MY-PREF(after  set)=" + a.getString());
    }

    private static void dap(Preferences prefs) throws BackingStoreException {
        prefs.clear();
        System.out.println("Preferences cleared");
    }

    static class JaiPreferences {
        private Preferences prefs;
        private JaiPreference<Float> saveCompression;
        private JaiPreference<Float> displayCompression;
        private JaiPreference<Integer> dpi;
        private JaiPreference<Float> resizeWidth;
        private JaiPreference<Float> resizeHeight;
        private JaiPreference<RESIZE_UNIT> resizeUnit;
        private JaiPreference<String> lastDirectory;

        public JaiPreferences(Preferences aPrefs) {
            this.prefs = aPrefs;
            this.saveCompression = new JaiPreference(PREFERENCES_NAMES.SAVE_COMPRESSION, this.prefs);
            this.displayCompression = new JaiPreference(PREFERENCES_NAMES.DISPLAY_COMPRESSION, this.prefs);
            this.dpi = new JaiPreference(PREFERENCES_NAMES.DPI, this.prefs);
            this.resizeWidth = new JaiPreference(PREFERENCES_NAMES.RESIZE_WIDTH, this.prefs);
            this.resizeHeight = new JaiPreference(PREFERENCES_NAMES.RESIZE_HEIGHT, this.prefs);
            this.resizeUnit = new JaiPreference(PREFERENCES_NAMES.RESIZE_UNITS, this.prefs);
            this.lastDirectory = new JaiPreference(PREFERENCES_NAMES.LAST_DIRECTORY, this.prefs);
        }

        public Preferences getPrefs() {
            return this.prefs;
        }

        public void setPrefs(Preferences prefs) {
            this.prefs = prefs;
        }

        public JaiPreference<Float> getSaveCompression() {
            return this.saveCompression;
        }

        public void setSaveCompression(JaiPreference<Float> saveCompression) {
            this.saveCompression = saveCompression;
        }

        public JaiPreference<Float> getDisplayCompression() {
            return this.displayCompression;
        }

        public void setDisplayCompression(JaiPreference<Float> displayCompression) {
            this.displayCompression = displayCompression;
        }

        public JaiPreference<Integer> getDpi() {
            return this.dpi;
        }

        public void setDpi(JaiPreference<Integer> dpi) {
            this.dpi = dpi;
        }

        public JaiPreference<RESIZE_UNIT> getResizeUnit() {
            return this.resizeUnit;
        }

        public void setResizeUnit(JaiPreference<RESIZE_UNIT> resizeUnit) {
            this.resizeUnit = resizeUnit;
        }

        public JaiPreference<Float> getResizeWidth() {
            return this.resizeWidth;
        }

        public void setResizeWidth(JaiPreference<Float> resizeWidth) {
            this.resizeWidth = resizeWidth;
        }

        public JaiPreference<Float> getResizeHeight() {
            return this.resizeHeight;
        }

        public void setResizeHeight(JaiPreference<Float> resizeHeight) {
            this.resizeHeight = resizeHeight;
        }

        public JaiPreference<String> getLastDirectory() {
            return this.lastDirectory;
        }

        public void setLastDirectory(JaiPreference<String> defaultDirectory) {
            this.lastDirectory = defaultDirectory;
        }

        static enum PREFERENCES_NAMES {
            SAVE_COMPRESSION("save_compression", Float.valueOf(0.75f)),
            DISPLAY_COMPRESSION("display_compression", Float.valueOf(1.0f)),
            DPI("dots_per_inch", 300),
            LAST_DIRECTORY("last_directory", System.getProperty("user.home")),
            RESIZE_WIDTH("resize_width", Float.valueOf(0.0f)),
            RESIZE_HEIGHT("resize_height", Float.valueOf(0.0f)),
            RESIZE_UNITS("resize_units", RESIZE_UNIT.PIXEL);

            private String prefName;
            private Object defaultValue;

            private <T> PREFERENCES_NAMES(String aPrefName, T aDefaultValue) {
                this.prefName = aPrefName;
                this.defaultValue = aDefaultValue;
            }

            public <T> T getDefaultValue() {
                return (T)this.defaultValue;
            }
        }

        static enum RESIZE_UNIT {
            PIXEL,
            PERCENT;

        }
    }

    static class JaiPreference<T> {
        private T pref;
        private String prefName;
        private T defaultValue;
        private Preferences prefs;
        private boolean modified;

        public JaiPreference(JaiPreferences.PREFERENCES_NAMES prefName, Preferences aPrefs) {
            this.defaultValue = prefName.getDefaultValue();
            this.prefName = prefName.prefName;
            this.prefs = aPrefs;
            this.modified = true;
        }

        public T get() {
            if (this.pref == null) {
                this.checkIfChanged(null);
            }
            return this.pref;
        }

        public boolean isModified() {
            return this.modified;
        }

        public <E extends Enum<E>> String getString() {
            Class<?> clazz = this.defaultValue.getClass();
            if (Number.class.isAssignableFrom(clazz) || String.class.isAssignableFrom(clazz)) {
                String prefValue = this.prefs.get(this.prefName, this.defaultValue.toString());
                return prefValue;
            }
            if (Enum.class.isAssignableFrom(clazz)) {
                String prefValue = this.prefs.get(this.prefName, ((Enum)this.defaultValue).name());
                return prefValue;
            }
            throw new IllegalArgumentException("The preference must be of type Number, String or an enum: " + clazz.getCanonicalName());
        }

        public <E extends Enum<E>> void setString(String aPref) {
            if (!this.checkIfChanged(aPref)) {
                this.prefs.put(this.prefName, aPref);
                this.modified = true;
            }
        }

        public void reset() {
            this.prefs.remove(this.prefName);
            this.pref = this.defaultValue;
        }

        private boolean checkIfChanged(String aPref) {
            boolean areEqual = false;
            Class<?> clazz = this.defaultValue.getClass();
            if (Float.class.isAssignableFrom(clazz)) {
                Float oldValue = Float.valueOf(Float.parseFloat(this.getString()));
                if (aPref != null) {
                    this.pref = Float.valueOf(aPref);
                    areEqual = Precision.equals((float)oldValue.floatValue(), (float)((Float)this.pref).floatValue(), (int)4);
                } else {
                    this.pref = oldValue;
                }
            } else if (Double.class.isAssignableFrom(clazz)) {
                Double oldValue = Double.parseDouble(this.getString());
                if (aPref != null) {
                    this.pref = Double.valueOf(aPref);
                    areEqual = Precision.equals((double)oldValue, (double)((Double)this.pref), (int)4);
                } else {
                    this.pref = oldValue;
                }
            } else if (Long.class.isAssignableFrom(clazz)) {
                Long oldValue = Long.parseLong(this.getString());
                if (aPref != null) {
                    this.pref = Long.valueOf(aPref);
                    areEqual = oldValue == (Long)this.pref;
                } else {
                    this.pref = oldValue;
                }
            } else if (Integer.class.isAssignableFrom(clazz)) {
                Integer oldValue = Integer.parseInt(this.getString());
                if (aPref != null) {
                    this.pref = Integer.valueOf(aPref);
                    areEqual = oldValue == (Integer)this.pref;
                } else {
                    this.pref = oldValue;
                }
            } else if (Enum.class.isAssignableFrom(clazz)) {
                String oldValue = this.getString();
                if (aPref != null) {
                    this.pref = Enum.valueOf(((Enum)this.defaultValue).getClass(), aPref);
                    areEqual = oldValue.equals(aPref);
                } else {
                    this.pref = Enum.valueOf(((Enum)this.defaultValue).getClass(), oldValue);
                }
            } else {
                throw new IllegalArgumentException("The preference must be of type Number, String or an enum: " + clazz.getCanonicalName());
            }
            return areEqual;
        }
    }

    private static class SizeConverter
    extends StringConverter<Float> {
        private ObjectProperty<JaiPreferences.RESIZE_UNIT> resizeUnit = new SimpleObjectProperty();

        private SizeConverter() {
        }

        public JaiPreferences.RESIZE_UNIT getResizeUnit() {
            return (JaiPreferences.RESIZE_UNIT)((Object)this.resizeUnit.get());
        }

        public void setResizeUnit(JaiPreferences.RESIZE_UNIT aUnit) {
            this.resizeUnit.set((Object)aUnit);
        }

        public ObjectProperty<JaiPreferences.RESIZE_UNIT> resizeUnitProperty() {
            return this.resizeUnit;
        }

        public String toString(Float object) {
            if (object == null) {
                return "0.0";
            }
            return object.toString();
        }

        public Float fromString(String string) {
            Float value = Float.valueOf(Float.parseFloat(string));
            if ((double)value.floatValue() < 0.0) {
                value = Float.valueOf(0.0f);
            }
            if (((JaiPreferences.RESIZE_UNIT)((Object)this.resizeUnit.get())).equals((Object)JaiPreferences.RESIZE_UNIT.PERCENT) && (double)value.floatValue() > 100.0) {
                value = Float.valueOf(100.0f);
            }
            return value;
        }
    }

    private static class DpiConverter
    extends StringConverter<Integer> {
        private DpiConverter() {
        }

        public String toString(Integer object) {
            if (object == null) {
                return "0";
            }
            return object.toString();
        }

        public Integer fromString(String string) {
            Integer value = Integer.parseInt(string);
            if (value < 0) {
                value = 0;
            }
            return value;
        }
    }

    private static class CompressionConverter
    extends StringConverter<Float> {
        private CompressionConverter() {
        }

        public String toString(Float object) {
            if (object == null) {
                return "0.0";
            }
            return object.toString();
        }

        public Float fromString(String string) {
            Float value = Float.valueOf(Float.parseFloat(string));
            if ((double)value.floatValue() < 0.0) {
                value = Float.valueOf(0.0f);
            }
            if ((double)value.floatValue() > 1.0) {
                value = Float.valueOf(1.0f);
            }
            return value;
        }
    }
}

