/*
 * Decompiled with CFR 0.152.
 */
package net.mfjassociates.jai;

import java.util.prefs.Preferences;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.util.Pair;
import javafx.util.StringConverter;
import org.apache.commons.math3.util.Precision;

public class PreferencesController {
    public static final String SAVE_COMPRESSION_PREF = "save_compression";
    public static final String DISPLAY_COMPRESSION_PREF = "display_compression";
    public static final float RECOMMENDED_JPEG_QUALITY = 0.75f;
    public static final float RECOMMENDED_DISPLAY_QUALITY = 1.0f;
    private Preferences userPreferences;
    private Dialog<Pair<Float, Float>> dialog;
    @FXML
    private TextField saveCompressionTextField;
    @FXML
    private TextField displayCompressionTextField;
    @FXML
    private DialogPane dialogPane;

    public PreferencesController(Preferences aUserPreferences) {
        this.userPreferences = aUserPreferences;
    }

    public void setDialog(Dialog<Pair<Float, Float>> aDialog) {
        this.dialog = aDialog;
        this.dialog.setResultConverter(dialogButton -> {
            if (dialogButton == ButtonType.APPLY) {
                String aSaveCompression = this.saveCompressionTextField.getText();
                String aDisplayCompression = this.displayCompressionTextField.getText();
                String saveCompression = this.userPreferences.get(SAVE_COMPRESSION_PREF, Float.toString(0.75f));
                String displayCompression = this.userPreferences.get(DISPLAY_COMPRESSION_PREF, Float.toString(1.0f));
                float oldCompression = Float.parseFloat(saveCompression);
                float newCompression = Float.parseFloat(aSaveCompression);
                Float returnedSaveCompression = null;
                Float returnedDisplayCompression = null;
                if (!Precision.equals((float)oldCompression, (float)newCompression, (int)4)) {
                    this.userPreferences.put(SAVE_COMPRESSION_PREF, aSaveCompression);
                    returnedSaveCompression = Float.valueOf(newCompression);
                }
                if (!Precision.equals((float)(oldCompression = Float.parseFloat(displayCompression)), (float)(newCompression = Float.parseFloat(aDisplayCompression)), (int)4)) {
                    this.userPreferences.put(DISPLAY_COMPRESSION_PREF, aDisplayCompression);
                    returnedDisplayCompression = Float.valueOf(newCompression);
                }
                return new Pair((Object)returnedSaveCompression, returnedDisplayCompression);
            }
            return null;
        });
    }

    @FXML
    private void initialize() {
        Parent parent = this.dialogPane.getParent();
        Button button = (Button)this.dialogPane.lookupButton(ButtonType.APPLY);
        if (button != null) {
            button.setDefaultButton(true);
        }
        String saveCompression = this.userPreferences.get(SAVE_COMPRESSION_PREF, Float.toString(0.75f));
        String displayCompression = this.userPreferences.get(DISPLAY_COMPRESSION_PREF, Float.toString(1.0f));
        this.saveCompressionTextField.setTextFormatter(new TextFormatter((StringConverter)new CompressionConverter()));
        this.saveCompressionTextField.setText(saveCompression);
        this.displayCompressionTextField.setTextFormatter(new TextFormatter((StringConverter)new CompressionConverter()));
        this.displayCompressionTextField.setText(displayCompression);
        Platform.runLater(() -> this.saveCompressionTextField.requestFocus());
    }

    private static class CompressionConverter
    extends StringConverter<Float> {
        private CompressionConverter() {
        }

        public String toString(Float object) {
            if (object == null) {
                return "0.0";
            }
            return object.toString();
        }

        public Float fromString(String string) {
            Float value = Float.valueOf(Float.parseFloat(string));
            if ((double)value.floatValue() < 0.0 || (double)value.floatValue() > 1.0) {
                throw new NumberFormatException(value.toString() + ": new value is less than 0.0 or greater than 1.0");
            }
            return value;
        }
    }
}

