/*
 * Decompiled with CFR 0.152.
 */
package net.mfjassociates.maven.mojo;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.maven.model.Model;
import org.apache.maven.model.Scm;
import org.apache.maven.model.io.DefaultModelReader;
import org.apache.maven.model.io.DefaultModelWriter;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="getinfo")
public class SCMInfoMojo
extends AbstractMojo {
    public static final String NEW_POM = ".updated-pom.xml";
    private static final String SCM_INFO_PROPERTY_NAME = "scmInfo";
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="scmtype", defaultValue="svn", required=true)
    private String scmtype;
    @Parameter(property="updatePomFile")
    private Boolean updatePomFile;
    private static final String SVN_START = "$URL: ";
    private static final String SVN_END = " $";

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.updatePom();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void updatePom() throws IOException, MojoFailureException {
        String scmInfo;
        SUPPORTED_SCMTYPES myscmtype;
        try {
            myscmtype = SUPPORTED_SCMTYPES.valueOf(this.scmtype);
        }
        catch (IllegalArgumentException e) {
            throw new MojoFailureException("The SCM type '" + this.scmtype + "' is not supported by this mojo");
        }
        DefaultModelReader reader = new DefaultModelReader();
        Model m = reader.read(this.project.getFile(), null);
        Properties p = m.getProperties();
        if (Objects.nonNull(p) && Objects.nonNull(scmInfo = p.getProperty(SCM_INFO_PROPERTY_NAME))) {
            Scm scm = m.getScm();
            if (Objects.isNull(scm)) {
                scm = new Scm();
                m.setScm(scm);
            }
            scm.setUrl(scmInfo);
            scm.setConnection(scmInfo);
            scm.setDeveloperConnection(scmInfo);
            AtomicBoolean updated = new AtomicBoolean(false);
            switch (myscmtype) {
                case svn: {
                    this.updateSVN(scm, updated);
                }
            }
            DefaultModelWriter writer = new DefaultModelWriter();
            File updatedPom = this.project.getFile().toPath().resolveSibling(NEW_POM).toFile();
            writer.write(updatedPom, null, m);
            if (this.isUpdatePomFile() && updated.get()) {
                this.project.setPomFile(updatedPom);
            }
            if (updated.get()) {
                this.getLog().info((CharSequence)("Updated pom file for " + m.getArtifactId() + " into " + updatedPom.getName()));
            }
        }
    }

    private void updateSVN(Scm scm, AtomicBoolean updated) {
        scm.setUrl(this.reformat(scm.getUrl(), SVN_START, SVN_END, "", updated));
        scm.setDeveloperConnection(this.reformat(scm.getDeveloperConnection(), SVN_START, SVN_END, "scm:svn:", updated));
        scm.setConnection(this.reformat(scm.getConnection(), SVN_START, SVN_END, "scm:svn:", updated));
    }

    private String reformat(String svnKeywords, String start, String end, String prefix, AtomicBoolean updated) {
        String result = svnKeywords;
        int lme = svnKeywords.length() - Objects.requireNonNull(end, "end delimiter must not be null").length();
        if (svnKeywords.indexOf(start) == 0 && svnKeywords.indexOf(end) == lme) {
            lme = svnKeywords.lastIndexOf("/");
            updated.set(true);
            result = prefix + svnKeywords.substring(Objects.requireNonNull(start, "start delimieter must not be null").length(), lme);
        }
        return result;
    }

    public boolean isUpdatePomFile() {
        if (this.updatePomFile == null) {
            return true;
        }
        return this.updatePomFile;
    }

    public static void main(String[] args) throws MojoFailureException {
        SCMInfoMojo a = new SCMInfoMojo();
        String scmtype = "svn";
        try {
            SUPPORTED_SCMTYPES sUPPORTED_SCMTYPES = SUPPORTED_SCMTYPES.valueOf(scmtype);
        }
        catch (IllegalArgumentException e) {
            throw new MojoFailureException("The SCM type '" + scmtype + "' is not supported by this mojo");
        }
        System.out.println(a.reformat("$URL: http://cbsasvnserver1.omega.dce-eir.net/apps/dcscripts/branches/DevCenterWork/maven/du-template/trunk/pom.xml $", SVN_START, SVN_END, "", new AtomicBoolean(false)));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SUPPORTED_SCMTYPES {
        svn;

    }
}

