/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.sorting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.masterthought.cucumber.json.Feature;
import net.masterthought.cucumber.json.support.StepObject;
import net.masterthought.cucumber.json.support.TagObject;
import net.masterthought.cucumber.sorting.FeaturesAlphabeticalComparator;
import net.masterthought.cucumber.sorting.SortingMethod;
import net.masterthought.cucumber.sorting.StepObjectAlphabeticalComparator;
import net.masterthought.cucumber.sorting.TagObjectAlphabeticalComparator;

public final class SortingFactory {
    private final SortingMethod sortingMethod;

    public SortingFactory(SortingMethod sortingMethod) {
        this.sortingMethod = sortingMethod;
    }

    public List<Feature> sortFeatures(Collection<Feature> features) {
        switch (this.sortingMethod) {
            case NATURAL: {
                return new ArrayList<Feature>(features);
            }
            case ALPHABETICAL: {
                return SortingFactory.toSortedList(features, new FeaturesAlphabeticalComparator());
            }
        }
        throw this.createUnknownMethodException(this.sortingMethod);
    }

    public List<TagObject> sortTags(Collection<TagObject> tags) {
        switch (this.sortingMethod) {
            case NATURAL: {
                return new ArrayList<TagObject>(tags);
            }
            case ALPHABETICAL: {
                return SortingFactory.toSortedList(tags, new TagObjectAlphabeticalComparator());
            }
        }
        throw this.createUnknownMethodException(this.sortingMethod);
    }

    public List<StepObject> sortSteps(Collection<StepObject> steps) {
        switch (this.sortingMethod) {
            case NATURAL: {
                return new ArrayList<StepObject>(steps);
            }
            case ALPHABETICAL: {
                return SortingFactory.toSortedList(steps, new StepObjectAlphabeticalComparator());
            }
        }
        throw this.createUnknownMethodException(this.sortingMethod);
    }

    private static <T> List<T> toSortedList(Collection<T> values, Comparator<T> comparator) {
        ArrayList<T> list = new ArrayList<T>(values);
        Collections.sort(list, comparator);
        return list;
    }

    private RuntimeException createUnknownMethodException(SortingMethod sortingMethod) {
        return new IllegalArgumentException("Unsupported sorting method: " + String.valueOf((Object)sortingMethod));
    }
}

