/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.json.deserializers;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.ArrayList;
import net.masterthought.cucumber.Configuration;
import net.masterthought.cucumber.json.Output;
import net.masterthought.cucumber.json.deserializers.CucumberJsonDeserializer;

public class OutputsDeserializer
extends CucumberJsonDeserializer<Output[]> {
    @Override
    protected Output[] deserialize(JsonNode rootNode, Configuration configuration) throws IOException {
        ArrayList<Output> outputs = new ArrayList<Output>();
        if (rootNode.get(0).isArray()) {
            for (JsonNode outputNode : rootNode) {
                outputs.add(this.getOutput(outputNode));
            }
        } else {
            outputs.add(this.getOutput(rootNode));
        }
        return outputs.toArray(new Output[outputs.size()]);
    }

    private Output getOutput(JsonNode outputNode) {
        ArrayList<String> messages = new ArrayList<String>();
        for (JsonNode messageNode : outputNode) {
            messages.add(messageNode.asText());
        }
        return new Output(messages.toArray(new String[messages.size()]));
    }
}

