/*
 * Decompiled with CFR 0.152.
 */
package net.markenwerk.utils.mail.smime;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;

final class MimeUtil {
    private MimeUtil() {
    }

    static MimeMessage canonicalize(Session session, MimeMessage mimeMessage) throws MessagingException, IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        MimeCanonicalOutputStream out = new MimeCanonicalOutputStream(buffer);
        mimeMessage.writeTo((OutputStream)out);
        ((OutputStream)out).close();
        return new MimeMessage(session, (InputStream)new ByteArrayInputStream(buffer.toByteArray()));
    }

    static MimeBodyPart canonicalize(MimeBodyPart mimeBodyPart) throws MessagingException, IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        MimeCanonicalOutputStream out = new MimeCanonicalOutputStream(buffer);
        mimeBodyPart.writeTo((OutputStream)out);
        ((OutputStream)out).close();
        return new MimeBodyPart((InputStream)new ByteArrayInputStream(buffer.toByteArray()));
    }

    private static class MimeCanonicalOutputStream
    extends FilterOutputStream {
        int lastReadByte = -1;
        byte[] crlf = new byte[]{13, 10};

        public MimeCanonicalOutputStream(OutputStream os) {
            super(os);
        }

        @Override
        public void write(int b) throws IOException {
            if (b == 13) {
                this.out.write(this.crlf);
            } else if (b == 10) {
                if (this.lastReadByte != 13) {
                    this.out.write(this.crlf);
                }
            } else {
                this.out.write(b);
            }
            this.lastReadByte = b;
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            int start = off;
            len = off + len;
            for (int i = start; i < len; ++i) {
                if (b[i] == 13) {
                    this.out.write(b, start, i - start);
                    this.out.write(this.crlf);
                    start = i + 1;
                } else if (b[i] == 10) {
                    if (this.lastReadByte != 13) {
                        this.out.write(b, start, i - start);
                        this.out.write(this.crlf);
                    }
                    start = i + 1;
                }
                this.lastReadByte = b[i];
            }
            if (len - start > 0) {
                this.out.write(b, start, len - start);
            }
        }
    }
}

