/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.pki;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.security.KeyStore;
import java.security.PublicKey;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import net.maritimecloud.pki.CertificateHandler;
import net.maritimecloud.pki.RevocationInfo;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v2CRLBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CRLConverter;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.BasicOCSPRespBuilder;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.OCSPRespBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Revocation {
    private static final Logger log = LoggerFactory.getLogger(Revocation.class);

    public static int getCRLReasonFromString(String certReason) {
        int reason = 0;
        if ("unspecified".equals(certReason)) {
            reason = 0;
        } else if ("keycompromise".equals(certReason)) {
            reason = 1;
        } else if ("cacompromise".equals(certReason)) {
            reason = 2;
        } else if ("affiliationchanged".equals(certReason)) {
            reason = 3;
        } else if ("superseded".equals(certReason)) {
            reason = 4;
        } else if ("cessationofoperation".equals(certReason)) {
            reason = 5;
        } else if ("certificatehold".equals(certReason)) {
            reason = 6;
        } else if ("removefromcrl".equals(certReason)) {
            reason = 8;
        } else if ("privilegewithdrawn".equals(certReason)) {
            reason = 9;
        } else if ("aacompromise".equals(certReason)) {
            reason = 10;
        }
        return reason;
    }

    public static X509CRL generateCRL(List<RevocationInfo> revokedCerts, KeyStore.PrivateKeyEntry keyEntry) {
        ContentSigner signer;
        String signCertX500Name;
        Date now = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(now);
        cal.add(5, 7);
        try {
            signCertX500Name = new JcaX509CertificateHolder((X509Certificate)keyEntry.getCertificate()).getSubject().toString();
        }
        catch (CertificateEncodingException e) {
            e.printStackTrace();
            return null;
        }
        X509v2CRLBuilder crlBuilder = new X509v2CRLBuilder(new X500Name(signCertX500Name), now);
        crlBuilder.setNextUpdate(new Date(now.getTime() + 604800000L));
        for (RevocationInfo cert : revokedCerts) {
            crlBuilder.addCRLEntry(cert.getSerialNumber(), cert.getRevokedAt(), cert.getRevokeReason().ordinal());
        }
        JcaContentSignerBuilder signBuilder = new JcaContentSignerBuilder("SHA256withECDSA");
        signBuilder.setProvider("BC");
        try {
            signer = signBuilder.build(keyEntry.getPrivateKey());
        }
        catch (OperatorCreationException e1) {
            e1.printStackTrace();
            return null;
        }
        X509CRLHolder cRLHolder = crlBuilder.build(signer);
        JcaX509CRLConverter converter = new JcaX509CRLConverter();
        converter.setProvider("BC");
        X509CRL crl = null;
        try {
            crl = converter.getCRL(cRLHolder);
        }
        catch (CRLException e) {
            e.printStackTrace();
        }
        return crl;
    }

    public static void generateRootCACRL(String signName, List<RevocationInfo> revokedCerts, KeyStore.PrivateKeyEntry keyEntry, String outputCaCrlPath) {
        String pemCrl;
        X509CRL crl;
        ContentSigner signer;
        Date now = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(now);
        cal.add(1, 1);
        X509v2CRLBuilder crlBuilder = new X509v2CRLBuilder(new X500Name(signName), now);
        crlBuilder.setNextUpdate(cal.getTime());
        if (revokedCerts != null) {
            for (RevocationInfo cert : revokedCerts) {
                crlBuilder.addCRLEntry(cert.getSerialNumber(), cert.getRevokedAt(), cert.getRevokeReason().ordinal());
            }
        }
        JcaContentSignerBuilder signBuilder = new JcaContentSignerBuilder("SHA256withECDSA");
        signBuilder.setProvider("BC");
        try {
            signer = signBuilder.build(keyEntry.getPrivateKey());
        }
        catch (OperatorCreationException e1) {
            e1.printStackTrace();
            return;
        }
        X509CRLHolder cRLHolder = crlBuilder.build(signer);
        JcaX509CRLConverter converter = new JcaX509CRLConverter();
        converter.setProvider("BC");
        try {
            crl = converter.getCRL(cRLHolder);
        }
        catch (CRLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        try {
            pemCrl = CertificateHandler.getPemFromEncoded("X509 CRL", crl.getEncoded());
        }
        catch (CRLException e) {
            return;
        }
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(outputCaCrlPath));
            writer.write(pemCrl);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static BasicOCSPRespBuilder initOCSPRespBuilder(OCSPReq request, PublicKey publicKey) {
        BasicOCSPRespBuilder respBuilder;
        SubjectPublicKeyInfo keyinfo = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
        try {
            respBuilder = new BasicOCSPRespBuilder(keyinfo, new JcaDigestCalculatorProviderBuilder().setProvider("BC").build().get(CertificateID.HASH_SHA1));
        }
        catch (Exception e) {
            return null;
        }
        Extension ext = request.getExtension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce);
        if (ext != null) {
            respBuilder.setResponseExtensions(new Extensions(new Extension[]{ext}));
        }
        return respBuilder;
    }

    public static OCSPResp generateOCSPResponse(BasicOCSPRespBuilder respBuilder, KeyStore.PrivateKeyEntry signingCert) {
        try {
            ContentSigner contentSigner = new JcaContentSignerBuilder("SHA256withECDSA").setProvider("BC").build(signingCert.getPrivateKey());
            BasicOCSPResp basicResp = respBuilder.build(contentSigner, new X509CertificateHolder[]{new X509CertificateHolder(signingCert.getCertificate().getEncoded())}, new Date());
            int response = 0;
            return new OCSPRespBuilder().build(response, (Object)basicResp);
        }
        catch (Exception e) {
            return null;
        }
    }
}

