/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.pki;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.PKIXRevocationChecker;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import net.maritimecloud.pki.PKIIdentity;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.cert.CertException;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateHandler {
    private static final Logger log = LoggerFactory.getLogger(CertificateHandler.class);

    public static boolean verifyCertificate(PublicKey verificationPubKey, X509Certificate certToVerify, Date verificationDate) {
        ContentVerifierProvider contentVerifierProvider;
        JcaX509CertificateHolder certHolder;
        try {
            certHolder = new JcaX509CertificateHolder(certToVerify);
        }
        catch (CertificateEncodingException e) {
            log.error("Could not create JcaX509CertificateHolder", e);
            return false;
        }
        try {
            contentVerifierProvider = new JcaContentVerifierProviderBuilder().setProvider("BC").build(verificationPubKey);
        }
        catch (OperatorCreationException e) {
            log.error("Could not create ContentVerifierProvider from public key", e);
            return false;
        }
        if (contentVerifierProvider == null) {
            log.error("Created ContentVerifierProvider from root public key is null");
            return false;
        }
        try {
            if (certHolder.isSignatureValid(contentVerifierProvider)) {
                if (verificationDate == null) {
                    verificationDate = new Date();
                }
                if (verificationDate.after(certToVerify.getNotBefore()) && verificationDate.before(certToVerify.getNotAfter())) {
                    return true;
                }
            }
        }
        catch (CertException e) {
            log.error("Error when trying to validate signature", e);
            return false;
        }
        log.debug("Certificate does not seem to be valid!");
        return false;
    }

    public static boolean verifyCertificateChain(X509Certificate certificate, KeyStore ks) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, InvalidAlgorithmParameterException, CertPathValidatorException {
        List<X509Certificate> certList = Collections.singletonList(certificate);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        CertPath certPath = cf.generateCertPath(certList);
        CertPathValidator validator = CertPathValidator.getInstance("PKIX");
        PKIXRevocationChecker rc = (PKIXRevocationChecker)validator.getRevocationChecker();
        rc.setOptions(EnumSet.of(PKIXRevocationChecker.Option.SOFT_FAIL));
        PKIXParameters pkixp = new PKIXParameters(ks);
        pkixp.addCertPathChecker(rc);
        pkixp.setRevocationEnabled(true);
        PKIXCertPathValidatorResult pcpvr = (PKIXCertPathValidatorResult)validator.validate(certPath, pkixp);
        return pcpvr != null;
    }

    public static String getPemFromEncoded(String type, byte[] encoded) {
        String pemFormat = "";
        StringWriter perStrWriter = new StringWriter();
        PemWriter pemWrite = new PemWriter(perStrWriter);
        try {
            pemWrite.writeObject(new PemObject(type, encoded));
            pemWrite.flush();
            pemFormat = perStrWriter.toString();
            pemWrite.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return pemFormat;
    }

    public static byte[] createOutputKeystore(String type, String alias, String password, PrivateKey privateKey, X509Certificate certificate) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            KeyStore ks = KeyStore.getInstance(type);
            ks.load(null);
            ks.setKeyEntry(alias, privateKey, password.toCharArray(), new Certificate[]{certificate});
            ks.store(bos, password.toCharArray());
            bos.close();
            return bos.toByteArray();
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    public static X509Certificate getCertFromNginxHeader(String certificateHeader) {
        String certificateContent = certificateHeader.replaceAll("\\s+", System.lineSeparator().replaceAll("\\t+", System.lineSeparator()));
        certificateContent = certificateContent.replace("-----BEGIN" + System.lineSeparator() + "CERTIFICATE-----", "-----BEGIN CERTIFICATE-----");
        if ((certificateContent = certificateContent.replace("-----END" + System.lineSeparator() + "CERTIFICATE-----", "-----END CERTIFICATE-----")) == null || certificateContent.length() < 10) {
            log.debug("No certificate content found");
            return null;
        }
        return CertificateHandler.getCertFromPem(certificateContent);
    }

    public static X509Certificate getCertFromPem(String pemCertificate) {
        X509Certificate userCertificate;
        CertificateFactory certificateFactory;
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            log.error("Exception while creating CertificateFactory", e);
            return null;
        }
        try {
            userCertificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(pemCertificate.getBytes("ISO-8859-11")));
        }
        catch (UnsupportedEncodingException | CertificateException e) {
            log.error("Exception while converting certificate extracted from header", e);
            return null;
        }
        log.debug("Certificate was extracted from the header");
        return userCertificate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PKIIdentity getIdentityFromCert(X509Certificate userCertificate) {
        PKIIdentity identity = new PKIIdentity();
        String certDN = userCertificate.getSubjectDN().getName();
        X500Name x500name = new X500Name(certDN);
        String name = CertificateHandler.getElement(x500name, BCStyle.CN);
        String uid = CertificateHandler.getElement(x500name, BCStyle.UID);
        identity.setMrn(uid);
        identity.setDn(certDN);
        identity.setCn(name);
        identity.setSn(name);
        identity.setO(CertificateHandler.getElement(x500name, BCStyle.O));
        identity.setOu(CertificateHandler.getElement(x500name, BCStyle.OU));
        identity.setCountry(CertificateHandler.getElement(x500name, BCStyle.C));
        identity.setEmail(CertificateHandler.getElement(x500name, BCStyle.EmailAddress));
        String lastName = "";
        String firstName = "";
        if (name.split("\\w +\\w").length > 1) {
            lastName = name.substring(name.lastIndexOf(" ") + 1);
            firstName = name.substring(0, name.lastIndexOf(32));
        } else {
            firstName = name;
        }
        identity.setFirstName(firstName);
        identity.setLastName(lastName);
        log.debug("Parsed certificate, name: " + name);
        Collection<List<?>> san = null;
        try {
            san = userCertificate.getSubjectAlternativeNames();
        }
        catch (CertificateParsingException e) {
            log.warn("could not extract info from Subject Alternative Names - will be ignored.");
        }
        if (san != null) {
            StringBuilder permissions = new StringBuilder();
            block39: for (List<?> item : san) {
                Integer type = (Integer)item.get(0);
                if (type == 0) {
                    String value;
                    String oid;
                    FilterInputStream decoder = null;
                    try {
                        decoder = new ASN1InputStream((byte[])item.toArray()[1]);
                        DLSequence seq = (DLSequence)((ASN1InputStream)decoder).readObject();
                        ASN1ObjectIdentifier asnOID = (ASN1ObjectIdentifier)seq.getObjectAt(0);
                        ASN1Encodable encoded = seq.getObjectAt(1);
                        oid = asnOID.getId();
                        encoded = ((DERTaggedObject)encoded).getObject();
                        encoded = ((DERTaggedObject)encoded).getObject();
                        value = ((DERUTF8String)encoded).getString();
                    }
                    catch (UnsupportedEncodingException e) {
                        log.error("Error decoding subjectAltName" + e.getLocalizedMessage(), e);
                        continue;
                    }
                    catch (Exception e) {
                        log.error("Error decoding subjectAltName" + e.getLocalizedMessage(), e);
                        continue;
                    }
                    finally {
                        if (decoder == null) continue;
                        try {
                            decoder.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    log.debug("oid: " + oid + ", value: " + value);
                    switch (oid) {
                        case "2.25.323100633285601570573910217875371967771": {
                            identity.setFlagState(value);
                            break;
                        }
                        case "2.25.208070283325144527098121348946972755227": {
                            identity.setCallSign(value);
                            break;
                        }
                        case "2.25.291283622413876360871493815653100799259": {
                            identity.setImoNumber(value);
                            break;
                        }
                        case "2.25.328433707816814908768060331477217690907": {
                            identity.setMmsiNumber(value);
                            break;
                        }
                        case "2.25.107857171638679641902842130101018412315": {
                            identity.setAisShipType(value);
                            break;
                        }
                        case "2.25.285632790821948647314354670918887798603": {
                            identity.setPortOfRegister(value);
                            break;
                        }
                        case "2.25.271477598449775373676560215839310464283": {
                            identity.setMrn(value);
                            break;
                        }
                        case "2.25.268095117363717005222833833642941669792": {
                            identity.setShipMrn(value);
                        }
                        case "2.25.174437629172304915481663724171734402331": {
                            if (value == null || value.trim().isEmpty()) continue block39;
                            if (permissions.length() == 0) {
                                permissions = new StringBuilder(value);
                                break;
                            }
                            permissions.append(',').append(value);
                            break;
                        }
                        default: {
                            log.error("Unknown OID!");
                            break;
                        }
                    }
                    continue;
                }
                log.warn("SubjectAltName of invalid type found: " + type);
            }
            if (permissions.length() > 0) {
                identity.setPermissions(permissions.toString());
            }
        }
        return identity;
    }

    public static String getElement(X500Name x500name, ASN1ObjectIdentifier objectId) {
        try {
            RDN cn = x500name.getRDNs(objectId)[0];
            return IETFUtils.valueToString(cn.getFirst().getValue());
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }
}

