/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.pki;

import java.beans.ConstructorProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CRLReason;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.maritimecloud.pki.CRLVerifier;
import net.maritimecloud.pki.CertificateBuilder;
import net.maritimecloud.pki.CertificateHandler;
import net.maritimecloud.pki.PKIConfiguration;
import net.maritimecloud.pki.Revocation;
import net.maritimecloud.pki.RevocationInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAHandler {
    private static final Logger log = LoggerFactory.getLogger(CAHandler.class);
    private CertificateBuilder certificateBuilder;
    private PKIConfiguration pkiConfiguration;

    public void createSubCa(String subCaCertDN) {
        X509Certificate subCaCert;
        String crlUrl;
        X500Name rootCertX500Name;
        KeyStore.PrivateKeyEntry rootCertEntry;
        KeyStore truststore;
        KeyStore subCaKeystore;
        KeyStore rootKeystore;
        FileInputStream rootKeystoreIS = null;
        FileInputStream subCaFis = null;
        FileInputStream trustFis = null;
        try {
            rootKeystore = KeyStore.getInstance("jks");
            rootKeystoreIS = new FileInputStream(this.pkiConfiguration.getRootCaKeystorePath());
            rootKeystore.load(rootKeystoreIS, this.pkiConfiguration.getRootCaKeystorePassword().toCharArray());
            subCaKeystore = KeyStore.getInstance("jks");
            if (new File(this.pkiConfiguration.getSubCaKeystorePath()).exists()) {
                subCaFis = new FileInputStream(this.pkiConfiguration.getSubCaKeystorePath());
                subCaKeystore.load(subCaFis, this.pkiConfiguration.getSubCaKeystorePassword().toCharArray());
            } else {
                subCaKeystore.load(null, this.pkiConfiguration.getSubCaKeystorePassword().toCharArray());
            }
            trustFis = new FileInputStream(this.pkiConfiguration.getTruststorePath());
            truststore = KeyStore.getInstance(KeyStore.getDefaultType());
            truststore.load(trustFis, this.pkiConfiguration.getTruststorePassword().toCharArray());
            this.safeClose(rootKeystoreIS);
            this.safeClose(trustFis);
            this.safeClose(subCaFis);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.safeClose(rootKeystoreIS);
                this.safeClose(trustFis);
                this.safeClose(subCaFis);
                throw throwable;
            }
        }
        KeyStore.PasswordProtection protParam = new KeyStore.PasswordProtection(this.pkiConfiguration.getRootCaKeystorePassword().toCharArray());
        try {
            rootCertEntry = (KeyStore.PrivateKeyEntry)rootKeystore.getEntry("urn:mrn:mcl:ca:maritimecloud", protParam);
            rootCertX500Name = new JcaX509CertificateHolder((X509Certificate)rootCertEntry.getCertificate()).getSubject();
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException | CertificateEncodingException e) {
            throw new RuntimeException(e);
        }
        try {
            List<String> crlPoints = CRLVerifier.getCrlDistributionPoints((X509Certificate)rootCertEntry.getCertificate());
            crlUrl = crlPoints.get(0);
        }
        catch (IOException | CertificateParsingException e) {
            throw new RuntimeException(e);
        }
        KeyPair subCaKeyPair = CertificateBuilder.generateKeyPair();
        X500Name subCaCertX500Name = new X500Name(subCaCertDN);
        String alias = CertificateHandler.getElement(subCaCertX500Name, BCStyle.UID);
        if (alias == null || alias.trim().isEmpty()) {
            throw new RuntimeException("UID must be defined for sub CA! It will be used as the sub CA alias.");
        }
        try {
            subCaCert = this.certificateBuilder.buildAndSignCert(this.certificateBuilder.generateSerialNumber(), rootCertEntry.getPrivateKey(), rootCertEntry.getCertificate().getPublicKey(), subCaKeyPair.getPublic(), rootCertX500Name, subCaCertX500Name, null, "INTERMEDIATE", null, crlUrl);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create sub CA certificate!", e);
        }
        FileOutputStream trustFos = null;
        FileOutputStream subCaFos = null;
        try {
            Certificate[] certChain = new Certificate[]{subCaCert, rootCertEntry.getCertificate()};
            subCaFos = new FileOutputStream(this.pkiConfiguration.getSubCaKeystorePath());
            subCaKeystore.setKeyEntry(alias, subCaKeyPair.getPrivate(), this.pkiConfiguration.getSubCaKeyPassword().toCharArray(), certChain);
            subCaKeystore.store(subCaFos, this.pkiConfiguration.getSubCaKeystorePassword().toCharArray());
            trustFos = new FileOutputStream(this.pkiConfiguration.getTruststorePath());
            truststore.setCertificateEntry(alias, subCaCert);
            truststore.store(trustFos, this.pkiConfiguration.getTruststorePassword().toCharArray());
            this.safeClose(trustFos);
            this.safeClose(subCaFos);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                this.safeClose(trustFos);
                this.safeClose(subCaFos);
                throw throwable;
            }
        }
    }

    public void initRootCA(String rootCertX500Name, String crlUrl) {
        KeyPair cakp = CertificateBuilder.generateKeyPair();
        FileOutputStream rootfos = null;
        FileOutputStream tsfos = null;
        try {
            X509Certificate cacert;
            KeyStore rootks = KeyStore.getInstance("jks");
            rootks.load(null, this.pkiConfiguration.getRootCaKeystorePassword().toCharArray());
            rootfos = new FileOutputStream(this.pkiConfiguration.getRootCaKeystorePath());
            try {
                cacert = this.certificateBuilder.buildAndSignCert(this.certificateBuilder.generateSerialNumber(), cakp.getPrivate(), cakp.getPublic(), cakp.getPublic(), new X500Name(rootCertX500Name), new X500Name(rootCertX500Name), null, "ROOTCA", null, crlUrl);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            Certificate[] certChain = new Certificate[]{cacert};
            rootks.setKeyEntry("urn:mrn:mcl:ca:maritimecloud", cakp.getPrivate(), this.pkiConfiguration.getRootCaKeyPassword().toCharArray(), certChain);
            rootks.store(rootfos, this.pkiConfiguration.getRootCaKeystorePassword().toCharArray());
            rootks = KeyStore.getInstance(KeyStore.getDefaultType());
            rootks.load(null, this.pkiConfiguration.getRootCaKeystorePassword().toCharArray());
            KeyStore ts = KeyStore.getInstance(KeyStore.getDefaultType());
            ts.load(null, this.pkiConfiguration.getTruststorePassword().toCharArray());
            tsfos = new FileOutputStream(this.pkiConfiguration.getTruststorePath());
            ts.setCertificateEntry("urn:mrn:mcl:ca:maritimecloud", cacert);
            ts.store(tsfos, this.pkiConfiguration.getTruststorePassword().toCharArray());
            this.safeClose(rootfos);
            this.safeClose(tsfos);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            try {
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                this.safeClose(rootfos);
                this.safeClose(tsfos);
                throw throwable;
            }
        }
    }

    private void safeClose(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void safeClose(OutputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public List<RevocationInfo> loadRevocationFile(String revocationFile) {
        String cvsSplitBy = ";";
        ArrayList<RevocationInfo> revocationInfos = new ArrayList<RevocationInfo>();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        try (BufferedReader br = new BufferedReader(new FileReader(revocationFile));){
            String csvLine;
            while ((csvLine = br.readLine()) != null) {
                if (csvLine.trim().isEmpty()) continue;
                String[] revocationInfoSplit = csvLine.split(cvsSplitBy);
                if (revocationInfoSplit.length != 3) {
                    throw new RuntimeException("Missing info from line: " + csvLine);
                }
                RevocationInfo info = new RevocationInfo();
                info.setSerialNumber(new BigInteger(revocationInfoSplit[0].trim()));
                info.setRevokeReason(CRLReason.values()[Revocation.getCRLReasonFromString(revocationInfoSplit[1].trim().toLowerCase())]);
                Date revokedAt = format.parse(revocationInfoSplit[2].trim());
                if (revokedAt == null) {
                    throw new RuntimeException("Invalid date format!");
                }
                info.setRevokedAt(revokedAt);
                revocationInfos.add(info);
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Could not find the revocation info file!", e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ParseException e) {
            throw new RuntimeException("Invalid date format!", e);
        }
        return revocationInfos;
    }

    public void generateRootCRL(String outputCaCrlPath, String revocationFile) {
        List<RevocationInfo> revocationInfos = this.loadRevocationFile(revocationFile);
        try {
            KeyStore rootks = KeyStore.getInstance("jks");
            FileInputStream readStream = new FileInputStream(this.pkiConfiguration.getRootCaKeystorePath());
            rootks.load(readStream, this.pkiConfiguration.getRootCaKeystorePassword().toCharArray());
            KeyStore.PasswordProtection protParam = new KeyStore.PasswordProtection(this.pkiConfiguration.getRootCaKeystorePassword().toCharArray());
            KeyStore.PrivateKeyEntry rootCertEntry = (KeyStore.PrivateKeyEntry)rootks.getEntry("urn:mrn:mcl:ca:maritimecloud", protParam);
            String rootCertX500Name = new JcaX509CertificateHolder((X509Certificate)rootCertEntry.getCertificate()).getSubject().toString();
            Revocation.generateRootCACRL(rootCertX500Name, revocationInfos, rootCertEntry, outputCaCrlPath);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException e) {
            throw new RuntimeException("Unable to generate RootCACRL", e);
        }
        catch (CertificateException e) {
            throw new RuntimeException("Could not load root certificate!", e);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Could not find root keystore!", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load root keystore!", e);
        }
    }

    @ConstructorProperties(value={"certificateBuilder", "pkiConfiguration"})
    public CAHandler(CertificateBuilder certificateBuilder, PKIConfiguration pkiConfiguration) {
        this.certificateBuilder = certificateBuilder;
        this.pkiConfiguration = pkiConfiguration;
    }
}

