/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.pki;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import net.maritimecloud.pki.PKIConfiguration;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeystoreHandler {
    private static final Logger log = LoggerFactory.getLogger(KeystoreHandler.class);
    private PKIConfiguration pkiConfiguration;

    public KeystoreHandler(PKIConfiguration pkiConfiguration) {
        this.pkiConfiguration = pkiConfiguration;
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public KeyStore.PrivateKeyEntry getSigningCertEntry(String alias) {
        FileInputStream is;
        try {
            is = new FileInputStream(this.pkiConfiguration.getSubCaKeystorePath());
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        try {
            KeyStore keystore = KeyStore.getInstance("jks");
            keystore.load(is, this.pkiConfiguration.getSubCaKeystorePassword().toCharArray());
            KeyStore.PasswordProtection protParam = new KeyStore.PasswordProtection(this.pkiConfiguration.getSubCaKeyPassword().toCharArray());
            return (KeyStore.PrivateKeyEntry)keystore.getEntry(alias, protParam);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException | CertificateException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public Certificate getMCCertificate(String alias) {
        FileInputStream is;
        log.debug(this.pkiConfiguration.getTruststorePath());
        try {
            is = new FileInputStream(this.pkiConfiguration.getTruststorePath());
        }
        catch (FileNotFoundException e) {
            log.error("Could not open truststore", (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        try {
            KeyStore keystore = KeyStore.getInstance("jks");
            keystore.load(is, this.pkiConfiguration.getTruststorePassword().toCharArray());
            return keystore.getCertificate(alias);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            log.error("Could not load root certificate", (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public KeyStore getTrustStore() {
        FileInputStream is;
        try {
            is = new FileInputStream(this.pkiConfiguration.getTruststorePath());
        }
        catch (FileNotFoundException e) {
            log.error("Could not open truststore", (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        try {
            KeyStore keystore = KeyStore.getInstance("jks");
            keystore.load(is, this.pkiConfiguration.getTruststorePassword().toCharArray());
            return keystore;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            log.error("Could not load truststore!", (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public PublicKey getRootPubKey() {
        Certificate rootCert = this.getMCCertificate("urn:mrn:mcl:ca:maritimecloud");
        return rootCert.getPublicKey();
    }

    public PublicKey getPubKey(String alias) {
        Certificate cert = this.getMCCertificate(alias);
        return cert.getPublicKey();
    }
}

