/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.pki;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.ECGenParameterSpec;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import net.maritimecloud.pki.CertificateHandler;
import net.maritimecloud.pki.KeystoreHandler;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.X509KeyUsage;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateBuilder {
    private static final Logger log = LoggerFactory.getLogger(CertificateBuilder.class);
    private KeystoreHandler keystoreHandler;
    private SecureRandom random;

    public CertificateBuilder(KeystoreHandler keystoreHandler) {
        this.keystoreHandler = keystoreHandler;
        this.random = new SecureRandom();
    }

    public X509Certificate buildAndSignCert(BigInteger serialNumber, PrivateKey signerPrivateKey, PublicKey signerPublicKey, PublicKey subjectPublicKey, X500Name issuer, X500Name subject, Map<String, String> customAttrs, String type, String ocspUrl, String crlUrl) throws Exception {
        Calendar cal = Calendar.getInstance();
        Date now = cal.getTime();
        Date expire = new GregorianCalendar(2025, 0, 1).getTime();
        JcaX509v3CertificateBuilder certV3Bldr = new JcaX509v3CertificateBuilder(issuer, serialNumber, now, expire, subject, subjectPublicKey);
        JcaX509ExtensionUtils extensionUtil = new JcaX509ExtensionUtils();
        if ("ROOTCA".equals(type)) {
            certV3Bldr = certV3Bldr.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(true)).addExtension(Extension.keyUsage, true, (ASN1Encodable)new X509KeyUsage(230));
        } else if ("INTERMEDIATE".equals(type)) {
            certV3Bldr = certV3Bldr.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(true)).addExtension(Extension.keyUsage, true, (ASN1Encodable)new X509KeyUsage(230));
        } else {
            GeneralName[] genNames = null;
            if (customAttrs != null && !customAttrs.isEmpty()) {
                genNames = new GeneralName[customAttrs.size()];
                Iterator<Map.Entry<String, String>> it = customAttrs.entrySet().iterator();
                int idx = 0;
                while (it.hasNext()) {
                    Map.Entry<String, String> pair = it.next();
                    DERSequence othernameSequence = new DERSequence(new ASN1Encodable[]{new ASN1ObjectIdentifier(pair.getKey()), new DERTaggedObject(true, 0, (ASN1Encodable)new DERUTF8String(pair.getValue()))});
                    genNames[idx] = new GeneralName(0, (ASN1Encodable)othernameSequence);
                    ++idx;
                }
            }
            if (genNames != null) {
                certV3Bldr = certV3Bldr.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)new GeneralNames(genNames));
            }
        }
        certV3Bldr = certV3Bldr.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)extensionUtil.createAuthorityKeyIdentifier(signerPublicKey)).addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)extensionUtil.createSubjectKeyIdentifier(subjectPublicKey));
        DistributionPointName distPointOne = new DistributionPointName(new GeneralNames(new GeneralName(6, crlUrl)));
        DistributionPoint[] distPoints = new DistributionPoint[]{new DistributionPoint(distPointOne, null, null)};
        certV3Bldr.addExtension(Extension.cRLDistributionPoints, false, (ASN1Encodable)new CRLDistPoint(distPoints));
        if (ocspUrl != null) {
            GeneralName ocspName = new GeneralName(6, ocspUrl);
            AuthorityInformationAccess authorityInformationAccess = new AuthorityInformationAccess(X509ObjectIdentifiers.ocspAccessMethod, ocspName);
            certV3Bldr.addExtension(Extension.authorityInfoAccess, false, (ASN1Encodable)authorityInformationAccess);
        }
        JcaContentSignerBuilder builder = new JcaContentSignerBuilder("SHA256withECDSA");
        builder.setProvider("BC");
        ContentSigner signer = builder.build(signerPrivateKey);
        return new JcaX509CertificateConverter().setProvider("BC").getCertificate(certV3Bldr.build(signer));
    }

    public X509Certificate generateCertForEntity(BigInteger serialNumber, String country, String orgName, String type, String callName, String email, String uid, PublicKey publickey, Map<String, String> customAttr, String signingAlias, String baseCrlOcspURI) throws Exception {
        String[] locales;
        KeyStore.PrivateKeyEntry signingCertEntry = this.keystoreHandler.getSigningCertEntry(signingAlias);
        Certificate signingCert = signingCertEntry.getCertificate();
        X509Certificate signingX509Cert = (X509Certificate)signingCert;
        String orgCountryCode = country;
        for (String countryCode : locales = Locale.getISOCountries()) {
            Locale loc = new Locale("", countryCode);
            if (!loc.getDisplayCountry(Locale.ENGLISH).equals(orgCountryCode)) continue;
            orgCountryCode = loc.getCountry();
            break;
        }
        String orgSubjectDn = "C=" + orgCountryCode + ", O=" + orgName + ", OU=" + type + ", CN=" + callName + ", UID=" + uid;
        if (email != null && !email.isEmpty()) {
            orgSubjectDn = orgSubjectDn + ", E=" + email;
        }
        X500Name subCaCertX500Name = new X500Name(signingX509Cert.getSubjectDN().getName());
        String alias = CertificateHandler.getElement(subCaCertX500Name, BCStyle.UID);
        String ocspUrl = baseCrlOcspURI + "ocsp/" + alias;
        String crlUrl = baseCrlOcspURI + "crl/" + alias;
        return this.buildAndSignCert(serialNumber, signingCertEntry.getPrivateKey(), signingX509Cert.getPublicKey(), publickey, new JcaX509CertificateHolder(signingX509Cert).getSubject(), new X500Name(orgSubjectDn), customAttr, "ENTITY", ocspUrl, crlUrl);
    }

    public static KeyPair generateKeyPair() {
        KeyPairGenerator g;
        ECGenParameterSpec ecGenSpec = new ECGenParameterSpec("secp384r1");
        try {
            g = KeyPairGenerator.getInstance("ECDSA", "BC");
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        try {
            g.initialize(ecGenSpec, new SecureRandom());
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return g.generateKeyPair();
    }

    public BigInteger generateSerialNumber() {
        BigInteger maxValue = new BigInteger("730750818665451459101842416358141509827966271487");
        BigInteger minValue = new BigInteger("4294967296");
        return BigIntegers.createRandomInRange((BigInteger)minValue, (BigInteger)maxValue, (SecureRandom)this.random);
    }
}

