/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.yamlkt.internal;

import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import net.mamoe.yamlkt.internal.HexConverter;
import net.mamoe.yamlkt.internal.Stack;
import net.mamoe.yamlkt.internal.StringBufHolder;
import net.mamoe.yamlkt.internal.Token;
import net.mamoe.yamlkt.internal.YamlUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u0017J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\tJ\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u0019H\u0002J\u000e\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u0003J\u000e\u0010 \u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u001cJ\u0016\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u0006R\u0012\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\t8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u00020\r8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lnet/mamoe/yamlkt/internal/TokenStream;", "Lnet/mamoe/yamlkt/internal/StringBufHolder;", "source", "", "(Ljava/lang/String;)V", "cur", "", "currentIndent", "endOfInput", "", "getEndOfInput", "()Z", "escapeBuff", "", "escapeCount", "leadingSpace", "newLined", "quoted", "reuseTokenStack", "Lnet/mamoe/yamlkt/internal/Stack;", "", "strBuff", "appendEsc", "", "c", "", "flushEsc", "nextToken", "Lnet/mamoe/yamlkt/internal/Token;", "stopOnComma", "prepareStringAndNextToken", "begin", "reuseToken", "string", "token", "subSourceTrimEnd", "offset", "endIndex", "yamlkt"})
public final class TokenStream
extends StringBufHolder {
    @JvmField
    @NotNull
    public final String source;
    @JvmField
    public int cur;
    @JvmField
    public int currentIndent;
    @JvmField
    public int leadingSpace;
    @JvmField
    @Nullable
    public String strBuff;
    @JvmField
    public boolean quoted;
    @JvmField
    public boolean newLined;
    @JvmField
    public int escapeCount;
    @JvmField
    @NotNull
    public final char[] escapeBuff;
    @NotNull
    private final Stack<Object> reuseTokenStack;

    public TokenStream(@NotNull String source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.source = source;
        this.escapeBuff = new char[16];
        this.reuseTokenStack = new Stack();
    }

    public final boolean getEndOfInput() {
        boolean $i$f$getEndOfInput = false;
        return this.cur == this.source.length();
    }

    @NotNull
    public final String subSourceTrimEnd(int offset, int endIndex) {
        int n = endIndex - 1;
        if (offset <= n) {
            int i;
            do {
                if (this.source.charAt(i = n--) == ' ') continue;
                String string = this.source;
                int n2 = i + 1;
                boolean bl = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(offset, n2);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                return string3;
            } while (i != offset);
        }
        return "";
    }

    public final void flushEsc() {
        if (this.escapeCount == 0) {
            return;
        }
        this.append((char)HexConverter.INSTANCE.hexToLong(this.escapeBuff, 0, this.escapeCount));
        this.escapeCount = 0;
    }

    public final void appendEsc(char c) {
        TokenStream tokenStream = this;
        int n = tokenStream.escapeCount;
        tokenStream.escapeCount = n + 1;
        this.escapeBuff[n] = c;
        if (this.escapeCount == 4) {
            this.flushEsc();
        }
    }

    public final void reuseToken(@NotNull Token token) {
        Intrinsics.checkNotNullParameter((Object)((Object)token), (String)"token");
        this.reuseTokenStack.add((Object)token);
    }

    public final void reuseToken(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        this.reuseTokenStack.add(string);
    }

    @Nullable
    public final Token nextToken(boolean stopOnComma) {
        block14: {
            String str;
            char c;
            Object reuse = this.reuseTokenStack.popOrNull();
            if (reuse != null) {
                Token token;
                if (reuse instanceof String) {
                    this.strBuff = (String)reuse;
                    token = Token.STRING;
                } else {
                    token = (Token)((Object)reuse);
                }
                return token;
            }
            this.newLined = false;
            this.leadingSpace = 0;
            TokenStream $this$whileNotEOF$iv = this;
            boolean $i$f$whileNotEOF = false;
            boolean bl = false;
            while (true) {
                TokenStream this_$iv$iv = $this$whileNotEOF$iv;
                boolean $i$f$getEndOfInput = false;
                if (this_$iv$iv.cur == this_$iv$iv.source.length()) break block14;
                TokenStream tokenStream = $this$whileNotEOF$iv;
                int n = tokenStream.cur;
                tokenStream.cur = n + 1;
                c = $this$whileNotEOF$iv.source.charAt(n);
                boolean bl2 = false;
                if (c == ' ') {
                    TokenStream tokenStream2 = this;
                    int n2 = tokenStream2.currentIndent;
                    tokenStream2.currentIndent = n2 + 1;
                    tokenStream2 = this;
                    n2 = tokenStream2.leadingSpace;
                    tokenStream2.leadingSpace = n2 + 1;
                    continue;
                }
                char c2 = c;
                if (c2 == ':') {
                    TokenStream tokenStream3 = this;
                    int n3 = tokenStream3.currentIndent;
                    tokenStream3.currentIndent = n3 + 1;
                    return Token.COLON;
                }
                if (c2 == '\n' ? true : c2 == '\r') {
                    this.newLined = true;
                    this.currentIndent = 0;
                    this.leadingSpace = 0;
                    continue;
                }
                if (c2 == ',') {
                    TokenStream tokenStream4 = this;
                    int n4 = tokenStream4.currentIndent;
                    tokenStream4.currentIndent = n4 + 1;
                    return Token.COMMA;
                }
                if (c2 == '{') {
                    TokenStream tokenStream5 = this;
                    int n5 = tokenStream5.currentIndent;
                    tokenStream5.currentIndent = n5 + 1;
                    return Token.MAP_BEGIN;
                }
                if (c2 == '}') {
                    TokenStream tokenStream6 = this;
                    int n6 = tokenStream6.currentIndent;
                    tokenStream6.currentIndent = n6 + 1;
                    return Token.MAP_END;
                }
                if (c2 == '[') {
                    TokenStream tokenStream7 = this;
                    int n7 = tokenStream7.currentIndent;
                    tokenStream7.currentIndent = n7 + 1;
                    return Token.LIST_BEGIN;
                }
                if (c2 == ']') {
                    TokenStream tokenStream8 = this;
                    int n8 = tokenStream8.currentIndent;
                    tokenStream8.currentIndent = n8 + 1;
                    return Token.LIST_END;
                }
                if (c2 == '-') {
                    TokenStream tokenStream9 = this;
                    int n9 = tokenStream9.currentIndent;
                    tokenStream9.currentIndent = n9 + 1;
                    return Token.MULTILINE_LIST_FLAG;
                }
                if (c2 != '#') break;
                YamlUtils.skipLine(this);
                this.currentIndent = 0;
            }
            String string = this.prepareStringAndNextToken(stopOnComma, c);
            if (string == null) {
                return Token.STRING_NULL;
            }
            this.strBuff = str = string;
            return Token.STRING;
        }
        return null;
    }

    private final String prepareStringAndNextToken(boolean stopOnComma, char begin) {
        String string;
        block12: {
            block13: {
                char c;
                block11: {
                    c = begin;
                    if (c != '\'') break block11;
                    this.quoted = true;
                    string = YamlUtils.readSingleQuotedString(this);
                    break block12;
                }
                if (c != '\"') break block13;
                this.quoted = true;
                string = YamlUtils.readDoubleQuotedString(this);
                break block12;
            }
            this.quoted = false;
            String $this$optimizeNull$iv = YamlUtils.readUnquotedString(this, stopOnComma, begin);
            boolean $i$f$optimizeNull = false;
            switch ($this$optimizeNull$iv) {
                case "NULL": 
                case "null": 
                case "~": {
                    string = null;
                    break;
                }
                default: {
                    string = $this$optimizeNull$iv;
                }
            }
        }
        return string;
    }
}

