/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.pattern;

import java.util.Objects;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.message.MapMessage;

@Plugin(name="MapPatternConverter", category="Converter")
@ConverterKeys(value={"K", "map", "MAP"})
public final class MapPatternConverter
extends LogEventPatternConverter {
    private static final String JAVA_UNQUOTED = MapMessage.MapFormat.JAVA_UNQUOTED.name();
    private final String key;
    private final String[] format;

    private MapPatternConverter(String[] options2, String ... format2) {
        super(options2 != null && options2.length > 0 ? "MAP{" + options2[0] + '}' : "MAP", "map");
        this.key = options2 != null && options2.length > 0 ? options2[0] : null;
        this.format = format2;
    }

    public static MapPatternConverter newInstance(String[] options2) {
        return new MapPatternConverter(options2, JAVA_UNQUOTED);
    }

    public static MapPatternConverter newInstance(String[] options2, MapMessage.MapFormat format2) {
        return new MapPatternConverter(options2, Objects.toString((Object)format2, JAVA_UNQUOTED));
    }

    @Override
    public void format(LogEvent event, StringBuilder toAppendTo) {
        if (!(event.getMessage() instanceof MapMessage)) {
            return;
        }
        MapMessage msg = (MapMessage)event.getMessage();
        if (this.key == null) {
            msg.formatTo(this.format, toAppendTo);
        } else {
            String val = msg.get(this.key);
            if (val != null) {
                toAppendTo.append(val);
            }
        }
    }
}

