/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender.mom.jeromq;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.appender.AbstractManager;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.util.Cancellable;
import org.apache.logging.log4j.core.util.ShutdownCallbackRegistry;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.zeromq.ZMQ;

public class JeroMqManager
extends AbstractManager {
    public static final String SYS_PROPERTY_ENABLE_SHUTDOWN_HOOK = "log4j.jeromq.enableShutdownHook";
    public static final String SYS_PROPERTY_IO_THREADS = "log4j.jeromq.ioThreads";
    private static final JeroMqManagerFactory FACTORY = new JeroMqManagerFactory();
    private static final ZMQ.Context CONTEXT;
    private static final Cancellable SHUTDOWN_HOOK;
    private final ZMQ.Socket publisher = CONTEXT.socket(1);

    private JeroMqManager(String name, JeroMqConfiguration config2) {
        super(null, name);
        this.publisher.setAffinity(config2.affinity);
        this.publisher.setBacklog(config2.backlog);
        this.publisher.setDelayAttachOnConnect(config2.delayAttachOnConnect);
        if (config2.identity != null) {
            this.publisher.setIdentity(config2.identity);
        }
        this.publisher.setIPv4Only(config2.ipv4Only);
        this.publisher.setLinger(config2.linger);
        this.publisher.setMaxMsgSize(config2.maxMsgSize);
        this.publisher.setRcvHWM(config2.rcvHwm);
        this.publisher.setReceiveBufferSize(config2.receiveBufferSize);
        this.publisher.setReceiveTimeOut(config2.receiveTimeOut);
        this.publisher.setReconnectIVL(config2.reconnectIVL);
        this.publisher.setReconnectIVLMax(config2.reconnectIVLMax);
        this.publisher.setSendBufferSize(config2.sendBufferSize);
        this.publisher.setSendTimeOut(config2.sendTimeOut);
        this.publisher.setSndHWM(config2.sndHwm);
        this.publisher.setTCPKeepAlive(config2.tcpKeepAlive);
        this.publisher.setTCPKeepAliveCount(config2.tcpKeepAliveCount);
        this.publisher.setTCPKeepAliveIdle(config2.tcpKeepAliveIdle);
        this.publisher.setTCPKeepAliveInterval(config2.tcpKeepAliveInterval);
        this.publisher.setXpubVerbose(config2.xpubVerbose);
        for (String endpoint : config2.endpoints) {
            this.publisher.bind(endpoint);
        }
        LOGGER.debug("Created JeroMqManager with {}", (Object)config2);
    }

    public boolean send(byte[] data2) {
        return this.publisher.send(data2);
    }

    @Override
    protected boolean releaseSub(long timeout2, TimeUnit timeUnit) {
        this.publisher.close();
        return true;
    }

    public static JeroMqManager getJeroMqManager(String name, long affinity, long backlog, boolean delayAttachOnConnect, byte[] identity, boolean ipv4Only, long linger, long maxMsgSize, long rcvHwm, long receiveBufferSize, int receiveTimeOut, long reconnectIVL, long reconnectIVLMax, long sendBufferSize, int sendTimeOut, long sndHwm, int tcpKeepAlive, long tcpKeepAliveCount, long tcpKeepAliveIdle, long tcpKeepAliveInterval, boolean xpubVerbose, List<String> endpoints) {
        return JeroMqManager.getManager(name, FACTORY, new JeroMqConfiguration(affinity, backlog, delayAttachOnConnect, identity, ipv4Only, linger, maxMsgSize, rcvHwm, receiveBufferSize, receiveTimeOut, reconnectIVL, reconnectIVLMax, sendBufferSize, sendTimeOut, sndHwm, tcpKeepAlive, tcpKeepAliveCount, tcpKeepAliveIdle, tcpKeepAliveInterval, xpubVerbose, endpoints));
    }

    public static ZMQ.Context getContext() {
        return CONTEXT;
    }

    static {
        LOGGER.trace("JeroMqManager using ZMQ version {}", (Object)ZMQ.getVersionString());
        int ioThreads = PropertiesUtil.getProperties().getIntegerProperty(SYS_PROPERTY_IO_THREADS, 1);
        LOGGER.trace("JeroMqManager creating ZMQ context with ioThreads = {}", (Object)ioThreads);
        CONTEXT = ZMQ.context((int)ioThreads);
        boolean enableShutdownHook = PropertiesUtil.getProperties().getBooleanProperty(SYS_PROPERTY_ENABLE_SHUTDOWN_HOOK, true);
        SHUTDOWN_HOOK = enableShutdownHook ? ((ShutdownCallbackRegistry)((Object)LogManager.getFactory())).addShutdownCallback(() -> ((ZMQ.Context)CONTEXT).close()) : null;
    }

    private static class JeroMqManagerFactory
    implements ManagerFactory<JeroMqManager, JeroMqConfiguration> {
        private JeroMqManagerFactory() {
        }

        @Override
        public JeroMqManager createManager(String name, JeroMqConfiguration data2) {
            return new JeroMqManager(name, data2);
        }
    }

    private static class JeroMqConfiguration {
        private final long affinity;
        private final long backlog;
        private final boolean delayAttachOnConnect;
        private final byte[] identity;
        private final boolean ipv4Only;
        private final long linger;
        private final long maxMsgSize;
        private final long rcvHwm;
        private final long receiveBufferSize;
        private final int receiveTimeOut;
        private final long reconnectIVL;
        private final long reconnectIVLMax;
        private final long sendBufferSize;
        private final int sendTimeOut;
        private final long sndHwm;
        private final int tcpKeepAlive;
        private final long tcpKeepAliveCount;
        private final long tcpKeepAliveIdle;
        private final long tcpKeepAliveInterval;
        private final boolean xpubVerbose;
        private final List<String> endpoints;

        private JeroMqConfiguration(long affinity, long backlog, boolean delayAttachOnConnect, byte[] identity, boolean ipv4Only, long linger, long maxMsgSize, long rcvHwm, long receiveBufferSize, int receiveTimeOut, long reconnectIVL, long reconnectIVLMax, long sendBufferSize, int sendTimeOut, long sndHwm, int tcpKeepAlive, long tcpKeepAliveCount, long tcpKeepAliveIdle, long tcpKeepAliveInterval, boolean xpubVerbose, List<String> endpoints) {
            this.affinity = affinity;
            this.backlog = backlog;
            this.delayAttachOnConnect = delayAttachOnConnect;
            this.identity = identity;
            this.ipv4Only = ipv4Only;
            this.linger = linger;
            this.maxMsgSize = maxMsgSize;
            this.rcvHwm = rcvHwm;
            this.receiveBufferSize = receiveBufferSize;
            this.receiveTimeOut = receiveTimeOut;
            this.reconnectIVL = reconnectIVL;
            this.reconnectIVLMax = reconnectIVLMax;
            this.sendBufferSize = sendBufferSize;
            this.sendTimeOut = sendTimeOut;
            this.sndHwm = sndHwm;
            this.tcpKeepAlive = tcpKeepAlive;
            this.tcpKeepAliveCount = tcpKeepAliveCount;
            this.tcpKeepAliveIdle = tcpKeepAliveIdle;
            this.tcpKeepAliveInterval = tcpKeepAliveInterval;
            this.xpubVerbose = xpubVerbose;
            this.endpoints = endpoints;
        }

        public String toString() {
            return "JeroMqConfiguration{affinity=" + this.affinity + ", backlog=" + this.backlog + ", delayAttachOnConnect=" + this.delayAttachOnConnect + ", identity=" + Arrays.toString(this.identity) + ", ipv4Only=" + this.ipv4Only + ", linger=" + this.linger + ", maxMsgSize=" + this.maxMsgSize + ", rcvHwm=" + this.rcvHwm + ", receiveBufferSize=" + this.receiveBufferSize + ", receiveTimeOut=" + this.receiveTimeOut + ", reconnectIVL=" + this.reconnectIVL + ", reconnectIVLMax=" + this.reconnectIVLMax + ", sendBufferSize=" + this.sendBufferSize + ", sendTimeOut=" + this.sendTimeOut + ", sndHwm=" + this.sndHwm + ", tcpKeepAlive=" + this.tcpKeepAlive + ", tcpKeepAliveCount=" + this.tcpKeepAliveCount + ", tcpKeepAliveIdle=" + this.tcpKeepAliveIdle + ", tcpKeepAliveInterval=" + this.tcpKeepAliveInterval + ", xpubVerbose=" + this.xpubVerbose + ", endpoints=" + this.endpoints + '}';
        }
    }
}

