/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import org.jetbrains.annotations.NotNull;

public abstract class ErrorValue
extends ConstantValue<Unit> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public ErrorValue() {
        super(Unit.INSTANCE);
    }

    @Override
    @NotNull
    public Unit getValue() {
        throw new UnsupportedOperationException();
    }

    public static final class ErrorValueWithMessage
    extends ErrorValue {
        @NotNull
        private final String message;

        public ErrorValueWithMessage(@NotNull String message2) {
            Intrinsics.checkNotNullParameter(message2, "message");
            this.message = message2;
        }

        @Override
        @NotNull
        public SimpleType getType(@NotNull ModuleDescriptor module) {
            Intrinsics.checkNotNullParameter(module, "module");
            SimpleType simpleType2 = ErrorUtils.createErrorType(this.message);
            Intrinsics.checkNotNullExpressionValue(simpleType2, "createErrorType(message)");
            return simpleType2;
        }

        @Override
        @NotNull
        public String toString() {
            return this.message;
        }
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ErrorValue create(@NotNull String message2) {
            Intrinsics.checkNotNullParameter(message2, "message");
            return new ErrorValueWithMessage(message2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

