/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.cio.internals;

import io.ktor.http.cio.internals.BytePacketUtilsKt;
import io.ktor.util.cio.ByteBufferPoolKt;
import io.ktor.utils.io.core.BytePacketBuilder;
import io.ktor.utils.io.core.ByteReadPacket;
import io.ktor.utils.io.core.OutputArraysJVMKt;
import io.ktor.utils.io.core.PacketJVMKt;
import io.ktor.utils.io.core.StringsKt;
import io.ktor.utils.io.pool.ObjectPool;
import java.nio.ByteBuffer;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0003\u001a\u00020\u0001*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001H\u0000\u001a$\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0014\u0010\u000e\u001a\u00020\u0001*\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0001H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"EMPTY_CHUNK", "", "PADDED_EMPTY_CHUNK", "deflateFully", "Ljava/util/zip/Deflater;", "data", "deflateTo", "", "Lio/ktor/utils/io/core/BytePacketBuilder;", "deflater", "buffer", "Ljava/nio/ByteBuffer;", "flush", "", "inflateFully", "Ljava/util/zip/Inflater;", "ktor-http-cio"})
public final class DeflaterUtilsKt {
    private static final byte[] PADDED_EMPTY_CHUNK = new byte[]{0, 0, 0, (byte)255, (byte)255};
    private static final byte[] EMPTY_CHUNK = new byte[]{0, 0, (byte)255, (byte)255};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final byte[] deflateFully(@NotNull Deflater $this$deflateFully, @NotNull byte[] data2) {
        ByteReadPacket byteReadPacket;
        ByteReadPacket byteReadPacket2;
        BytePacketBuilder $this$buildPacket;
        Intrinsics.checkNotNullParameter($this$deflateFully, "$this$deflateFully");
        Intrinsics.checkNotNullParameter(data2, "data");
        $this$deflateFully.setInput(data2);
        int headerSizeHint$iv2 = 0;
        boolean $i$f$buildPacket = false;
        boolean bl = false;
        BytePacketBuilder builder$iv2 = PacketJVMKt.BytePacketBuilder(headerSizeHint$iv2);
        try {
            $this$buildPacket = builder$iv2;
            boolean bl2 = false;
            ObjectPool<ByteBuffer> $this$useInstance$iv = ByteBufferPoolKt.getKtorDefaultPool();
            boolean $i$f$useInstance = false;
            ByteBuffer instance$iv = $this$useInstance$iv.borrow();
            try {
                ByteBuffer buffer = instance$iv;
                boolean bl3 = false;
                while (!$this$deflateFully.needsInput()) {
                    DeflaterUtilsKt.deflateTo($this$buildPacket, $this$deflateFully, buffer, false);
                }
                while (DeflaterUtilsKt.deflateTo($this$buildPacket, $this$deflateFully, buffer, true) != 0) {
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                $this$useInstance$iv.recycle(instance$iv);
            }
            byteReadPacket2 = builder$iv2.build();
        }
        catch (Throwable t$iv) {
            builder$iv2.release();
            throw t$iv;
        }
        ByteReadPacket deflatedBytes = byteReadPacket2;
        if (BytePacketUtilsKt.endsWith(deflatedBytes, PADDED_EMPTY_CHUNK)) {
            byte[] headerSizeHint$iv2 = StringsKt.readBytes(deflatedBytes, (int)deflatedBytes.getRemaining() - EMPTY_CHUNK.length);
            $i$f$buildPacket = false;
            boolean builder$iv2 = false;
            byte[] it = headerSizeHint$iv2;
            boolean bl4 = false;
            deflatedBytes.release();
            return headerSizeHint$iv2;
        }
        headerSizeHint$iv2 = 0;
        $i$f$buildPacket = false;
        boolean builder$iv2 = false;
        BytePacketBuilder builder$iv22 = PacketJVMKt.BytePacketBuilder(headerSizeHint$iv2);
        try {
            $this$buildPacket = builder$iv22;
            boolean bl5 = false;
            $this$buildPacket.writePacket(deflatedBytes);
            $this$buildPacket.writeByte((byte)0);
            byteReadPacket = builder$iv22.build();
        }
        catch (Throwable t$iv) {
            builder$iv22.release();
            throw t$iv;
        }
        return StringsKt.readBytes$default(byteReadPacket, 0, 1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final byte[] inflateFully(@NotNull Inflater $this$inflateFully, @NotNull byte[] data2) {
        ByteReadPacket byteReadPacket;
        Intrinsics.checkNotNullParameter($this$inflateFully, "$this$inflateFully");
        Intrinsics.checkNotNullParameter(data2, "data");
        byte[] dataToInflate = ArraysKt.plus(data2, EMPTY_CHUNK);
        $this$inflateFully.setInput(dataToInflate);
        int headerSizeHint$iv = 0;
        boolean $i$f$buildPacket = false;
        boolean bl = false;
        BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder(headerSizeHint$iv);
        try {
            BytePacketBuilder $this$buildPacket = builder$iv;
            boolean bl2 = false;
            ObjectPool<ByteBuffer> $this$useInstance$iv = ByteBufferPoolKt.getKtorDefaultPool();
            boolean $i$f$useInstance = false;
            ByteBuffer instance$iv = $this$useInstance$iv.borrow();
            try {
                ByteBuffer buffer = instance$iv;
                boolean bl3 = false;
                long limit = (long)dataToInflate.length + $this$inflateFully.getBytesRead();
                while ($this$inflateFully.getBytesRead() < limit) {
                    buffer.clear();
                    int inflated = $this$inflateFully.inflate(buffer.array(), buffer.position(), buffer.limit());
                    buffer.position(buffer.position() + inflated);
                    buffer.flip();
                    OutputArraysJVMKt.writeFully($this$buildPacket, buffer);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                $this$useInstance$iv.recycle(instance$iv);
            }
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        ByteReadPacket packet = byteReadPacket;
        return StringsKt.readBytes$default(packet, 0, 1, null);
    }

    private static final int deflateTo(BytePacketBuilder $this$deflateTo, Deflater deflater, ByteBuffer buffer, boolean flush2) {
        int deflated2;
        buffer.clear();
        int n = deflated2 = flush2 ? deflater.deflate(buffer.array(), buffer.position(), buffer.limit(), 2) : deflater.deflate(buffer.array(), buffer.position(), buffer.limit());
        if (deflated2 == 0) {
            return 0;
        }
        buffer.position(buffer.position() + deflated2);
        buffer.flip();
        OutputArraysJVMKt.writeFully($this$deflateTo, buffer);
        return deflated2;
    }
}

