/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.utils;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u001a \u0010\u0002\u001a\u00020\u0003*\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0002\u001a*\u0010\t\u001a\u00020\u0003*\u00020\u00042\b\b\u0002\u0010\n\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\u00032\b\b\u0002\u0010\f\u001a\u00020\rH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"loginSolverLock", "Lkotlinx/coroutines/sync/Mutex;", "createCharImg", "", "Ljava/awt/image/BufferedImage;", "outputWidth", "", "ignoreRate", "", "renderQRCode", "blackPlaceholder", "whitePlaceholder", "doColorSwitch", "", "mirai-core-api"})
public final class LoginSolver_jvmKt {
    @NotNull
    private static final Mutex loginSolverLock = MutexKt.Mutex$default(false, 1, null);

    private static final String createCharImg(BufferedImage $this$createCharImg, int outputWidth, double ignoreRate) {
        StringBuilder stringBuilder;
        int newHeight = (int)((double)$this$createCharImg.getHeight() * ((double)outputWidth / (double)$this$createCharImg.getWidth()));
        Image tmp = $this$createCharImg.getScaledInstance(outputWidth, newHeight, 4);
        BufferedImage image = new BufferedImage(outputWidth, newHeight, 2);
        Graphics2D g2d = image.createGraphics();
        g2d.drawImage(tmp, 0, 0, null);
        int background = LoginSolver_jvmKt.createCharImg$gray(image.getRGB(0, 0));
        int n = $this$createCharImg.getHeight();
        StringBuilder $this$createCharImg_u24lambda_u240 = stringBuilder = new StringBuilder(n);
        boolean bl = false;
        List lines = new ArrayList();
        int minXPos = outputWidth;
        int maxXPos = 0;
        int n2 = image.getHeight();
        for (int y = 0; y < n2; ++y) {
            StringBuilder builderLine = new StringBuilder();
            int n3 = image.getWidth();
            for (int x = 0; x < n3; ++x) {
                int gray = LoginSolver_jvmKt.createCharImg$gray(image.getRGB(x, y));
                if (LoginSolver_jvmKt.createCharImg$grayCompare(ignoreRate, gray, background)) {
                    builderLine.append(" ");
                    continue;
                }
                builderLine.append("#");
                if (x < minXPos) {
                    minXPos = x;
                }
                if (x <= maxXPos) continue;
                maxXPos = x;
            }
            String string = builderLine.toString();
            Intrinsics.checkNotNullExpressionValue(string, "builderLine.toString()");
            if (StringsKt.isBlank(string)) continue;
            lines.add(builderLine);
        }
        for (StringBuilder line : lines) {
            $this$createCharImg_u24lambda_u240.append(line.substring(minXPos, maxXPos)).append("\n");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder(capacity).\u2026builderAction).toString()");
        return string;
    }

    static /* synthetic */ String createCharImg$default(BufferedImage bufferedImage, int n, double d, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 100;
        }
        if ((n2 & 2) != 0) {
            d = 0.95;
        }
        return LoginSolver_jvmKt.createCharImg(bufferedImage, n, d);
    }

    private static final String renderQRCode(BufferedImage $this$renderQRCode, String blackPlaceholder, String whitePlaceholder, boolean doColorSwitch) {
        Boolean lastStatus = null;
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        String BLACK = "\u001b[30;40m";
        String WHITE = "\u001b[97;107m";
        String RESET = "\u001b[0m";
        int n = $this$renderQRCode.getHeight();
        for (int y = 0; y < n; ++y) {
            int n2 = $this$renderQRCode.getWidth();
            for (int x = 0; x < n2; ++x) {
                int rgbcolor = $this$renderQRCode.getRGB(x, y);
                boolean crtStatus = LoginSolver_jvmKt.renderQRCode$isBlackBlock(rgbcolor);
                if (doColorSwitch && !Intrinsics.areEqual(crtStatus, lastStatus)) {
                    lastStatus = crtStatus;
                    sb.append(crtStatus ? BLACK : WHITE);
                }
                sb.append(crtStatus ? blackPlaceholder : whitePlaceholder);
            }
            if (doColorSwitch) {
                sb.append(RESET);
            }
            sb.append("\n");
            lastStatus = null;
        }
        if (doColorSwitch) {
            sb.append(RESET);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string, "sb.toString()");
        return string;
    }

    static /* synthetic */ String renderQRCode$default(BufferedImage bufferedImage, String string, String string2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = "   ";
        }
        if ((n & 2) != 0) {
            string2 = "   ";
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        return LoginSolver_jvmKt.renderQRCode(bufferedImage, string, string2, bl);
    }

    private static final int createCharImg$gray(int rgb) {
        int r = (rgb & 0xFF0000) >> 16;
        int g = (rgb & 0xFF00) >> 8;
        int b = rgb & 0xFF;
        return (r * 30 + g * 59 + b * 11 + 50) / 100;
    }

    private static final boolean createCharImg$grayCompare(double $ignoreRate, int g1, int g2) {
        return (double)Math.min(g1, g2) / (double)Math.max(g1, g2) >= $ignoreRate;
    }

    private static final boolean renderQRCode$isBlackBlock(int rgb) {
        int r = (rgb & 0xFF0000) >> 16;
        int g = (rgb & 0xFF00) >> 8;
        int b = rgb & 0xFF;
        return r < 10 && g < 10 && b < 10;
    }

    public static final /* synthetic */ Mutex access$getLoginSolverLock$p() {
        return loginSolverLock;
    }
}

