/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.utils;

import java.io.PrintStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmInline;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import net.mamoe.mirai.utils.MiraiUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0005\u0010\u0011\u0012\u0013\u0014B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0007J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lnet/mamoe/mirai/utils/SecretsProtection;", "", "()V", "bufferSize", "", "lowRemainingHitThreshold", "lowRemainingThreshold", "pool", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "Lnet/mamoe/mirai/utils/SecretsProtection$NativeBufferWithLock;", "allocate", "Ljava/nio/ByteBuffer;", "size", "escape", "data", "", "EscapedByteBuffer", "EscapedByteBufferSerializer", "EscapedString", "EscapedStringSerializer", "NativeBufferWithLock", "mirai-core-utils"})
public final class SecretsProtection {
    @NotNull
    public static final SecretsProtection INSTANCE = new SecretsProtection();
    private static final int bufferSize = RangesKt.coerceAtLeast((int)((int)MiraiUtils.systemProp("mirai.secrets.protection.buffer.size", 0L)), (int)2048);
    private static final int lowRemainingThreshold = bufferSize / 128;
    private static final int lowRemainingHitThreshold = RangesKt.coerceAtLeast((int)((int)MiraiUtils.systemProp("mirai.secrets.protection.threshold.low.remaining.hit", 10L)), (int)1);
    @NotNull
    private static final ConcurrentLinkedDeque<NativeBufferWithLock> pool = new ConcurrentLinkedDeque();

    private SecretsProtection() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final ByteBuffer allocate(int size) {
        if (size >= bufferSize) {
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(size);
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"allocateDirect(size)");
            return byteBuffer;
        }
        Iterable $this$forEach$iv = pool;
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv) {
            NativeBufferWithLock buffer = (NativeBufferWithLock)element$iv;
            boolean bl = false;
            Buffer $this$remaining$iv = buffer.buffer;
            boolean $i$f$getRemaining = false;
            int bufferRemaining = $this$remaining$iv.remaining();
            if (bufferRemaining >= size && buffer.getLock().tryLock()) {
                try {
                    Buffer $this$hasRemaining$iv = buffer.buffer;
                    boolean $i$f$hasRemaining = false;
                    Buffer $this$remaining$iv$iv = $this$hasRemaining$iv;
                    boolean $i$f$getRemaining2 = false;
                    if ($this$remaining$iv$iv.remaining() >= size) {
                        NativeBufferWithLock.Companion.getUnusedHitUpdater$mirai_core_utils().getAndIncrement(buffer);
                        Intrinsics.checkNotNullExpressionValue((Object)buffer, (String)"buffer");
                        ByteBuffer byteBuffer = SecretsProtection.allocate$putInto(size, buffer);
                        return byteBuffer;
                    }
                }
                finally {
                    buffer.getLock().unlock();
                }
            }
            NativeBufferWithLock.Companion.getUnusedHitUpdater$mirai_core_utils().getAndDecrement(buffer);
            if (bufferRemaining <= lowRemainingThreshold) {
                NativeBufferWithLock.Companion.getLowRemainingHitUpdater$mirai_core_utils().getAndDecrement(buffer);
                if (buffer.lowRemainingHit >= lowRemainingHitThreshold) {
                    pool.remove(buffer);
                }
            }
            if (buffer.unusedHit < 20) continue;
            pool.remove(buffer);
        }
        ByteBuffer $i$f$forEach22 = ByteBuffer.allocateDirect(bufferSize);
        Intrinsics.checkNotNullExpressionValue((Object)$i$f$forEach22, (String)"allocateDirect(bufferSize)");
        NativeBufferWithLock newBuffer = new NativeBufferWithLock($i$f$forEach22, null, 0, 0, 14, null);
        ByteBuffer rsp = SecretsProtection.allocate$putInto(size, newBuffer);
        if (newBuffer.buffer.hasRemaining()) {
            pool.add(newBuffer);
        }
        return rsp;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final ByteBuffer escape(@NotNull byte[] data) {
        void $this$pos$iv;
        ByteBuffer byteBuffer;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        ByteBuffer it = byteBuffer = SecretsProtection.allocate(data.length);
        boolean bl = false;
        it.put(data);
        Buffer buffer = it;
        int value$iv = 0;
        boolean $i$f$setPos = false;
        $this$pos$iv.position(value$iv);
        return byteBuffer;
    }

    /*
     * WARNING - void declaration
     */
    private static final ByteBuffer allocate$putInto(int $size, NativeBufferWithLock buffer) {
        void $this$pos$iv;
        Buffer $this$limit$iv;
        ByteBuffer buffer0 = buffer.buffer;
        boolean bl = false;
        Buffer buffer2 = buffer0;
        Buffer $this$pos$iv2 = buffer0;
        boolean $i$f$getPos = false;
        int value$iv = $this$pos$iv2.position() + $size;
        boolean $i$f$setLimit = false;
        $this$limit$iv.limit(value$iv);
        ByteBuffer mirror = buffer0.slice();
        Buffer buf = buffer.buffer;
        boolean bl2 = false;
        $this$limit$iv = buf;
        value$iv = buf.capacity();
        $i$f$setLimit = false;
        $this$limit$iv.limit(value$iv);
        ByteBuffer byteBuffer = buffer.buffer;
        buf = byteBuffer;
        Buffer $this$pos$iv3 = byteBuffer;
        boolean $i$f$getPos2 = false;
        int value$iv2 = $this$pos$iv3.position() + $size;
        boolean $i$f$setPos = false;
        $this$pos$iv.position(value$iv2);
        if (!buffer.buffer.hasRemaining()) {
            pool.remove(buffer);
        }
        Intrinsics.checkNotNullExpressionValue((Object)mirror, (String)"mirror");
        return mirror;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        ByteBuffer tmbuffer = ByteBuffer.allocateDirect(bufferSize);
        if (!MiraiUtils.systemProp("mirai.secrets.protection.ignore.warning", false) && tmbuffer.getClass() == ByteBuffer.allocate(1).getClass()) {
            PrintStream ps = System.err;
            Intrinsics.checkNotNullExpressionValue((Object)ps, (String)"ps");
            PrintStream printStream = ps;
            synchronized (printStream) {
                boolean bl = false;
                ps.println("========================================================================================");
                ps.println("Mirai SecretsProtection WARNING:");
                ps.println();
                ps.println("\u5f53\u524d JRE \u5b9e\u73b0\u6ca1\u6709\u4e3a `ByteBuffer.allocateDirect` \u76f4\u63a5\u5206\u914d\u672c\u5730\u5185\u5b58, \u8bf7\u66f4\u6362\u5176\u4ed6 JRE.");
                ps.println("\u8fd9\u5f88\u6709\u53ef\u80fd\u5bfc\u81f4\u60a8\u7684\u5bc6\u7801\u7b49\u654f\u611f\u4fe1\u606f\u88ab\u5e26\u5165\u5185\u5b58\u62a5\u544a\u4e2d");
                ps.println("\u53ef\u6dfb\u52a0 JVM \u53c2\u6570 -Dmirai.secrets.protection.ignore.warning=true \u6765\u5ffd\u7565\u6b64\u8b66\u544a");
                ps.println();
                ps.println("Current JRE Implementation not using native memory for `ByteBuffer.allocateDirect`.");
                ps.println("Please use another JRE.");
                ps.println("It may cause your passwords to be dumped by other processes.");
                ps.println("Suppress this warning by adding jvm option -Dmirai.secrets.protection.ignore.warning=true");
                ps.println();
                ps.println("========================================================================================");
                Unit unit = Unit.INSTANCE;
            }
        }
        Intrinsics.checkNotNullExpressionValue((Object)tmbuffer, (String)"tmbuffer");
        pool.add(new NativeBufferWithLock(tmbuffer, null, 0, 0, 14, null));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tR\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lnet/mamoe/mirai/utils/SecretsProtection$NativeBufferWithLock;", "", "buffer", "Ljava/nio/ByteBuffer;", "lock", "Ljava/util/concurrent/locks/Lock;", "lowRemainingHit", "", "unusedHit", "(Ljava/nio/ByteBuffer;Ljava/util/concurrent/locks/Lock;II)V", "getLock", "()Ljava/util/concurrent/locks/Lock;", "Companion", "mirai-core-utils"})
    private static final class NativeBufferWithLock {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @JvmField
        @NotNull
        public final ByteBuffer buffer;
        @NotNull
        private final Lock lock;
        @JvmField
        public volatile int lowRemainingHit;
        @JvmField
        public volatile int unusedHit;
        private static final AtomicIntegerFieldUpdater<NativeBufferWithLock> lowRemainingHitUpdater = AtomicIntegerFieldUpdater.newUpdater(NativeBufferWithLock.class, "lowRemainingHit");
        private static final AtomicIntegerFieldUpdater<NativeBufferWithLock> unusedHitUpdater = AtomicIntegerFieldUpdater.newUpdater(NativeBufferWithLock.class, "unusedHit");

        public NativeBufferWithLock(@NotNull ByteBuffer buffer, @NotNull Lock lock, int lowRemainingHit, int unusedHit) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
            this.buffer = buffer;
            this.lock = lock;
            this.lowRemainingHit = lowRemainingHit;
            this.unusedHit = unusedHit;
        }

        public /* synthetic */ NativeBufferWithLock(ByteBuffer byteBuffer, Lock lock, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 2) != 0) {
                lock = new ReentrantLock();
            }
            if ((n3 & 4) != 0) {
                n = 0;
            }
            if ((n3 & 8) != 0) {
                n2 = 0;
            }
            this(byteBuffer, lock, n, n2);
        }

        @NotNull
        public final Lock getLock() {
            return this.lock;
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R8\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR8\u0010\t\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lnet/mamoe/mirai/utils/SecretsProtection$NativeBufferWithLock$Companion;", "", "()V", "lowRemainingHitUpdater", "Ljava/util/concurrent/atomic/AtomicIntegerFieldUpdater;", "Lnet/mamoe/mirai/utils/SecretsProtection$NativeBufferWithLock;", "kotlin.jvm.PlatformType", "getLowRemainingHitUpdater$mirai_core_utils", "()Ljava/util/concurrent/atomic/AtomicIntegerFieldUpdater;", "unusedHitUpdater", "getUnusedHitUpdater$mirai_core_utils", "mirai-core-utils"})
        public static final class Companion {
            private Companion() {
            }

            public final AtomicIntegerFieldUpdater<NativeBufferWithLock> getLowRemainingHitUpdater$mirai_core_utils() {
                return lowRemainingHitUpdater;
            }

            public final AtomicIntegerFieldUpdater<NativeBufferWithLock> getUnusedHitUpdater$mirai_core_utils() {
                return unusedHitUpdater;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @JvmInline
    @Serializable(with=EscapedStringSerializer.class)
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\b\u0087@\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u0007H\u00d6\u0001\u00a2\u0006\u0004\b\u0016\u0010\tR\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u0088\u0001\u0002\u00f8\u0001\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0018"}, d2={"Lnet/mamoe/mirai/utils/SecretsProtection$EscapedString;", "", "data", "Ljava/nio/ByteBuffer;", "constructor-impl", "(Ljava/nio/ByteBuffer;)Ljava/nio/ByteBuffer;", "asString", "", "getAsString-impl", "(Ljava/nio/ByteBuffer;)Ljava/lang/String;", "getData", "()Ljava/nio/ByteBuffer;", "equals", "", "other", "equals-impl", "(Ljava/nio/ByteBuffer;Ljava/lang/Object;)Z", "hashCode", "", "hashCode-impl", "(Ljava/nio/ByteBuffer;)I", "toString", "toString-impl", "Companion", "mirai-core-utils"})
    public static final class EscapedString {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final ByteBuffer data;

        @NotNull
        public final ByteBuffer getData() {
            return this.data;
        }

        @NotNull
        public static final String getAsString-impl(ByteBuffer arg0) {
            Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
            ByteBuffer byteBuffer = arg0.duplicate();
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"data.duplicate()");
            return MiraiUtils.readString$default(byteBuffer, null, 1, null);
        }

        public static String toString-impl(ByteBuffer arg0) {
            return "EscapedString(data=" + arg0 + ')';
        }

        public String toString() {
            return EscapedString.toString-impl(this.data);
        }

        public static int hashCode-impl(ByteBuffer arg0) {
            return arg0.hashCode();
        }

        public int hashCode() {
            return EscapedString.hashCode-impl(this.data);
        }

        public static boolean equals-impl(ByteBuffer arg0, Object other) {
            if (!(other instanceof EscapedString)) {
                return false;
            }
            return Intrinsics.areEqual((Object)arg0, (Object)((EscapedString)other).unbox-impl());
        }

        public boolean equals(Object other) {
            return EscapedString.equals-impl(this.data, other);
        }

        private /* synthetic */ EscapedString(ByteBuffer data) {
            this.data = data;
        }

        @NotNull
        public static ByteBuffer constructor-impl(@NotNull ByteBuffer data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return data;
        }

        public static final /* synthetic */ EscapedString box-impl(ByteBuffer v) {
            return new EscapedString(v);
        }

        public final /* synthetic */ ByteBuffer unbox-impl() {
            return this.data;
        }

        public static final boolean equals-impl0(ByteBuffer p1, ByteBuffer p2) {
            return Intrinsics.areEqual((Object)p1, (Object)p2);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00f8\u0001\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0006"}, d2={"Lnet/mamoe/mirai/utils/SecretsProtection$EscapedString$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lnet/mamoe/mirai/utils/SecretsProtection$EscapedString;", "mirai-core-utils"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<EscapedString> serializer() {
                return EscapedStringSerializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @JvmInline
    @Serializable(with=EscapedByteBufferSerializer.class)
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0087@\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u000eH\u00d6\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u0088\u0001\u0002\u00f8\u0001\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0016"}, d2={"Lnet/mamoe/mirai/utils/SecretsProtection$EscapedByteBuffer;", "", "data", "Ljava/nio/ByteBuffer;", "constructor-impl", "(Ljava/nio/ByteBuffer;)Ljava/nio/ByteBuffer;", "getData", "()Ljava/nio/ByteBuffer;", "equals", "", "other", "equals-impl", "(Ljava/nio/ByteBuffer;Ljava/lang/Object;)Z", "hashCode", "", "hashCode-impl", "(Ljava/nio/ByteBuffer;)I", "toString", "", "toString-impl", "(Ljava/nio/ByteBuffer;)Ljava/lang/String;", "Companion", "mirai-core-utils"})
    public static final class EscapedByteBuffer {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final ByteBuffer data;

        @NotNull
        public final ByteBuffer getData() {
            return this.data;
        }

        public static String toString-impl(ByteBuffer arg0) {
            return "EscapedByteBuffer(data=" + arg0 + ')';
        }

        public String toString() {
            return EscapedByteBuffer.toString-impl(this.data);
        }

        public static int hashCode-impl(ByteBuffer arg0) {
            return arg0.hashCode();
        }

        public int hashCode() {
            return EscapedByteBuffer.hashCode-impl(this.data);
        }

        public static boolean equals-impl(ByteBuffer arg0, Object other) {
            if (!(other instanceof EscapedByteBuffer)) {
                return false;
            }
            return Intrinsics.areEqual((Object)arg0, (Object)((EscapedByteBuffer)other).unbox-impl());
        }

        public boolean equals(Object other) {
            return EscapedByteBuffer.equals-impl(this.data, other);
        }

        private /* synthetic */ EscapedByteBuffer(ByteBuffer data) {
            this.data = data;
        }

        @NotNull
        public static ByteBuffer constructor-impl(@NotNull ByteBuffer data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return data;
        }

        public static final /* synthetic */ EscapedByteBuffer box-impl(ByteBuffer v) {
            return new EscapedByteBuffer(v);
        }

        public final /* synthetic */ ByteBuffer unbox-impl() {
            return this.data;
        }

        public static final boolean equals-impl0(ByteBuffer p1, ByteBuffer p2) {
            return Intrinsics.areEqual((Object)p1, (Object)p2);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0001\u00f8\u0001\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0006"}, d2={"Lnet/mamoe/mirai/utils/SecretsProtection$EscapedByteBuffer$Companion;", "", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lnet/mamoe/mirai/utils/SecretsProtection$EscapedByteBuffer;", "mirai-core-utils"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<EscapedByteBuffer> serializer() {
                return EscapedByteBufferSerializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J!\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0096\u0001\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ&\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0096\u0001\u00f8\u0001\u0000\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0004\u001a\u00020\u0005X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00f8\u0001\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u0014"}, d2={"Lnet/mamoe/mirai/utils/SecretsProtection$EscapedStringSerializer;", "Lkotlinx/serialization/KSerializer;", "Lnet/mamoe/mirai/utils/SecretsProtection$EscapedString;", "()V", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "deserialize-JIj9kN4", "(Lkotlinx/serialization/encoding/Decoder;)Ljava/nio/ByteBuffer;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "serialize-nTZbNTk", "(Lkotlinx/serialization/encoding/Encoder;Ljava/nio/ByteBuffer;)V", "mirai-core-utils"})
    public static final class EscapedStringSerializer
    implements KSerializer<EscapedString> {
        @NotNull
        public static final EscapedStringSerializer INSTANCE = new EscapedStringSerializer();
        private final /* synthetic */ KSerializer<EscapedString> $$delegate_0;

        /*
         * WARNING - void declaration
         */
        private EscapedStringSerializer() {
            void $this$map$iv;
            KSerializer kSerializer = BuiltinSerializersKt.serializer((StringCompanionObject)StringCompanionObject.INSTANCE);
            SerialDescriptor resultantDescriptor$iv = MiraiUtils.copy(BuiltinSerializersKt.serializer((StringCompanionObject)StringCompanionObject.INSTANCE).getDescriptor(), "EscapedString");
            boolean $i$f$map = false;
            this.$$delegate_0 = (KSerializer)new KSerializer<EscapedString>(resultantDescriptor$iv, (KSerializer)$this$map$iv){
                final /* synthetic */ SerialDescriptor $resultantDescriptor;
                final /* synthetic */ KSerializer $this_map;
                {
                    this.$resultantDescriptor = $resultantDescriptor;
                    this.$this_map = $receiver;
                }

                @NotNull
                public SerialDescriptor getDescriptor() {
                    return this.$resultantDescriptor;
                }

                /*
                 * WARNING - void declaration
                 */
                public EscapedString deserialize(@NotNull Decoder decoder) {
                    void it;
                    Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
                    Object it2 = this.$this_map.deserialize(decoder);
                    boolean bl = false;
                    String string = (String)it2;
                    String $this$__delegate_0_u24lambda_u2d0 = (String)it2;
                    boolean bl2 = false;
                    void var7_7 = it;
                    byte[] byArray = var7_7.getBytes(Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                    return EscapedString.box-impl(EscapedString.constructor-impl(SecretsProtection.escape(byArray)));
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 * WARNING - void declaration
                 */
                public void serialize(@NotNull Encoder encoder, Object value) {
                    void it;
                    void it2;
                    Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
                    Object object = value;
                    Encoder encoder2 = encoder;
                    KSerializer kSerializer = this.$this_map;
                    boolean bl = false;
                    ByteBuffer byteBuffer = ((EscapedString)it2).unbox-impl();
                    ByteBuffer $this$__delegate_0_u24lambda_u2d1 = ((EscapedString)it2).unbox-impl();
                    boolean bl2 = false;
                    ByteBuffer byteBuffer2 = it.duplicate();
                    Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"it.data.duplicate()");
                    String string = MiraiUtils.readString$default(byteBuffer2, null, 1, null);
                    kSerializer.serialize(encoder2, (Object)string);
                }
            };
        }

        @NotNull
        public SerialDescriptor getDescriptor() {
            return this.$$delegate_0.getDescriptor();
        }

        @NotNull
        public ByteBuffer deserialize-JIj9kN4(@NotNull Decoder decoder) {
            Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
            return ((EscapedString)this.$$delegate_0.deserialize(decoder)).unbox-impl();
        }

        public void serialize-nTZbNTk(@NotNull Encoder encoder, @NotNull ByteBuffer value) {
            Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.$$delegate_0.serialize(encoder, (Object)EscapedString.box-impl(value));
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J!\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0096\u0001\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ&\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0096\u0001\u00f8\u0001\u0000\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0012\u0010\u0004\u001a\u00020\u0005X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00f8\u0001\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u0014"}, d2={"Lnet/mamoe/mirai/utils/SecretsProtection$EscapedByteBufferSerializer;", "Lkotlinx/serialization/KSerializer;", "Lnet/mamoe/mirai/utils/SecretsProtection$EscapedByteBuffer;", "()V", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "deserialize-vlT4FJs", "(Lkotlinx/serialization/encoding/Decoder;)Ljava/nio/ByteBuffer;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "serialize-D52E_HU", "(Lkotlinx/serialization/encoding/Encoder;Ljava/nio/ByteBuffer;)V", "mirai-core-utils"})
    public static final class EscapedByteBufferSerializer
    implements KSerializer<EscapedByteBuffer> {
        @NotNull
        public static final EscapedByteBufferSerializer INSTANCE = new EscapedByteBufferSerializer();
        private final /* synthetic */ KSerializer<EscapedByteBuffer> $$delegate_0;

        /*
         * WARNING - void declaration
         */
        private EscapedByteBufferSerializer() {
            void $this$map$iv;
            KSerializer kSerializer = BuiltinSerializersKt.ByteArraySerializer();
            SerialDescriptor resultantDescriptor$iv = MiraiUtils.copy(BuiltinSerializersKt.ByteArraySerializer().getDescriptor(), "EscapedByteBuffer");
            boolean $i$f$map = false;
            this.$$delegate_0 = (KSerializer)new KSerializer<EscapedByteBuffer>(resultantDescriptor$iv, (KSerializer)$this$map$iv){
                final /* synthetic */ SerialDescriptor $resultantDescriptor;
                final /* synthetic */ KSerializer $this_map;
                {
                    this.$resultantDescriptor = $resultantDescriptor;
                    this.$this_map = $receiver;
                }

                @NotNull
                public SerialDescriptor getDescriptor() {
                    return this.$resultantDescriptor;
                }

                /*
                 * WARNING - void declaration
                 */
                public EscapedByteBuffer deserialize(@NotNull Decoder decoder) {
                    void it;
                    Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
                    Object it2 = this.$this_map.deserialize(decoder);
                    boolean bl = false;
                    byte[] byArray = (byte[])it2;
                    byte[] $this$__delegate_0_u24lambda_u2d0 = (byte[])it2;
                    boolean bl2 = false;
                    return EscapedByteBuffer.box-impl(EscapedByteBuffer.constructor-impl(SecretsProtection.escape((byte[])it)));
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 * WARNING - void declaration
                 */
                public void serialize(@NotNull Encoder encoder, Object value) {
                    void it;
                    void it2;
                    Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
                    Object object = value;
                    Encoder encoder2 = encoder;
                    KSerializer kSerializer = this.$this_map;
                    boolean bl = false;
                    ByteBuffer byteBuffer = ((EscapedByteBuffer)it2).unbox-impl();
                    ByteBuffer $this$__delegate_0_u24lambda_u2d1 = ((EscapedByteBuffer)it2).unbox-impl();
                    boolean bl2 = false;
                    ByteBuffer byteBuffer2 = it.duplicate();
                    Intrinsics.checkNotNullExpressionValue((Object)byteBuffer2, (String)"it.data.duplicate()");
                    byte[] byArray = MiraiUtils.readBytes(byteBuffer2);
                    kSerializer.serialize(encoder2, (Object)byArray);
                }
            };
        }

        @NotNull
        public SerialDescriptor getDescriptor() {
            return this.$$delegate_0.getDescriptor();
        }

        @NotNull
        public ByteBuffer deserialize-vlT4FJs(@NotNull Decoder decoder) {
            Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
            return ((EscapedByteBuffer)this.$$delegate_0.deserialize(decoder)).unbox-impl();
        }

        public void serialize-D52E_HU(@NotNull Encoder encoder, @NotNull ByteBuffer value) {
            Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.$$delegate_0.serialize(encoder, (Object)EscapedByteBuffer.box-impl(value));
        }
    }
}

