/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.internal.network.components;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.internal.AbstractBot;
import net.mamoe.mirai.internal.contact.UtilKt;
import net.mamoe.mirai.internal.network.MultiPacket;
import net.mamoe.mirai.internal.network.Packet;
import net.mamoe.mirai.internal.network.ParseErrorPacket;
import net.mamoe.mirai.internal.network.components.PacketLoggingStrategy;
import net.mamoe.mirai.internal.network.protocol.packet.IncomingPacket;
import net.mamoe.mirai.internal.network.protocol.packet.OutgoingPacket;
import net.mamoe.mirai.utils.MiraiLogger;
import net.mamoe.mirai.utils.MiraiUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lnet/mamoe/mirai/internal/network/components/PacketLoggingStrategyImpl;", "Lnet/mamoe/mirai/internal/network/components/PacketLoggingStrategy;", "bot", "Lnet/mamoe/mirai/internal/AbstractBot;", "blacklist", "", "", "(Lnet/mamoe/mirai/internal/AbstractBot;Ljava/util/Set;)V", "logReceived", "", "logger", "Lnet/mamoe/mirai/utils/MiraiLogger;", "incomingPacket", "Lnet/mamoe/mirai/internal/network/protocol/packet/IncomingPacket;", "logReceivedImpl", "packet", "Lnet/mamoe/mirai/internal/network/Packet;", "logSent", "outgoingPacket", "Lnet/mamoe/mirai/internal/network/protocol/packet/OutgoingPacket;", "Companion", "mirai-core"})
public final class PacketLoggingStrategyImpl
implements PacketLoggingStrategy {
    private final AbstractBot bot;
    private final Set<String> blacklist;
    @JvmField
    public static boolean SHOW_PACKET_DETAILS;
    @NotNull
    public static final Companion Companion;

    @Override
    public void logSent(@NotNull MiraiLogger logger, @NotNull OutgoingPacket outgoingPacket) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)outgoingPacket, (String)"outgoingPacket");
        if (this.blacklist.contains(outgoingPacket.getCommandName())) {
            return;
        }
        MiraiLogger $this$verbose$iv = logger;
        boolean $i$f$verbose = false;
        boolean bl = false;
        if ($this$verbose$iv.isEnabled()) {
            MiraiLogger miraiLogger = $this$verbose$iv;
            boolean bl2 = false;
            String string = "Send: " + outgoingPacket.getCommandName();
            miraiLogger.verbose(string);
        }
    }

    @Override
    public void logReceived(@NotNull MiraiLogger logger, @NotNull IncomingPacket incomingPacket) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)incomingPacket, (String)"incomingPacket");
        Throwable throwable = incomingPacket.getException();
        if (throwable != null) {
            Throwable throwable2 = throwable;
            boolean bl = false;
            boolean bl2 = false;
            Throwable it = throwable2;
            boolean bl3 = false;
            logger.error(it);
            return;
        }
        Packet packet = incomingPacket.getData();
        if (packet == null) {
            return;
        }
        Packet packet2 = packet;
        if (!this.bot.getLogger().isEnabled() && !logger.isEnabled()) {
            return;
        }
        if (packet2 instanceof ParseErrorPacket) {
            ((ParseErrorPacket)packet2).getDirection().getLogger(this.bot).error(((ParseErrorPacket)packet2).getError());
        }
        if (incomingPacket.getData() instanceof MultiPacket) {
            for (Packet d : (MultiPacket)incomingPacket.getData()) {
                this.logReceivedImpl(d, incomingPacket, logger);
            }
        }
        if (!this.blacklist.contains(incomingPacket.getCommandName())) {
            this.logReceivedImpl(packet2, incomingPacket, logger);
        }
    }

    private final void logReceivedImpl(Packet packet, IncomingPacket incomingPacket, MiraiLogger logger) {
        Packet packet2 = packet;
        if (packet2 instanceof MessageEvent) {
            UtilKt.logMessageReceived((MessageEvent)packet);
        } else if (!(packet2 instanceof Packet.NoLog)) {
            if (SHOW_PACKET_DETAILS) {
                MiraiLogger $this$verbose$iv = logger;
                boolean $i$f$verbose = false;
                boolean bl = false;
                if ($this$verbose$iv.isEnabled()) {
                    MiraiLogger miraiLogger = $this$verbose$iv;
                    boolean bl2 = false;
                    String string = UtilKt.replaceMagicCodes("Recv: " + incomingPacket.getCommandName() + ' ' + incomingPacket.getData());
                    miraiLogger.verbose(string);
                }
            } else {
                MiraiLogger $this$verbose$iv = logger;
                boolean $i$f$verbose = false;
                boolean bl = false;
                if ($this$verbose$iv.isEnabled()) {
                    MiraiLogger miraiLogger = $this$verbose$iv;
                    boolean bl3 = false;
                    String string = UtilKt.replaceMagicCodes("Recv: " + incomingPacket.getCommandName());
                    miraiLogger.verbose(string);
                }
            }
        }
    }

    public PacketLoggingStrategyImpl(@NotNull AbstractBot bot, @NotNull Set<String> blacklist) {
        Intrinsics.checkNotNullParameter((Object)bot, (String)"bot");
        Intrinsics.checkNotNullParameter(blacklist, (String)"blacklist");
        this.bot = bot;
        this.blacklist = blacklist;
    }

    public /* synthetic */ PacketLoggingStrategyImpl(AbstractBot abstractBot, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            set = Companion.getDEFAULT_BLACKLIST();
        }
        this(abstractBot, set);
    }

    static {
        Companion = new Companion(null);
        SHOW_PACKET_DETAILS = MiraiUtils.systemProp((String)"mirai.debug.network.show.packet.details", (boolean)false);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lnet/mamoe/mirai/internal/network/components/PacketLoggingStrategyImpl$Companion;", "", "()V", "DEFAULT_BLACKLIST", "", "", "getDEFAULT_BLACKLIST", "()Ljava/util/Set;", "SHOW_PACKET_DETAILS", "", "mirai-core"})
    public static final class Companion {
        @NotNull
        public final Set<String> getDEFAULT_BLACKLIST() {
            if (MiraiUtils.systemProp((String)"mirai.debug.network.show.verbose.packets", (boolean)false)) {
                return SetsKt.emptySet();
            }
            return SetsKt.setOf((Object[])new String[]{"MessageSvc.PbDeleteMsg", "MessageSvc.PbGetMsg", "OnlinePush.RespPush", "Heartbeat.Alive"});
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

