/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.internal.network.components;

import java.util.Set;
import java.util.concurrent.CancellationException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.mamoe.mirai.event.events.MessageEvent;
import net.mamoe.mirai.internal.AbstractBot;
import net.mamoe.mirai.internal.contact.UtilKt;
import net.mamoe.mirai.internal.network.MultiPacket;
import net.mamoe.mirai.internal.network.Packet;
import net.mamoe.mirai.internal.network.ParseErrorPacket;
import net.mamoe.mirai.internal.network.components.PacketLoggingStrategy;
import net.mamoe.mirai.internal.network.components.PacketLoggingStrategyImpl;
import net.mamoe.mirai.internal.network.protocol.packet.IncomingPacket;
import net.mamoe.mirai.internal.network.protocol.packet.OutgoingPacket;
import net.mamoe.mirai.utils.MiraiLogger;
import net.mamoe.mirai.utils.MiraiUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lnet/mamoe/mirai/internal/network/components/PacketLoggingStrategyImpl;", "Lnet/mamoe/mirai/internal/network/components/PacketLoggingStrategy;", "bot", "Lnet/mamoe/mirai/internal/AbstractBot;", "blacklist", "", "", "(Lnet/mamoe/mirai/internal/AbstractBot;Ljava/util/Set;)V", "logReceived", "", "logger", "Lnet/mamoe/mirai/utils/MiraiLogger;", "incomingPacket", "Lnet/mamoe/mirai/internal/network/protocol/packet/IncomingPacket;", "logReceivedImpl", "packet", "Lnet/mamoe/mirai/internal/network/Packet;", "logSent", "outgoingPacket", "Lnet/mamoe/mirai/internal/network/protocol/packet/OutgoingPacket;", "Companion", "mirai-core"})
public final class PacketLoggingStrategyImpl
implements PacketLoggingStrategy {
    private final AbstractBot bot;
    private final Set<String> blacklist;
    private static final Lazy DEFAULT_BLACKLIST$delegate;
    @JvmField
    public static boolean SHOW_PACKET_DETAILS;
    @NotNull
    public static final Companion Companion;

    @Override
    public void logSent(@NotNull MiraiLogger logger2, @NotNull OutgoingPacket outgoingPacket) {
        Intrinsics.checkNotNullParameter(logger2, "logger");
        Intrinsics.checkNotNullParameter(outgoingPacket, "outgoingPacket");
        if (this.blacklist.contains(outgoingPacket.getCommandName())) {
            return;
        }
        MiraiLogger $this$verbose$iv = logger2;
        boolean $i$f$verbose = false;
        boolean bl = false;
        if ($this$verbose$iv.isEnabled()) {
            MiraiLogger miraiLogger = $this$verbose$iv;
            boolean bl2 = false;
            String string = "Send: " + outgoingPacket.getDisplayName();
            miraiLogger.verbose(string);
        }
    }

    @Override
    public void logReceived(@NotNull MiraiLogger logger2, @NotNull IncomingPacket incomingPacket) {
        Intrinsics.checkNotNullParameter(logger2, "logger");
        Intrinsics.checkNotNullParameter(incomingPacket, "incomingPacket");
        Throwable throwable = incomingPacket.getException();
        if (throwable != null) {
            Throwable throwable2 = throwable;
            boolean bl = false;
            boolean bl2 = false;
            Throwable it = throwable2;
            boolean bl3 = false;
            if (it instanceof CancellationException) {
                return;
            }
            logger2.error("Exception in decoding packet.", it);
            return;
        }
        Packet packet = incomingPacket.getData();
        if (packet == null) {
            return;
        }
        Packet packet2 = packet;
        if (!this.bot.getLogger().isEnabled() && !logger2.isEnabled()) {
            return;
        }
        if (packet2 instanceof ParseErrorPacket) {
            ((ParseErrorPacket)packet2).getDirection().getLogger(this.bot).error("Exception in parsing packet.", ((ParseErrorPacket)packet2).getError());
        }
        if (incomingPacket.getData() instanceof MultiPacket) {
            for (Packet d : (MultiPacket)incomingPacket.getData()) {
                this.logReceivedImpl(d, incomingPacket, logger2);
            }
        }
        this.logReceivedImpl(packet2, incomingPacket, logger2);
    }

    private final void logReceivedImpl(Packet packet, IncomingPacket incomingPacket, MiraiLogger logger2) {
        Packet packet2 = packet;
        if (packet2 instanceof MessageEvent) {
            UtilKt.logMessageReceived((MessageEvent)packet);
        } else if (!(packet2 instanceof Packet.NoLog)) {
            if (this.blacklist.contains(incomingPacket.getCommandName())) {
                return;
            }
            if (SHOW_PACKET_DETAILS) {
                MiraiLogger $this$verbose$iv = logger2;
                boolean $i$f$verbose = false;
                boolean bl = false;
                if ($this$verbose$iv.isEnabled()) {
                    MiraiLogger miraiLogger = $this$verbose$iv;
                    boolean bl2 = false;
                    String string = UtilKt.replaceMagicCodes("Recv: " + incomingPacket.getCommandName() + ' ' + incomingPacket.getData());
                    miraiLogger.verbose(string);
                }
            } else {
                MiraiLogger $this$verbose$iv = logger2;
                boolean $i$f$verbose = false;
                boolean bl = false;
                if ($this$verbose$iv.isEnabled()) {
                    MiraiLogger miraiLogger = $this$verbose$iv;
                    boolean bl3 = false;
                    String string = UtilKt.replaceMagicCodes("Recv: " + incomingPacket.getCommandName());
                    miraiLogger.verbose(string);
                }
            }
        }
    }

    public PacketLoggingStrategyImpl(@NotNull AbstractBot bot, @NotNull Set<String> blacklist) {
        Intrinsics.checkNotNullParameter(bot, "bot");
        Intrinsics.checkNotNullParameter(blacklist, "blacklist");
        this.bot = bot;
        this.blacklist = blacklist;
    }

    public /* synthetic */ PacketLoggingStrategyImpl(AbstractBot abstractBot, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            set = Companion.getDefaultBlacklist();
        }
        this(abstractBot, set);
    }

    static {
        Companion = new Companion(null);
        DEFAULT_BLACKLIST$delegate = LazyKt.lazy(Companion.DEFAULT_BLACKLIST.2.INSTANCE);
        SHOW_PACKET_DETAILS = MiraiUtils.systemProp("mirai.debug.network.show.packet.details", false);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004R!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\n\u001a\u00020\u000b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lnet/mamoe/mirai/internal/network/components/PacketLoggingStrategyImpl$Companion;", "", "()V", "DEFAULT_BLACKLIST", "", "", "getDEFAULT_BLACKLIST", "()Ljava/util/Set;", "DEFAULT_BLACKLIST$delegate", "Lkotlin/Lazy;", "SHOW_PACKET_DETAILS", "", "getDefaultBlacklist", "mirai-core"})
    public static final class Companion {
        @NotNull
        public final Set<String> getDefaultBlacklist() {
            if (MiraiUtils.systemProp("mirai.debug.network.show.verbose.packets", false)) {
                return SetsKt.emptySet();
            }
            return this.getDEFAULT_BLACKLIST();
        }

        private final Set<String> getDEFAULT_BLACKLIST() {
            Lazy lazy = DEFAULT_BLACKLIST$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return (Set)lazy.getValue();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

