/*
 * Decompiled with CFR 0.152.
 */
package net.mamoe.mirai.internal.network.components;

import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import net.mamoe.mirai.internal.BotAccount;
import net.mamoe.mirai.internal.network.components.AccountSecretsManager;
import net.mamoe.mirai.internal.network.components.CombinedAccountSecretsManager;
import net.mamoe.mirai.internal.network.components.FileCacheAccountSecretsManager;
import net.mamoe.mirai.internal.network.components.MemoryAccountSecretsManager;
import net.mamoe.mirai.internal.network.context.AccountSecrets;
import net.mamoe.mirai.internal.network.context.AccountSecretsKt;
import net.mamoe.mirai.internal.utils.BotConfigurationExtKt;
import net.mamoe.mirai.utils.BotConfiguration;
import net.mamoe.mirai.utils.DeviceInfo;
import net.mamoe.mirai.utils.MiraiLogger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u001c\u0010\u0005\u001a\u00020\u0006*\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00a8\u0006\u000b"}, d2={"createAccountsSecretsManager", "Lnet/mamoe/mirai/internal/network/components/AccountSecretsManager;", "Lnet/mamoe/mirai/utils/BotConfiguration;", "logger", "Lnet/mamoe/mirai/utils/MiraiLogger;", "getSecretsOrCreate", "Lnet/mamoe/mirai/internal/network/context/AccountSecrets;", "account", "Lnet/mamoe/mirai/internal/BotAccount;", "device", "Lnet/mamoe/mirai/utils/DeviceInfo;", "mirai-core"})
public final class AccountSecretsManagerKt {
    @NotNull
    public static final AccountSecrets getSecretsOrCreate(@NotNull AccountSecretsManager $this$getSecretsOrCreate, @NotNull BotAccount account, @NotNull DeviceInfo device) {
        Intrinsics.checkNotNullParameter($this$getSecretsOrCreate, "$this$getSecretsOrCreate");
        Intrinsics.checkNotNullParameter(account, "account");
        Intrinsics.checkNotNullParameter(device, "device");
        AccountSecrets secrets = $this$getSecretsOrCreate.getSecrets(account);
        if (secrets == null) {
            secrets = AccountSecretsKt.AccountSecretsImpl(device, account);
            $this$getSecretsOrCreate.saveSecrets(account, secrets);
        }
        return secrets;
    }

    @NotNull
    public static final AccountSecretsManager createAccountsSecretsManager(@NotNull BotConfiguration $this$createAccountsSecretsManager, @NotNull MiraiLogger logger2) {
        Intrinsics.checkNotNullParameter($this$createAccountsSecretsManager, "$this$createAccountsSecretsManager");
        Intrinsics.checkNotNullParameter(logger2, "logger");
        return new CombinedAccountSecretsManager(new MemoryAccountSecretsManager(), new FileCacheAccountSecretsManager(FilesKt.resolve(BotConfigurationExtKt.actualCacheDir($this$createAccountsSecretsManager), "account.secrets"), logger2));
    }
}

