/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.protobuf.internal;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.protobuf.ProtoIntegerType;
import kotlinx.serialization.protobuf.internal.ByteArrayInput;
import kotlinx.serialization.protobuf.internal.ProtobufDecodingException;
import kotlinx.serialization.protobuf.internal.ProtobufReader$WhenMappings;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006H\u0082\bJ\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J\u0012\u0010\u000f\u001a\u00020\u00062\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0002J\u0012\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0006\u0010\u0016\u001a\u00020\u0003J\u0006\u0010\u0017\u001a\u00020\u0003J\u0006\u0010\u0018\u001a\u00020\u000bJ\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u001aJ\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u001dJ\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010!\u001a\u00020 J\u000e\u0010\"\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010#\u001a\u00020\u0006J\b\u0010$\u001a\u00020\u0006H\u0002J\u000e\u0010%\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010&\u001a\u00020\u0013H\u0002J\u0006\u0010'\u001a\u00020\u0013J\u0006\u0010(\u001a\u00020)J\u0006\u0010*\u001a\u00020)J\u0006\u0010+\u001a\u00020\u0006J\u0006\u0010,\u001a\u00020\u000bR\u0012\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lkotlinx/serialization/protobuf/internal/ProtobufReader;", "", "input", "Lkotlinx/serialization/protobuf/internal/ByteArrayInput;", "(Lkotlinx/serialization/protobuf/internal/ByteArrayInput;)V", "currentId", "", "currentType", "pushBack", "", "assertWireType", "", "expected", "checkLength", "length", "decode32", "format", "Lkotlinx/serialization/protobuf/ProtoIntegerType;", "decode64", "", "decodeSignedVarintInt", "decodeSignedVarintLong", "objectInput", "objectTaglessInput", "pushBackTag", "readByteArray", "", "readByteArrayNoTag", "readDouble", "", "readDoubleNoTag", "readFloat", "", "readFloatNoTag", "readInt", "readInt32NoTag", "readIntLittleEndian", "readLong", "readLongLittleEndian", "readLongNoTag", "readString", "", "readStringNoTag", "readTag", "skipElement", "kotlinx-serialization-protobuf"})
public final class ProtobufReader {
    @JvmField
    public int currentId;
    @JvmField
    public int currentType;
    private boolean pushBack;
    private final ByteArrayInput input;

    public final int readTag() {
        int n;
        if (this.pushBack) {
            this.pushBack = false;
            return this.currentId;
        }
        int header = (int)this.input.readVarint64(true);
        if (header == -1) {
            this.currentId = -1;
            this.currentType = -1;
            n = -1;
        } else {
            this.currentId = header >>> 3;
            this.currentType = header & 7;
            n = this.currentId;
        }
        return n;
    }

    public final void pushBackTag() {
        this.pushBack = true;
    }

    public final void skipElement() {
        switch (this.currentType) {
            case 0: {
                this.readInt(ProtoIntegerType.DEFAULT);
                break;
            }
            case 1: {
                this.readLong(ProtoIntegerType.FIXED);
                break;
            }
            case 2: {
                this.readByteArray();
                break;
            }
            case 5: {
                this.readInt(ProtoIntegerType.FIXED);
                break;
            }
            default: {
                throw (Throwable)new ProtobufDecodingException("Unsupported start group or end group wire type: " + this.currentType);
            }
        }
    }

    private final void assertWireType(int expected) {
        int $i$f$assertWireType = 0;
        if (this.currentType != expected) {
            throw (Throwable)new ProtobufDecodingException("Expected wire type " + expected + ", but found " + this.currentType);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] readByteArray() {
        void this_$iv;
        ProtobufReader protobufReader = this;
        int expected$iv = 2;
        boolean $i$f$assertWireType = false;
        if (this_$iv.currentType != expected$iv) {
            throw (Throwable)new ProtobufDecodingException("Expected wire type " + expected$iv + ", but found " + this_$iv.currentType);
        }
        return this.readByteArrayNoTag();
    }

    @NotNull
    public final byte[] readByteArrayNoTag() {
        int length2 = ProtobufReader.decode32$default(this, null, 1, null);
        this.checkLength(length2);
        return this.input.readExactNBytes(length2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ByteArrayInput objectInput() {
        void this_$iv;
        ProtobufReader protobufReader = this;
        int expected$iv = 2;
        boolean $i$f$assertWireType = false;
        if (this_$iv.currentType != expected$iv) {
            throw (Throwable)new ProtobufDecodingException("Expected wire type " + expected$iv + ", but found " + this_$iv.currentType);
        }
        return this.objectTaglessInput();
    }

    @NotNull
    public final ByteArrayInput objectTaglessInput() {
        int length2 = ProtobufReader.decode32$default(this, null, 1, null);
        this.checkLength(length2);
        return this.input.slice(length2);
    }

    public final int readInt(@NotNull ProtoIntegerType format) {
        Intrinsics.checkNotNullParameter((Object)format, "format");
        int wireType = format == ProtoIntegerType.FIXED ? 5 : 0;
        ProtobufReader this_$iv = this;
        boolean $i$f$assertWireType = false;
        if (this_$iv.currentType != wireType) {
            throw (Throwable)new ProtobufDecodingException("Expected wire type " + wireType + ", but found " + this_$iv.currentType);
        }
        return this.decode32(format);
    }

    public final int readInt32NoTag() {
        return ProtobufReader.decode32$default(this, null, 1, null);
    }

    public final long readLong(@NotNull ProtoIntegerType format) {
        Intrinsics.checkNotNullParameter((Object)format, "format");
        int wireType = format == ProtoIntegerType.FIXED ? 1 : 0;
        ProtobufReader this_$iv = this;
        boolean $i$f$assertWireType = false;
        if (this_$iv.currentType != wireType) {
            throw (Throwable)new ProtobufDecodingException("Expected wire type " + wireType + ", but found " + this_$iv.currentType);
        }
        return this.decode64(format);
    }

    public final long readLongNoTag() {
        return this.decode64(ProtoIntegerType.DEFAULT);
    }

    /*
     * WARNING - void declaration
     */
    public final float readFloat() {
        void this_$iv;
        Object object = this;
        int expected$iv = 5;
        boolean $i$f$assertWireType = false;
        if (this_$iv.currentType != expected$iv) {
            throw (Throwable)new ProtobufDecodingException("Expected wire type " + expected$iv + ", but found " + this_$iv.currentType);
        }
        object = FloatCompanionObject.INSTANCE;
        int n = this.readIntLittleEndian();
        boolean bl = false;
        return Float.intBitsToFloat(n);
    }

    public final float readFloatNoTag() {
        FloatCompanionObject floatCompanionObject = FloatCompanionObject.INSTANCE;
        int n = this.readIntLittleEndian();
        boolean bl = false;
        return Float.intBitsToFloat(n);
    }

    /*
     * WARNING - void declaration
     */
    private final int readIntLittleEndian() {
        int result2 = 0;
        int n = 0;
        int n2 = 3;
        while (n <= n2) {
            void i2;
            int n3 = this.input.read() & 0xFF;
            result2 |= n3 << i2 * 8;
            ++i2;
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final long readLongLittleEndian() {
        long result2 = 0L;
        int n = 0;
        int n2 = 7;
        while (n <= n2) {
            void i2;
            long l = this.input.read() & 0xFF;
            result2 |= l << i2 * 8;
            ++i2;
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    public final double readDouble() {
        void this_$iv;
        Object object = this;
        int expected$iv = 1;
        boolean $i$f$assertWireType = false;
        if (this_$iv.currentType != expected$iv) {
            throw (Throwable)new ProtobufDecodingException("Expected wire type " + expected$iv + ", but found " + this_$iv.currentType);
        }
        object = DoubleCompanionObject.INSTANCE;
        long l = this.readLongLittleEndian();
        boolean bl = false;
        return Double.longBitsToDouble(l);
    }

    public final double readDoubleNoTag() {
        DoubleCompanionObject doubleCompanionObject = DoubleCompanionObject.INSTANCE;
        long l = this.readLongLittleEndian();
        boolean bl = false;
        return Double.longBitsToDouble(l);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String readString() {
        void this_$iv;
        ProtobufReader protobufReader = this;
        int expected$iv = 2;
        boolean $i$f$assertWireType = false;
        if (this_$iv.currentType != expected$iv) {
            throw (Throwable)new ProtobufDecodingException("Expected wire type " + expected$iv + ", but found " + this_$iv.currentType);
        }
        int length2 = ProtobufReader.decode32$default(this, null, 1, null);
        this.checkLength(length2);
        return this.input.readString(length2);
    }

    @NotNull
    public final String readStringNoTag() {
        int length2 = ProtobufReader.decode32$default(this, null, 1, null);
        this.checkLength(length2);
        return this.input.readString(length2);
    }

    private final void checkLength(int length2) {
        if (length2 < 0) {
            throw (Throwable)new ProtobufDecodingException("Unexpected negative length: " + length2);
        }
    }

    private final int decode32(ProtoIntegerType format) {
        int n;
        switch (ProtobufReader$WhenMappings.$EnumSwitchMapping$0[format.ordinal()]) {
            case 1: {
                n = (int)this.input.readVarint64(false);
                break;
            }
            case 2: {
                n = this.decodeSignedVarintInt(this.input);
                break;
            }
            case 3: {
                n = this.readIntLittleEndian();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    static /* synthetic */ int decode32$default(ProtobufReader protobufReader, ProtoIntegerType protoIntegerType, int n, Object object) {
        if ((n & 1) != 0) {
            protoIntegerType = ProtoIntegerType.DEFAULT;
        }
        return protobufReader.decode32(protoIntegerType);
    }

    private final long decode64(ProtoIntegerType format) {
        long l;
        switch (ProtobufReader$WhenMappings.$EnumSwitchMapping$1[format.ordinal()]) {
            case 1: {
                l = this.input.readVarint64(false);
                break;
            }
            case 2: {
                l = this.decodeSignedVarintLong(this.input);
                break;
            }
            case 3: {
                l = this.readLongLittleEndian();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return l;
    }

    static /* synthetic */ long decode64$default(ProtobufReader protobufReader, ProtoIntegerType protoIntegerType, int n, Object object) {
        if ((n & 1) != 0) {
            protoIntegerType = ProtoIntegerType.DEFAULT;
        }
        return protobufReader.decode64(protoIntegerType);
    }

    private final int decodeSignedVarintInt(ByteArrayInput input2) {
        int raw = input2.readVarint32();
        int temp = (raw << 31 >> 31 ^ raw) >> 1;
        return temp ^ raw & Integer.MIN_VALUE;
    }

    private final long decodeSignedVarintLong(ByteArrayInput input2) {
        long raw = input2.readVarint64(false);
        long temp = (raw << 63 >> 63 ^ raw) >> 1;
        return temp ^ raw & Long.MIN_VALUE;
    }

    public ProtobufReader(@NotNull ByteArrayInput input2) {
        Intrinsics.checkNotNullParameter(input2, "input");
        this.input = input2;
        this.currentId = -1;
        this.currentType = -1;
    }
}

