/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.protobuf.internal;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.internal.AbstractCollectionSerializer;
import kotlinx.serialization.internal.LinkedHashSetSerializer;
import kotlinx.serialization.internal.MapLikeSerializer;
import kotlinx.serialization.modules.SerializersModule;
import kotlinx.serialization.protobuf.ProtoBuf;
import kotlinx.serialization.protobuf.internal.HelpersKt;
import kotlinx.serialization.protobuf.internal.MapEntryReader;
import kotlinx.serialization.protobuf.internal.ProtobufDecodingKt;
import kotlinx.serialization.protobuf.internal.ProtobufReader;
import kotlinx.serialization.protobuf.internal.ProtobufTaggedDecoder;
import kotlinx.serialization.protobuf.internal.RepeatedDecoder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\f\b\u0010\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J!\u0010\u0015\u001a\u0002H\u0016\"\u0004\b\u0000\u0010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0018H\u0016\u00a2\u0006\u0002\u0010\u0019J+\u0010\u0015\u001a\u0002H\u0016\"\u0004\b\u0000\u0010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u00182\b\u0010\u001a\u001a\u0004\u0018\u0001H\u0016H\u0014\u00a2\u0006\u0002\u0010\u001bJ\u0014\u0010\u001c\u001a\u00020\u001d2\n\u0010\u001e\u001a\u00060\u001fj\u0002` H\u0014J\u0014\u0010!\u001a\u00020\"2\n\u0010\u001e\u001a\u00060\u001fj\u0002` H\u0014J\u0014\u0010#\u001a\u00020$2\n\u0010\u001e\u001a\u00060\u001fj\u0002` H\u0014J\u0014\u0010%\u001a\u00020&2\n\u0010\u001e\u001a\u00060\u001fj\u0002` H\u0014J\u001c\u0010'\u001a\u00020\u00112\n\u0010\u001e\u001a\u00060\u001fj\u0002` 2\u0006\u0010(\u001a\u00020\u0007H\u0014J\u0014\u0010)\u001a\u00020*2\n\u0010\u001e\u001a\u00060\u001fj\u0002` H\u0014J\u0014\u0010+\u001a\u00020\u00112\n\u0010\u001e\u001a\u00060\u001fj\u0002` H\u0014J\u0014\u0010,\u001a\u00020\u001f2\n\u0010\u001e\u001a\u00060\u001fj\u0002` H\u0014J\u0014\u0010-\u001a\u00020.2\n\u0010\u001e\u001a\u00060\u001fj\u0002` H\u0014J\u0014\u0010/\u001a\u0002002\n\u0010\u001e\u001a\u00060\u001fj\u0002` H\u0014J\u0012\u00101\u001a\u0002022\b\u0010\u001a\u001a\u0004\u0018\u000102H\u0002J+\u00103\u001a\u0002H\u0016\"\u0004\b\u0000\u0010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u00182\b\u0010\u001a\u001a\u0004\u0018\u0001H\u0016H\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0010\u00104\u001a\u0002052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u00106\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u00107\u001a\u00020\u0011H\u0002J\u0018\u00108\u001a\u00020\u00112\u0006\u00109\u001a\u00020\u00072\u0006\u00107\u001a\u00020\u0011H\u0002J\u0010\u0010:\u001a\u00020\u00112\u0006\u00107\u001a\u00020\u0011H\u0002J\u0010\u0010;\u001a\u00020\u00112\u0006\u00107\u001a\u00020\u0011H\u0002J\u000e\u0010<\u001a\u0002052\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010=\u001a\u0002052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010>\u001a\u00020\u0011H\u0002J\u0018\u0010?\u001a\u00060\u001fj\u0002` *\u00020\u00072\u0006\u0010@\u001a\u00020\u0011H\u0014R\u0010\u0010\u0006\u001a\u00020\u00078\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u00020\u00038\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lkotlinx/serialization/protobuf/internal/ProtobufDecoder;", "Lkotlinx/serialization/protobuf/internal/ProtobufTaggedDecoder;", "proto", "Lkotlinx/serialization/protobuf/ProtoBuf;", "reader", "Lkotlinx/serialization/protobuf/internal/ProtobufReader;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "(Lkotlinx/serialization/protobuf/ProtoBuf;Lkotlinx/serialization/protobuf/internal/ProtobufReader;Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "indexCache", "", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "sparseIndexCache", "", "", "beginStructure", "Lkotlinx/serialization/encoding/CompositeDecoder;", "decodeElementIndex", "decodeSerializableValue", "T", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "(Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "previousValue", "(Lkotlinx/serialization/DeserializationStrategy;Ljava/lang/Object;)Ljava/lang/Object;", "decodeTaggedBoolean", "", "tag", "", "Lkotlinx/serialization/protobuf/internal/ProtoDesc;", "decodeTaggedByte", "", "decodeTaggedChar", "", "decodeTaggedDouble", "", "decodeTaggedEnum", "enumDescription", "decodeTaggedFloat", "", "decodeTaggedInt", "decodeTaggedLong", "decodeTaggedShort", "", "decodeTaggedString", "", "deserializeByteArray", "", "deserializeMap", "endStructure", "", "findIndexByTag", "protoTag", "findIndexByTagSlowPath", "desc", "getIndexByTag", "getIndexByTagSlowPath", "populateCache", "populateCacheMap", "elements", "getTag", "index", "kotlinx-serialization-protobuf"})
public class ProtobufDecoder
extends ProtobufTaggedDecoder {
    private int[] indexCache;
    private Map<Integer, Integer> sparseIndexCache;
    @JvmField
    @NotNull
    protected final ProtoBuf proto;
    @JvmField
    @NotNull
    protected final ProtobufReader reader;
    @JvmField
    @NotNull
    protected final SerialDescriptor descriptor;

    @Override
    @NotNull
    public SerializersModule getSerializersModule() {
        return this.proto.getSerializersModule();
    }

    /*
     * WARNING - void declaration
     */
    public final void populateCache(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        int elements = descriptor2.getElementsCount();
        if (elements < 32) {
            int[] cache = new int[elements + 1];
            int n = 0;
            int n2 = elements;
            while (n < n2) {
                void i2;
                int protoId = HelpersKt.extractProtoId(descriptor2, (int)i2, false);
                if (protoId > elements) {
                    this.populateCacheMap(descriptor2, elements);
                    return;
                }
                cache[protoId] = i2++;
            }
            this.indexCache = cache;
        } else {
            this.populateCacheMap(descriptor2, elements);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void populateCacheMap(SerialDescriptor descriptor2, int elements) {
        HashMap map2 = new HashMap(elements);
        int n = 0;
        int n2 = elements;
        while (n < n2) {
            void i2;
            ((Map)map2).put(HelpersKt.extractProtoId(descriptor2, (int)i2, false), (int)i2);
            ++i2;
        }
        this.sparseIndexCache = map2;
    }

    private final int getIndexByTag(int protoTag) {
        int[] array = this.indexCache;
        if (array != null) {
            int n;
            int[] nArray = array;
            boolean bl = false;
            if (protoTag >= 0 && protoTag <= ArraysKt.getLastIndex(nArray)) {
                n = nArray[protoTag];
            } else {
                int it = protoTag;
                boolean bl2 = false;
                n = -1;
            }
            return n;
        }
        return this.getIndexByTagSlowPath(protoTag);
    }

    private final int getIndexByTagSlowPath(int protoTag) {
        Map<Integer, Integer> map2 = this.sparseIndexCache;
        Intrinsics.checkNotNull(map2);
        Map<Integer, Integer> map3 = map2;
        Integer n = protoTag;
        boolean bl = false;
        Integer n2 = map3.get(n);
        if (n2 == null) {
            boolean bl2 = false;
            n2 = -1;
        }
        return ((Number)n2).intValue();
    }

    private final int findIndexByTag(SerialDescriptor descriptor2, int protoTag) {
        int protoId;
        if (protoTag < descriptor2.getElementsCount() && (protoId = HelpersKt.extractProtoId(descriptor2, protoTag, true)) == protoTag) {
            return protoTag;
        }
        return this.findIndexByTagSlowPath(descriptor2, protoTag);
    }

    /*
     * WARNING - void declaration
     */
    private final int findIndexByTagSlowPath(SerialDescriptor desc, int protoTag) {
        int n = 0;
        int n2 = desc.getElementsCount();
        while (n < n2) {
            void i2;
            int protoId = HelpersKt.extractProtoId(desc, (int)i2, true);
            if (protoId == protoTag) {
                return (int)i2;
            }
            ++i2;
        }
        return -1;
    }

    @Override
    @NotNull
    public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor2) {
        CompositeDecoder compositeDecoder;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        SerialKind serialKind = descriptor2.getKind();
        if (Intrinsics.areEqual(serialKind, StructureKind.LIST.INSTANCE)) {
            compositeDecoder = new RepeatedDecoder(this.proto, this.reader, this.getCurrentTagOrDefault(), descriptor2);
        } else {
            if (Intrinsics.areEqual(serialKind, StructureKind.CLASS.INSTANCE) || Intrinsics.areEqual(serialKind, StructureKind.OBJECT.INSTANCE) || serialKind instanceof PolymorphicKind) {
                long tag = this.getCurrentTagOrDefault();
                if (tag == 19500L && Intrinsics.areEqual(this.descriptor, descriptor2)) {
                    return this;
                }
                return new ProtobufDecoder(this.proto, ProtobufDecodingKt.access$makeDelimited(this.reader, tag), descriptor2);
            }
            if (Intrinsics.areEqual(serialKind, StructureKind.MAP.INSTANCE)) {
                compositeDecoder = new MapEntryReader(this.proto, ProtobufDecodingKt.access$makeDelimitedForced(this.reader, this.getCurrentTagOrDefault()), this.getCurrentTagOrDefault(), descriptor2);
            } else {
                throw (Throwable)new SerializationException("Primitives are not supported at top-level");
            }
        }
        return compositeDecoder;
    }

    @Override
    public void endStructure(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
    }

    @Override
    protected boolean decodeTaggedBoolean(long tag) {
        boolean bl;
        int value = this.decodeTaggedInt(tag);
        switch (value) {
            case 0: {
                bl = false;
                break;
            }
            case 1: {
                bl = true;
                break;
            }
            default: {
                throw (Throwable)new SerializationException("Unexpected boolean value: " + value);
            }
        }
        return bl;
    }

    @Override
    protected byte decodeTaggedByte(long tag) {
        return (byte)this.decodeTaggedInt(tag);
    }

    @Override
    protected short decodeTaggedShort(long tag) {
        return (short)this.decodeTaggedInt(tag);
    }

    @Override
    protected int decodeTaggedInt(long tag) {
        return tag == 19500L ? this.reader.readInt32NoTag() : this.reader.readInt(HelpersKt.getIntegerType(tag));
    }

    @Override
    protected long decodeTaggedLong(long tag) {
        return tag == 19500L ? this.reader.readLongNoTag() : this.reader.readLong(HelpersKt.getIntegerType(tag));
    }

    @Override
    protected float decodeTaggedFloat(long tag) {
        return tag == 19500L ? this.reader.readFloatNoTag() : this.reader.readFloat();
    }

    @Override
    protected double decodeTaggedDouble(long tag) {
        return tag == 19500L ? this.reader.readDoubleNoTag() : this.reader.readDouble();
    }

    @Override
    protected char decodeTaggedChar(long tag) {
        return (char)this.decodeTaggedInt(tag);
    }

    @Override
    @NotNull
    protected String decodeTaggedString(long tag) {
        return tag == 19500L ? this.reader.readStringNoTag() : this.reader.readString();
    }

    @Override
    protected int decodeTaggedEnum(long tag, @NotNull SerialDescriptor enumDescription) {
        Intrinsics.checkNotNullParameter(enumDescription, "enumDescription");
        return this.findIndexByTag(enumDescription, this.decodeTaggedInt(tag));
    }

    @Override
    public <T> T decodeSerializableValue(@NotNull DeserializationStrategy<T> deserializer) {
        Intrinsics.checkNotNullParameter(deserializer, "deserializer");
        return this.decodeSerializableValue(deserializer, null);
    }

    @Override
    protected <T> T decodeSerializableValue(@NotNull DeserializationStrategy<T> deserializer, @Nullable T previousValue) {
        Intrinsics.checkNotNullParameter(deserializer, "deserializer");
        return (T)(deserializer instanceof MapLikeSerializer ? this.deserializeMap(deserializer, previousValue) : (Intrinsics.areEqual(deserializer.getDescriptor(), BuiltinSerializersKt.ByteArraySerializer().getDescriptor()) ? (Object)this.deserializeByteArray((byte[])previousValue) : (deserializer instanceof AbstractCollectionSerializer ? ((AbstractCollectionSerializer)deserializer).merge(this, previousValue) : deserializer.deserialize(this))));
    }

    private final byte[] deserializeByteArray(byte[] previousValue) {
        long tag = this.getCurrentTagOrDefault();
        byte[] array = tag == 19500L ? this.reader.readByteArrayNoTag() : this.reader.readByteArray();
        return previousValue == null ? array : ArraysKt.plus(previousValue, array);
    }

    /*
     * WARNING - void declaration
     */
    private final <T> T deserializeMap(DeserializationStrategy<T> deserializer, T previousValue) {
        void $this$associateByTo$iv$iv;
        DeserializationStrategy<T> deserializationStrategy = deserializer;
        if (deserializationStrategy == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlinx.serialization.internal.MapLikeSerializer<kotlin.Any?, kotlin.Any?, T, *>");
        }
        MapLikeSerializer serializer2 = (MapLikeSerializer)deserializationStrategy;
        KSerializer mapEntrySerial = BuiltinSerializersKt.MapEntrySerializer(serializer2.getKeySerializer(), serializer2.getValueSerializer());
        T t = previousValue;
        if (!(t instanceof Map)) {
            t = null;
        }
        Map map2 = (Map)t;
        Set oldSet = map2 != null ? map2.entrySet() : null;
        Set setOfEntries = new LinkedHashSetSerializer(mapEntrySerial).merge(this, oldSet);
        Iterable $this$associateBy$iv = setOfEntries;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            Map.Entry it;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Object k = it.getKey();
            it = (Map.Entry)element$iv$iv;
            boolean bl2 = false;
            Object v = it.getValue();
            map3.put(k, v);
        }
        return (T)destination$iv$iv;
    }

    @Override
    protected long getTag(@NotNull SerialDescriptor $this$getTag, int index) {
        Intrinsics.checkNotNullParameter($this$getTag, "$this$getTag");
        return HelpersKt.extractParameters($this$getTag, index);
    }

    @Override
    public int decodeElementIndex(@NotNull SerialDescriptor descriptor2) {
        int index;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        while (true) {
            int protoId;
            if ((protoId = this.reader.readTag()) == -1) {
                return -1;
            }
            index = this.getIndexByTag(protoId);
            if (index != -1) break;
            this.reader.skipElement();
        }
        return index;
    }

    public ProtobufDecoder(@NotNull ProtoBuf proto, @NotNull ProtobufReader reader, @NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(proto, "proto");
        Intrinsics.checkNotNullParameter(reader, "reader");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        this.proto = proto;
        this.reader = reader;
        this.descriptor = descriptor2;
        this.populateCache(this.descriptor);
    }
}

