/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmType;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmTypeFactory;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmClassName;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

final class JvmTypeFactoryImpl
implements JvmTypeFactory<JvmType> {
    @NotNull
    public static final JvmTypeFactoryImpl INSTANCE = new JvmTypeFactoryImpl();

    private JvmTypeFactoryImpl() {
    }

    @Override
    @NotNull
    public JvmType boxType(@NotNull JvmType possiblyPrimitiveType) {
        JvmType jvmType;
        Intrinsics.checkNotNullParameter(possiblyPrimitiveType, "possiblyPrimitiveType");
        if (possiblyPrimitiveType instanceof JvmType.Primitive && ((JvmType.Primitive)possiblyPrimitiveType).getJvmPrimitiveType() != null) {
            String string = JvmClassName.byFqNameWithoutInnerClasses(((JvmType.Primitive)possiblyPrimitiveType).getJvmPrimitiveType().getWrapperFqName()).getInternalName();
            Intrinsics.checkNotNullExpressionValue(string, "byFqNameWithoutInnerClasses(possiblyPrimitiveType.jvmPrimitiveType.wrapperFqName).internalName");
            jvmType = this.createObjectType(string);
        } else {
            jvmType = possiblyPrimitiveType;
        }
        return jvmType;
    }

    @Override
    @NotNull
    public JvmType createFromString(@NotNull String representation) {
        JvmType jvmType;
        int n;
        Object object;
        JvmPrimitiveType jvmPrimitiveType;
        int n2;
        char firstChar;
        block8: {
            JvmPrimitiveType jvmPrimitiveType2;
            Intrinsics.checkNotNullParameter(representation, "representation");
            CharSequence charSequence = representation;
            boolean bl = false;
            boolean bl2 = charSequence.length() > 0;
            bl = false;
            if (_Assertions.ENABLED && !bl2) {
                boolean $i$a$-assert-JvmTypeFactoryImpl$createFromString$22 = false;
                String $i$a$-assert-JvmTypeFactoryImpl$createFromString$22 = "empty string as JvmType";
                throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-JvmTypeFactoryImpl$createFromString$22));
            }
            firstChar = representation.charAt(0);
            JvmPrimitiveType[] $this$firstOrNull$iv = JvmPrimitiveType.values();
            boolean $i$f$firstOrNull = false;
            JvmPrimitiveType[] jvmPrimitiveTypeArray = $this$firstOrNull$iv;
            n2 = jvmPrimitiveTypeArray.length;
            for (int j = 0; j < n2; ++j) {
                JvmPrimitiveType element$iv;
                JvmPrimitiveType it = element$iv = jvmPrimitiveTypeArray[j];
                boolean bl3 = false;
                if (!(it.getDesc().charAt(0) == firstChar)) continue;
                jvmPrimitiveType2 = element$iv;
                break block8;
            }
            jvmPrimitiveType2 = jvmPrimitiveType = null;
        }
        if (jvmPrimitiveType != null) {
            object = jvmPrimitiveType;
            n = 0;
            boolean bl = false;
            JvmPrimitiveType it = object;
            boolean bl4 = false;
            return new JvmType.Primitive(it);
        }
        char c = firstChar;
        if (c == 'V') {
            jvmType = new JvmType.Primitive(null);
        } else if (c == '[') {
            object = representation;
            n = 1;
            boolean bl = false;
            String string = ((String)object).substring(n);
            Intrinsics.checkNotNullExpressionValue(string, "(this as java.lang.String).substring(startIndex)");
            jvmType = new JvmType.Array(this.createFromString(string));
        } else {
            boolean bl = firstChar == 'L' && StringsKt.endsWith$default((CharSequence)representation, ';', false, 2, null);
            n = 0;
            if (_Assertions.ENABLED && !bl) {
                boolean bl5 = false;
                String string = "Type that is not primitive nor array should be Object, but '" + representation + "' was found";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            String string = representation;
            n = 1;
            int n3 = representation.length() - 1;
            n2 = 0;
            String string2 = string.substring(n, n3);
            Intrinsics.checkNotNullExpressionValue(string2, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            jvmType = new JvmType.Object(string2);
        }
        return jvmType;
    }

    @Override
    @NotNull
    public JvmType createPrimitiveType(@NotNull PrimitiveType primitiveType) {
        JvmType jvmType;
        Intrinsics.checkNotNullParameter((Object)primitiveType, "primitiveType");
        PrimitiveType primitiveType2 = primitiveType;
        int n = WhenMappings.$EnumSwitchMapping$0[primitiveType2.ordinal()];
        switch (n) {
            case 1: {
                jvmType = JvmType.Companion.getBOOLEAN$descriptors_jvm();
                break;
            }
            case 2: {
                jvmType = JvmType.Companion.getCHAR$descriptors_jvm();
                break;
            }
            case 3: {
                jvmType = JvmType.Companion.getBYTE$descriptors_jvm();
                break;
            }
            case 4: {
                jvmType = JvmType.Companion.getSHORT$descriptors_jvm();
                break;
            }
            case 5: {
                jvmType = JvmType.Companion.getINT$descriptors_jvm();
                break;
            }
            case 6: {
                jvmType = JvmType.Companion.getFLOAT$descriptors_jvm();
                break;
            }
            case 7: {
                jvmType = JvmType.Companion.getLONG$descriptors_jvm();
                break;
            }
            case 8: {
                jvmType = JvmType.Companion.getDOUBLE$descriptors_jvm();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return jvmType;
    }

    @Override
    @NotNull
    public JvmType.Object createObjectType(@NotNull String internalName) {
        Intrinsics.checkNotNullParameter(internalName, "internalName");
        return new JvmType.Object(internalName);
    }

    @Override
    @NotNull
    public String toString(@NotNull JvmType type2) {
        String string;
        Intrinsics.checkNotNullParameter(type2, "type");
        JvmType jvmType = type2;
        if (jvmType instanceof JvmType.Array) {
            string = Intrinsics.stringPlus("[", this.toString(((JvmType.Array)type2).getElementType()));
        } else if (jvmType instanceof JvmType.Primitive) {
            String string2;
            String string3;
            JvmPrimitiveType jvmPrimitiveType = ((JvmType.Primitive)type2).getJvmPrimitiveType();
            string = string3 = jvmPrimitiveType == null ? "V" : ((string2 = jvmPrimitiveType.getDesc()) == null ? "V" : string2);
        } else if (jvmType instanceof JvmType.Object) {
            string = 'L' + ((JvmType.Object)type2).getInternalName() + ';';
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    @Override
    @NotNull
    public JvmType getJavaLangClassType() {
        return this.createObjectType("java/lang/Class");
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PrimitiveType.values().length];
            nArray[PrimitiveType.BOOLEAN.ordinal()] = 1;
            nArray[PrimitiveType.CHAR.ordinal()] = 2;
            nArray[PrimitiveType.BYTE.ordinal()] = 3;
            nArray[PrimitiveType.SHORT.ordinal()] = 4;
            nArray[PrimitiveType.INT.ordinal()] = 5;
            nArray[PrimitiveType.FLOAT.ordinal()] = 6;
            nArray[PrimitiveType.LONG.ordinal()] = 7;
            nArray[PrimitiveType.DOUBLE.ordinal()] = 8;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

