/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.Http2Error;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SuppressJava6Requirement;
import io.netty.util.internal.ThrowableUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Http2Exception
extends Exception {
    private static final long serialVersionUID = -6941186345430164209L;
    private final Http2Error error;
    private final ShutdownHint shutdownHint;

    public Http2Exception(Http2Error error) {
        this(error, ShutdownHint.HARD_SHUTDOWN);
    }

    public Http2Exception(Http2Error error, ShutdownHint shutdownHint) {
        this.error = ObjectUtil.checkNotNull(error, "error");
        this.shutdownHint = ObjectUtil.checkNotNull(shutdownHint, "shutdownHint");
    }

    public Http2Exception(Http2Error error, String message2) {
        this(error, message2, ShutdownHint.HARD_SHUTDOWN);
    }

    public Http2Exception(Http2Error error, String message2, ShutdownHint shutdownHint) {
        super(message2);
        this.error = ObjectUtil.checkNotNull(error, "error");
        this.shutdownHint = ObjectUtil.checkNotNull(shutdownHint, "shutdownHint");
    }

    public Http2Exception(Http2Error error, String message2, Throwable cause) {
        this(error, message2, cause, ShutdownHint.HARD_SHUTDOWN);
    }

    public Http2Exception(Http2Error error, String message2, Throwable cause, ShutdownHint shutdownHint) {
        super(message2, cause);
        this.error = ObjectUtil.checkNotNull(error, "error");
        this.shutdownHint = ObjectUtil.checkNotNull(shutdownHint, "shutdownHint");
    }

    static Http2Exception newStatic(Http2Error error, String message2, ShutdownHint shutdownHint, Class<?> clazz, String method) {
        StacklessHttp2Exception exception = PlatformDependent.javaVersion() >= 7 ? new StacklessHttp2Exception(error, message2, shutdownHint, true) : new StacklessHttp2Exception(error, message2, shutdownHint);
        return ThrowableUtil.unknownStackTrace(exception, clazz, method);
    }

    @SuppressJava6Requirement(reason="uses Java 7+ Exception.<init>(String, Throwable, boolean, boolean) but is guarded by version checks")
    private Http2Exception(Http2Error error, String message2, ShutdownHint shutdownHint, boolean shared2) {
        super(message2, null, false, true);
        assert (shared2);
        this.error = ObjectUtil.checkNotNull(error, "error");
        this.shutdownHint = ObjectUtil.checkNotNull(shutdownHint, "shutdownHint");
    }

    public Http2Error error() {
        return this.error;
    }

    public ShutdownHint shutdownHint() {
        return this.shutdownHint;
    }

    public static Http2Exception connectionError(Http2Error error, String fmt, Object ... args2) {
        return new Http2Exception(error, String.format(fmt, args2));
    }

    public static Http2Exception connectionError(Http2Error error, Throwable cause, String fmt, Object ... args2) {
        return new Http2Exception(error, String.format(fmt, args2), cause);
    }

    public static Http2Exception closedStreamError(Http2Error error, String fmt, Object ... args2) {
        return new ClosedStreamCreationException(error, String.format(fmt, args2));
    }

    public static Http2Exception streamError(int id2, Http2Error error, String fmt, Object ... args2) {
        return 0 == id2 ? Http2Exception.connectionError(error, fmt, args2) : new StreamException(id2, error, String.format(fmt, args2));
    }

    public static Http2Exception streamError(int id2, Http2Error error, Throwable cause, String fmt, Object ... args2) {
        return 0 == id2 ? Http2Exception.connectionError(error, cause, fmt, args2) : new StreamException(id2, error, String.format(fmt, args2), cause);
    }

    public static Http2Exception headerListSizeError(int id2, Http2Error error, boolean onDecode, String fmt, Object ... args2) {
        return 0 == id2 ? Http2Exception.connectionError(error, fmt, args2) : new HeaderListSizeException(id2, error, String.format(fmt, args2), onDecode);
    }

    public static boolean isStreamError(Http2Exception e) {
        return e instanceof StreamException;
    }

    public static int streamId(Http2Exception e) {
        return Http2Exception.isStreamError(e) ? ((StreamException)e).streamId() : 0;
    }

    private static final class StacklessHttp2Exception
    extends Http2Exception {
        private static final long serialVersionUID = 1077888485687219443L;

        StacklessHttp2Exception(Http2Error error, String message2, ShutdownHint shutdownHint) {
            super(error, message2, shutdownHint);
        }

        StacklessHttp2Exception(Http2Error error, String message2, ShutdownHint shutdownHint, boolean shared2) {
            super(error, message2, shutdownHint, shared2);
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    public static final class CompositeStreamException
    extends Http2Exception
    implements Iterable<StreamException> {
        private static final long serialVersionUID = 7091134858213711015L;
        private final List<StreamException> exceptions;

        public CompositeStreamException(Http2Error error, int initialCapacity) {
            super(error, ShutdownHint.NO_SHUTDOWN);
            this.exceptions = new ArrayList<StreamException>(initialCapacity);
        }

        public void add(StreamException e) {
            this.exceptions.add(e);
        }

        @Override
        public Iterator<StreamException> iterator() {
            return this.exceptions.iterator();
        }
    }

    public static final class HeaderListSizeException
    extends StreamException {
        private static final long serialVersionUID = -8807603212183882637L;
        private final boolean decode;

        HeaderListSizeException(int streamId, Http2Error error, String message2, boolean decode2) {
            super(streamId, error, message2);
            this.decode = decode2;
        }

        public boolean duringDecode() {
            return this.decode;
        }
    }

    public static class StreamException
    extends Http2Exception {
        private static final long serialVersionUID = 602472544416984384L;
        private final int streamId;

        StreamException(int streamId, Http2Error error, String message2) {
            super(error, message2, ShutdownHint.NO_SHUTDOWN);
            this.streamId = streamId;
        }

        StreamException(int streamId, Http2Error error, String message2, Throwable cause) {
            super(error, message2, cause, ShutdownHint.NO_SHUTDOWN);
            this.streamId = streamId;
        }

        public int streamId() {
            return this.streamId;
        }
    }

    public static final class ClosedStreamCreationException
    extends Http2Exception {
        private static final long serialVersionUID = -6746542974372246206L;

        public ClosedStreamCreationException(Http2Error error) {
            super(error);
        }

        public ClosedStreamCreationException(Http2Error error, String message2) {
            super(error, message2);
        }

        public ClosedStreamCreationException(Http2Error error, String message2, Throwable cause) {
            super(error, message2, cause);
        }
    }

    public static enum ShutdownHint {
        NO_SHUTDOWN,
        GRACEFUL_SHUTDOWN,
        HARD_SHUTDOWN;

    }
}

