/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.compression.Crc32c;
import io.netty.handler.codec.compression.DecompressionException;

public final class Snappy {
    private static final int MAX_HT_SIZE = 16384;
    private static final int MIN_COMPRESSIBLE_BYTES = 15;
    private static final int PREAMBLE_NOT_FULL = -1;
    private static final int NOT_ENOUGH_INPUT = -1;
    private static final int LITERAL = 0;
    private static final int COPY_1_BYTE_OFFSET = 1;
    private static final int COPY_2_BYTE_OFFSET = 2;
    private static final int COPY_4_BYTE_OFFSET = 3;
    private State state = State.READY;
    private byte tag;
    private int written;

    public void reset() {
        this.state = State.READY;
        this.tag = 0;
        this.written = 0;
    }

    public void encode(ByteBuf in, ByteBuf out2, int length2) {
        int inIndex;
        int b;
        int i2 = 0;
        while (true) {
            if (((b = length2 >>> i2 * 7) & 0xFFFFFF80) == 0) break;
            out2.writeByte(b & 0x7F | 0x80);
            ++i2;
        }
        out2.writeByte(b);
        int baseIndex = inIndex = in.readerIndex();
        short[] table = Snappy.getHashTable(length2);
        int shift = Integer.numberOfLeadingZeros(table.length) + 1;
        int nextEmit = inIndex;
        if (length2 - inIndex >= 15) {
            int nextHash = Snappy.hash(in, ++inIndex, shift);
            block1: while (true) {
                int insertTail;
                int candidate;
                int skip = 32;
                int nextIndex = inIndex;
                do {
                    int bytesBetweenHashLookups;
                    inIndex = nextIndex;
                    int hash = nextHash;
                    if ((nextIndex = inIndex + (bytesBetweenHashLookups = skip++ >> 5)) > length2 - 4) break block1;
                    nextHash = Snappy.hash(in, nextIndex, shift);
                    candidate = baseIndex + table[hash];
                    table[hash] = (short)(inIndex - baseIndex);
                } while (in.getInt(inIndex) != in.getInt(candidate));
                Snappy.encodeLiteral(in, out2, inIndex - nextEmit);
                do {
                    int base2 = inIndex;
                    int matched = 4 + Snappy.findMatchingLength(in, candidate + 4, inIndex + 4, length2);
                    int offset = base2 - candidate;
                    Snappy.encodeCopy(out2, offset, matched);
                    in.readerIndex(in.readerIndex() + matched);
                    insertTail = (inIndex += matched) - 1;
                    nextEmit = inIndex;
                    if (inIndex >= length2 - 4) break block1;
                    int prevHash = Snappy.hash(in, insertTail, shift);
                    table[prevHash] = (short)(inIndex - baseIndex - 1);
                    int currentHash = Snappy.hash(in, insertTail + 1, shift);
                    candidate = baseIndex + table[currentHash];
                    table[currentHash] = (short)(inIndex - baseIndex);
                } while (in.getInt(insertTail + 1) == in.getInt(candidate));
                nextHash = Snappy.hash(in, insertTail + 2, shift);
                ++inIndex;
            }
        }
        if (nextEmit < length2) {
            Snappy.encodeLiteral(in, out2, length2 - nextEmit);
        }
    }

    private static int hash(ByteBuf in, int index, int shift) {
        return in.getInt(index) * 506832829 >>> shift;
    }

    private static short[] getHashTable(int inputSize) {
        int htSize;
        for (htSize = 256; htSize < 16384 && htSize < inputSize; htSize <<= 1) {
        }
        return new short[htSize];
    }

    private static int findMatchingLength(ByteBuf in, int minIndex, int inIndex, int maxIndex) {
        int matched = 0;
        while (inIndex <= maxIndex - 4 && in.getInt(inIndex) == in.getInt(minIndex + matched)) {
            inIndex += 4;
            matched += 4;
        }
        while (inIndex < maxIndex && in.getByte(minIndex + matched) == in.getByte(inIndex)) {
            ++inIndex;
            ++matched;
        }
        return matched;
    }

    private static int bitsToEncode(int value) {
        int highestOneBit = Integer.highestOneBit(value);
        int bitLength = 0;
        while ((highestOneBit >>= 1) != 0) {
            ++bitLength;
        }
        return bitLength;
    }

    static void encodeLiteral(ByteBuf in, ByteBuf out2, int length2) {
        if (length2 < 61) {
            out2.writeByte(length2 - 1 << 2);
        } else {
            int bitLength = Snappy.bitsToEncode(length2 - 1);
            int bytesToEncode = 1 + bitLength / 8;
            out2.writeByte(59 + bytesToEncode << 2);
            for (int i2 = 0; i2 < bytesToEncode; ++i2) {
                out2.writeByte(length2 - 1 >> i2 * 8 & 0xFF);
            }
        }
        out2.writeBytes(in, length2);
    }

    private static void encodeCopyWithOffset(ByteBuf out2, int offset, int length2) {
        if (length2 < 12 && offset < 2048) {
            out2.writeByte(1 | length2 - 4 << 2 | offset >> 8 << 5);
            out2.writeByte(offset & 0xFF);
        } else {
            out2.writeByte(2 | length2 - 1 << 2);
            out2.writeByte(offset & 0xFF);
            out2.writeByte(offset >> 8 & 0xFF);
        }
    }

    private static void encodeCopy(ByteBuf out2, int offset, int length2) {
        while (length2 >= 68) {
            Snappy.encodeCopyWithOffset(out2, offset, 64);
            length2 -= 64;
        }
        if (length2 > 64) {
            Snappy.encodeCopyWithOffset(out2, offset, 60);
            length2 -= 60;
        }
        Snappy.encodeCopyWithOffset(out2, offset, length2);
    }

    public void decode(ByteBuf in, ByteBuf out2) {
        while (in.isReadable()) {
            block0 : switch (this.state) {
                case READY: {
                    this.state = State.READING_PREAMBLE;
                }
                case READING_PREAMBLE: {
                    int uncompressedLength = Snappy.readPreamble(in);
                    if (uncompressedLength == -1) {
                        return;
                    }
                    if (uncompressedLength == 0) {
                        this.state = State.READY;
                        return;
                    }
                    out2.ensureWritable(uncompressedLength);
                    this.state = State.READING_TAG;
                }
                case READING_TAG: {
                    if (!in.isReadable()) {
                        return;
                    }
                    this.tag = in.readByte();
                    switch (this.tag & 3) {
                        case 0: {
                            this.state = State.READING_LITERAL;
                            break block0;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            this.state = State.READING_COPY;
                        }
                    }
                    break;
                }
                case READING_LITERAL: {
                    int literalWritten = Snappy.decodeLiteral(this.tag, in, out2);
                    if (literalWritten != -1) {
                        this.state = State.READING_TAG;
                        this.written += literalWritten;
                        break;
                    }
                    return;
                }
                case READING_COPY: {
                    switch (this.tag & 3) {
                        case 1: {
                            int decodeWritten = Snappy.decodeCopyWith1ByteOffset(this.tag, in, out2, this.written);
                            if (decodeWritten != -1) {
                                this.state = State.READING_TAG;
                                this.written += decodeWritten;
                                break block0;
                            }
                            return;
                        }
                        case 2: {
                            int decodeWritten = Snappy.decodeCopyWith2ByteOffset(this.tag, in, out2, this.written);
                            if (decodeWritten != -1) {
                                this.state = State.READING_TAG;
                                this.written += decodeWritten;
                                break block0;
                            }
                            return;
                        }
                        case 3: {
                            int decodeWritten = Snappy.decodeCopyWith4ByteOffset(this.tag, in, out2, this.written);
                            if (decodeWritten != -1) {
                                this.state = State.READING_TAG;
                                this.written += decodeWritten;
                                break block0;
                            }
                            return;
                        }
                    }
                }
            }
        }
    }

    private static int readPreamble(ByteBuf in) {
        int length2 = 0;
        int byteIndex = 0;
        while (in.isReadable()) {
            short current = in.readUnsignedByte();
            length2 |= (current & 0x7F) << byteIndex++ * 7;
            if ((current & 0x80) == 0) {
                return length2;
            }
            if (byteIndex < 4) continue;
            throw new DecompressionException("Preamble is greater than 4 bytes");
        }
        return 0;
    }

    static int decodeLiteral(byte tag, ByteBuf in, ByteBuf out2) {
        int length2;
        in.markReaderIndex();
        switch (tag >> 2 & 0x3F) {
            case 60: {
                if (!in.isReadable()) {
                    return -1;
                }
                length2 = in.readUnsignedByte();
                break;
            }
            case 61: {
                if (in.readableBytes() < 2) {
                    return -1;
                }
                length2 = in.readUnsignedShortLE();
                break;
            }
            case 62: {
                if (in.readableBytes() < 3) {
                    return -1;
                }
                length2 = in.readUnsignedMediumLE();
                break;
            }
            case 63: {
                if (in.readableBytes() < 4) {
                    return -1;
                }
                length2 = in.readIntLE();
                break;
            }
            default: {
                length2 = tag >> 2 & 0x3F;
            }
        }
        if (in.readableBytes() < ++length2) {
            in.resetReaderIndex();
            return -1;
        }
        out2.writeBytes(in, length2);
        return length2;
    }

    private static int decodeCopyWith1ByteOffset(byte tag, ByteBuf in, ByteBuf out2, int writtenSoFar) {
        if (!in.isReadable()) {
            return -1;
        }
        int initialIndex = out2.writerIndex();
        int length2 = 4 + ((tag & 0x1C) >> 2);
        int offset = (tag & 0xE0) << 8 >> 5 | in.readUnsignedByte();
        Snappy.validateOffset(offset, writtenSoFar);
        out2.markReaderIndex();
        if (offset < length2) {
            for (int copies = length2 / offset; copies > 0; --copies) {
                out2.readerIndex(initialIndex - offset);
                out2.readBytes(out2, offset);
            }
            if (length2 % offset != 0) {
                out2.readerIndex(initialIndex - offset);
                out2.readBytes(out2, length2 % offset);
            }
        } else {
            out2.readerIndex(initialIndex - offset);
            out2.readBytes(out2, length2);
        }
        out2.resetReaderIndex();
        return length2;
    }

    private static int decodeCopyWith2ByteOffset(byte tag, ByteBuf in, ByteBuf out2, int writtenSoFar) {
        if (in.readableBytes() < 2) {
            return -1;
        }
        int initialIndex = out2.writerIndex();
        int length2 = 1 + (tag >> 2 & 0x3F);
        int offset = in.readUnsignedShortLE();
        Snappy.validateOffset(offset, writtenSoFar);
        out2.markReaderIndex();
        if (offset < length2) {
            for (int copies = length2 / offset; copies > 0; --copies) {
                out2.readerIndex(initialIndex - offset);
                out2.readBytes(out2, offset);
            }
            if (length2 % offset != 0) {
                out2.readerIndex(initialIndex - offset);
                out2.readBytes(out2, length2 % offset);
            }
        } else {
            out2.readerIndex(initialIndex - offset);
            out2.readBytes(out2, length2);
        }
        out2.resetReaderIndex();
        return length2;
    }

    private static int decodeCopyWith4ByteOffset(byte tag, ByteBuf in, ByteBuf out2, int writtenSoFar) {
        if (in.readableBytes() < 4) {
            return -1;
        }
        int initialIndex = out2.writerIndex();
        int length2 = 1 + (tag >> 2 & 0x3F);
        int offset = in.readIntLE();
        Snappy.validateOffset(offset, writtenSoFar);
        out2.markReaderIndex();
        if (offset < length2) {
            for (int copies = length2 / offset; copies > 0; --copies) {
                out2.readerIndex(initialIndex - offset);
                out2.readBytes(out2, offset);
            }
            if (length2 % offset != 0) {
                out2.readerIndex(initialIndex - offset);
                out2.readBytes(out2, length2 % offset);
            }
        } else {
            out2.readerIndex(initialIndex - offset);
            out2.readBytes(out2, length2);
        }
        out2.resetReaderIndex();
        return length2;
    }

    private static void validateOffset(int offset, int chunkSizeSoFar) {
        if (offset == 0) {
            throw new DecompressionException("Offset is less than minimum permissible value");
        }
        if (offset < 0) {
            throw new DecompressionException("Offset is greater than maximum value supported by this implementation");
        }
        if (offset > chunkSizeSoFar) {
            throw new DecompressionException("Offset exceeds size of chunk");
        }
    }

    static int calculateChecksum(ByteBuf data2) {
        return Snappy.calculateChecksum(data2, data2.readerIndex(), data2.readableBytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int calculateChecksum(ByteBuf data2, int offset, int length2) {
        Crc32c crc32 = new Crc32c();
        try {
            crc32.update(data2, offset, length2);
            int n = Snappy.maskChecksum(crc32.getValue());
            return n;
        }
        finally {
            crc32.reset();
        }
    }

    static void validateChecksum(int expectedChecksum, ByteBuf data2) {
        Snappy.validateChecksum(expectedChecksum, data2, data2.readerIndex(), data2.readableBytes());
    }

    static void validateChecksum(int expectedChecksum, ByteBuf data2, int offset, int length2) {
        int actualChecksum = Snappy.calculateChecksum(data2, offset, length2);
        if (actualChecksum != expectedChecksum) {
            throw new DecompressionException("mismatching checksum: " + Integer.toHexString(actualChecksum) + " (expected: " + Integer.toHexString(expectedChecksum) + ')');
        }
    }

    static int maskChecksum(long checksum) {
        return (int)((checksum >> 15 | checksum << 17) + -1568478504L);
    }

    private static enum State {
        READY,
        READING_PREAMBLE,
        READING_TAG,
        READING_LITERAL,
        READING_COPY;

    }
}

