/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.util.ByteProcessor;
import java.util.List;

public class LineBasedFrameDecoder
extends ByteToMessageDecoder {
    private final int maxLength;
    private final boolean failFast;
    private final boolean stripDelimiter;
    private boolean discarding;
    private int discardedBytes;
    private int offset;

    public LineBasedFrameDecoder(int maxLength) {
        this(maxLength, true, false);
    }

    public LineBasedFrameDecoder(int maxLength, boolean stripDelimiter, boolean failFast) {
        this.maxLength = maxLength;
        this.failFast = failFast;
        this.stripDelimiter = stripDelimiter;
    }

    @Override
    protected final void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out2) throws Exception {
        Object decoded = this.decode(ctx, in);
        if (decoded != null) {
            out2.add(decoded);
        }
    }

    protected Object decode(ChannelHandlerContext ctx, ByteBuf buffer) throws Exception {
        int eol = this.findEndOfLine(buffer);
        if (!this.discarding) {
            if (eol >= 0) {
                ByteBuf frame;
                int delimLength;
                int length2 = eol - buffer.readerIndex();
                int n = delimLength = buffer.getByte(eol) == 13 ? 2 : 1;
                if (length2 > this.maxLength) {
                    buffer.readerIndex(eol + delimLength);
                    this.fail(ctx, length2);
                    return null;
                }
                if (this.stripDelimiter) {
                    frame = buffer.readRetainedSlice(length2);
                    buffer.skipBytes(delimLength);
                } else {
                    frame = buffer.readRetainedSlice(length2 + delimLength);
                }
                return frame;
            }
            int length3 = buffer.readableBytes();
            if (length3 > this.maxLength) {
                this.discardedBytes = length3;
                buffer.readerIndex(buffer.writerIndex());
                this.discarding = true;
                this.offset = 0;
                if (this.failFast) {
                    this.fail(ctx, "over " + this.discardedBytes);
                }
            }
            return null;
        }
        if (eol >= 0) {
            int length4 = this.discardedBytes + eol - buffer.readerIndex();
            int delimLength = buffer.getByte(eol) == 13 ? 2 : 1;
            buffer.readerIndex(eol + delimLength);
            this.discardedBytes = 0;
            this.discarding = false;
            if (!this.failFast) {
                this.fail(ctx, length4);
            }
        } else {
            this.discardedBytes += buffer.readableBytes();
            buffer.readerIndex(buffer.writerIndex());
            this.offset = 0;
        }
        return null;
    }

    private void fail(ChannelHandlerContext ctx, int length2) {
        this.fail(ctx, String.valueOf(length2));
    }

    private void fail(ChannelHandlerContext ctx, String length2) {
        ctx.fireExceptionCaught(new TooLongFrameException("frame length (" + length2 + ") exceeds the allowed maximum (" + this.maxLength + ')'));
    }

    private int findEndOfLine(ByteBuf buffer) {
        int totalLength = buffer.readableBytes();
        int i2 = buffer.forEachByte(buffer.readerIndex() + this.offset, totalLength - this.offset, ByteProcessor.FIND_LF);
        if (i2 >= 0) {
            this.offset = 0;
            if (i2 > 0 && buffer.getByte(i2 - 1) == 13) {
                --i2;
            }
        } else {
            this.offset = totalLength;
        }
        return i2;
    }
}

