/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.util.internal.ObjectUtil;
import java.nio.ByteOrder;
import java.util.List;

@ChannelHandler.Sharable
public class LengthFieldPrepender
extends MessageToMessageEncoder<ByteBuf> {
    private final ByteOrder byteOrder;
    private final int lengthFieldLength;
    private final boolean lengthIncludesLengthFieldLength;
    private final int lengthAdjustment;

    public LengthFieldPrepender(int lengthFieldLength) {
        this(lengthFieldLength, false);
    }

    public LengthFieldPrepender(int lengthFieldLength, boolean lengthIncludesLengthFieldLength) {
        this(lengthFieldLength, 0, lengthIncludesLengthFieldLength);
    }

    public LengthFieldPrepender(int lengthFieldLength, int lengthAdjustment) {
        this(lengthFieldLength, lengthAdjustment, false);
    }

    public LengthFieldPrepender(int lengthFieldLength, int lengthAdjustment, boolean lengthIncludesLengthFieldLength) {
        this(ByteOrder.BIG_ENDIAN, lengthFieldLength, lengthAdjustment, lengthIncludesLengthFieldLength);
    }

    public LengthFieldPrepender(ByteOrder byteOrder, int lengthFieldLength, int lengthAdjustment, boolean lengthIncludesLengthFieldLength) {
        if (lengthFieldLength != 1 && lengthFieldLength != 2 && lengthFieldLength != 3 && lengthFieldLength != 4 && lengthFieldLength != 8) {
            throw new IllegalArgumentException("lengthFieldLength must be either 1, 2, 3, 4, or 8: " + lengthFieldLength);
        }
        this.byteOrder = ObjectUtil.checkNotNull(byteOrder, "byteOrder");
        this.lengthFieldLength = lengthFieldLength;
        this.lengthIncludesLengthFieldLength = lengthIncludesLengthFieldLength;
        this.lengthAdjustment = lengthAdjustment;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out2) throws Exception {
        int length2 = msg.readableBytes() + this.lengthAdjustment;
        if (this.lengthIncludesLengthFieldLength) {
            length2 += this.lengthFieldLength;
        }
        ObjectUtil.checkPositiveOrZero(length2, "length");
        switch (this.lengthFieldLength) {
            case 1: {
                if (length2 >= 256) {
                    throw new IllegalArgumentException("length does not fit into a byte: " + length2);
                }
                out2.add(ctx.alloc().buffer(1).order(this.byteOrder).writeByte((byte)length2));
                break;
            }
            case 2: {
                if (length2 >= 65536) {
                    throw new IllegalArgumentException("length does not fit into a short integer: " + length2);
                }
                out2.add(ctx.alloc().buffer(2).order(this.byteOrder).writeShort((short)length2));
                break;
            }
            case 3: {
                if (length2 >= 0x1000000) {
                    throw new IllegalArgumentException("length does not fit into a medium integer: " + length2);
                }
                out2.add(ctx.alloc().buffer(3).order(this.byteOrder).writeMedium(length2));
                break;
            }
            case 4: {
                out2.add(ctx.alloc().buffer(4).order(this.byteOrder).writeInt(length2));
                break;
            }
            case 8: {
                out2.add(ctx.alloc().buffer(8).order(this.byteOrder).writeLong(length2));
                break;
            }
            default: {
                throw new Error("should not reach here");
            }
        }
        out2.add(msg.retain());
    }
}

