/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.BadContentTypeFormatException;
import io.ktor.http.HeaderValue;
import io.ktor.http.HeaderValueParam;
import io.ktor.http.HeaderValueWithParameters;
import io.ktor.http.HttpHeaderValueParserKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\r\u0018\u0000 \u001d2\u00020\u0001:\b\u001b\u001c\u001d\u001e\u001f !\"B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bB/\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u000e\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0000J\u000e\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0003J\u0016\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003J\u0006\u0010\u001a\u001a\u00020\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006#"}, d2={"Lio/ktor/http/ContentType;", "Lio/ktor/http/HeaderValueWithParameters;", "contentType", "", "contentSubtype", "parameters", "", "Lio/ktor/http/HeaderValueParam;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "existingContent", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getContentSubtype", "()Ljava/lang/String;", "getContentType", "equals", "", "other", "", "hasParameter", "name", "value", "hashCode", "", "match", "pattern", "withParameter", "withoutParameters", "Application", "Audio", "Companion", "Image", "Message", "MultiPart", "Text", "Video", "ktor-http"})
public final class ContentType
extends HeaderValueWithParameters {
    @NotNull
    private final String contentType;
    @NotNull
    private final String contentSubtype;
    @NotNull
    private static final ContentType Any;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final ContentType withParameter(@NotNull String name2, @NotNull String value) {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(value, "value");
        if (this.hasParameter(name2, value)) {
            return this;
        }
        return new ContentType(this.contentType, this.contentSubtype, this.getContent(), CollectionsKt.plus((Collection)this.getParameters(), new HeaderValueParam(name2, value)));
    }

    private final boolean hasParameter(String name2, String value) {
        boolean bl;
        block0 : switch (this.getParameters().size()) {
            case 0: {
                bl = false;
                break;
            }
            case 1: {
                HeaderValueParam headerValueParam = this.getParameters().get(0);
                boolean bl2 = false;
                boolean bl3 = false;
                HeaderValueParam it = headerValueParam;
                boolean bl4 = false;
                if (StringsKt.equals(it.getName(), name2, true) && StringsKt.equals(it.getValue(), value, true)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            default: {
                Iterable $this$any$iv = this.getParameters();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                    break;
                }
                for (Object element$iv : $this$any$iv) {
                    HeaderValueParam it = (HeaderValueParam)element$iv;
                    boolean bl5 = false;
                    if (!(StringsKt.equals(it.getName(), name2, true) && StringsKt.equals(it.getValue(), value, true))) continue;
                    bl = true;
                    break block0;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final ContentType withoutParameters() {
        return this.getParameters().isEmpty() ? this : new ContentType(this.contentType, this.contentSubtype, null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean match(@NotNull ContentType pattern) {
        Intrinsics.checkNotNullParameter(pattern, "pattern");
        if (Intrinsics.areEqual(pattern.contentType, "*") ^ true && !StringsKt.equals(pattern.contentType, this.contentType, true)) {
            return false;
        }
        if (Intrinsics.areEqual(pattern.contentSubtype, "*") ^ true && !StringsKt.equals(pattern.contentSubtype, this.contentSubtype, true)) {
            return false;
        }
        for (HeaderValueParam headerValueParam : pattern.getParameters()) {
            boolean matches;
            boolean bl;
            void patternName;
            String string = headerValueParam.component1();
            String patternValue = headerValueParam.component2();
            void var7_7 = patternName;
            block0 : switch (var7_7.hashCode()) {
                case 42: {
                    if (var7_7.equals("*")) {
                        String string2 = patternValue;
                        switch (string2.hashCode()) {
                            case 42: {
                                if (!string2.equals("*")) break;
                                bl = true;
                                break block0;
                            }
                        }
                        Iterable $this$any$iv = this.getParameters();
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                            break;
                        }
                        for (Object element$iv : $this$any$iv) {
                            HeaderValueParam p = (HeaderValueParam)element$iv;
                            boolean bl2 = false;
                            if (!StringsKt.equals(p.getValue(), patternValue, true)) continue;
                            bl = true;
                            break block0;
                        }
                        bl = false;
                        break;
                    }
                }
                default: {
                    String value = this.parameter((String)patternName);
                    String string3 = patternValue;
                    switch (string3.hashCode()) {
                        case 42: {
                            if (!string3.equals("*")) break;
                            if (value != null) {
                                bl = true;
                                break block0;
                            }
                            bl = false;
                            break block0;
                        }
                    }
                    bl = StringsKt.equals(value, patternValue, true);
                }
            }
            if (matches = bl) continue;
            return false;
        }
        return true;
    }

    public final boolean match(@NotNull String pattern) {
        Intrinsics.checkNotNullParameter(pattern, "pattern");
        return this.match(Companion.parse(pattern));
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof ContentType && StringsKt.equals(this.contentType, ((ContentType)other).contentType, true) && StringsKt.equals(this.contentSubtype, ((ContentType)other).contentSubtype, true) && Intrinsics.areEqual(this.getParameters(), ((ContentType)other).getParameters());
    }

    public int hashCode() {
        String string = this.contentType;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.String).toLowerCase()");
        int result2 = string3.hashCode();
        string = this.contentSubtype;
        bl = false;
        String string4 = string;
        if (string4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.toLowerCase();
        Intrinsics.checkNotNullExpressionValue(string5, "(this as java.lang.String).toLowerCase()");
        result2 += 31 * result2 + string5.hashCode();
        return result2 += 31 * ((Object)this.getParameters()).hashCode();
    }

    @NotNull
    public final String getContentType() {
        return this.contentType;
    }

    @NotNull
    public final String getContentSubtype() {
        return this.contentSubtype;
    }

    private ContentType(String contentType2, String contentSubtype, String existingContent, List<HeaderValueParam> parameters2) {
        super(existingContent, parameters2);
        this.contentType = contentType2;
        this.contentSubtype = contentSubtype;
    }

    /* synthetic */ ContentType(String string, String string2, String string3, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(string, string2, string3, list);
    }

    public ContentType(@NotNull String contentType2, @NotNull String contentSubtype, @NotNull List<HeaderValueParam> parameters2) {
        Intrinsics.checkNotNullParameter(contentType2, "contentType");
        Intrinsics.checkNotNullParameter(contentSubtype, "contentSubtype");
        Intrinsics.checkNotNullParameter(parameters2, "parameters");
        this(contentType2, contentSubtype, contentType2 + '/' + contentSubtype, parameters2);
    }

    public /* synthetic */ ContentType(String string, String string2, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(string, string2, list);
    }

    static {
        Companion = new Companion(null);
        Any = new ContentType("*", "*", null, 4, null);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b'\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0011\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u0011\u0010\u0017\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0006R\u0011\u0010\u0019\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0006R\u0011\u0010\u001b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0006R\u0011\u0010\u001d\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0006R\u0011\u0010\u001f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0006R\u0011\u0010!\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0006R\u0011\u0010#\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u0006R\u0011\u0010%\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0006R\u0011\u0010'\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0006R\u0011\u0010)\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u0006\u00a8\u0006+"}, d2={"Lio/ktor/http/ContentType$Application;", "", "()V", "Any", "Lio/ktor/http/ContentType;", "getAny", "()Lio/ktor/http/ContentType;", "Atom", "getAtom", "Cbor", "getCbor", "FontWoff", "getFontWoff", "FormUrlEncoded", "getFormUrlEncoded", "GZip", "getGZip", "HalJson", "getHalJson", "JavaScript", "getJavaScript", "Json", "getJson", "OctetStream", "getOctetStream", "Pdf", "getPdf", "ProblemJson", "getProblemJson", "ProblemXml", "getProblemXml", "ProtoBuf", "getProtoBuf", "Rss", "getRss", "Wasm", "getWasm", "Xml", "getXml", "Xml_Dtd", "getXml_Dtd", "Zip", "getZip", "ktor-http"})
    public static final class Application {
        @NotNull
        private static final ContentType Any;
        @NotNull
        private static final ContentType Atom;
        @NotNull
        private static final ContentType Cbor;
        @NotNull
        private static final ContentType Json;
        @NotNull
        private static final ContentType HalJson;
        @NotNull
        private static final ContentType JavaScript;
        @NotNull
        private static final ContentType OctetStream;
        @NotNull
        private static final ContentType FontWoff;
        @NotNull
        private static final ContentType Rss;
        @NotNull
        private static final ContentType Xml;
        @NotNull
        private static final ContentType Xml_Dtd;
        @NotNull
        private static final ContentType Zip;
        @NotNull
        private static final ContentType GZip;
        @NotNull
        private static final ContentType FormUrlEncoded;
        @NotNull
        private static final ContentType Pdf;
        @NotNull
        private static final ContentType ProtoBuf;
        @NotNull
        private static final ContentType Wasm;
        @NotNull
        private static final ContentType ProblemJson;
        @NotNull
        private static final ContentType ProblemXml;
        @NotNull
        public static final Application INSTANCE;

        @NotNull
        public final ContentType getAny() {
            return Any;
        }

        @NotNull
        public final ContentType getAtom() {
            return Atom;
        }

        @NotNull
        public final ContentType getCbor() {
            return Cbor;
        }

        @NotNull
        public final ContentType getJson() {
            return Json;
        }

        @NotNull
        public final ContentType getHalJson() {
            return HalJson;
        }

        @NotNull
        public final ContentType getJavaScript() {
            return JavaScript;
        }

        @NotNull
        public final ContentType getOctetStream() {
            return OctetStream;
        }

        @NotNull
        public final ContentType getFontWoff() {
            return FontWoff;
        }

        @NotNull
        public final ContentType getRss() {
            return Rss;
        }

        @NotNull
        public final ContentType getXml() {
            return Xml;
        }

        @NotNull
        public final ContentType getXml_Dtd() {
            return Xml_Dtd;
        }

        @NotNull
        public final ContentType getZip() {
            return Zip;
        }

        @NotNull
        public final ContentType getGZip() {
            return GZip;
        }

        @NotNull
        public final ContentType getFormUrlEncoded() {
            return FormUrlEncoded;
        }

        @NotNull
        public final ContentType getPdf() {
            return Pdf;
        }

        @NotNull
        public final ContentType getProtoBuf() {
            return ProtoBuf;
        }

        @NotNull
        public final ContentType getWasm() {
            return Wasm;
        }

        @NotNull
        public final ContentType getProblemJson() {
            return ProblemJson;
        }

        @NotNull
        public final ContentType getProblemXml() {
            return ProblemXml;
        }

        private Application() {
        }

        static {
            Application application;
            INSTANCE = application = new Application();
            Any = new ContentType("application", "*", null, 4, null);
            Atom = new ContentType("application", "atom+xml", null, 4, null);
            Cbor = new ContentType("application", "cbor", null, 4, null);
            Json = new ContentType("application", "json", null, 4, null);
            HalJson = new ContentType("application", "hal+json", null, 4, null);
            JavaScript = new ContentType("application", "javascript", null, 4, null);
            OctetStream = new ContentType("application", "octet-stream", null, 4, null);
            FontWoff = new ContentType("application", "font-woff", null, 4, null);
            Rss = new ContentType("application", "rss+xml", null, 4, null);
            Xml = new ContentType("application", "xml", null, 4, null);
            Xml_Dtd = new ContentType("application", "xml-dtd", null, 4, null);
            Zip = new ContentType("application", "zip", null, 4, null);
            GZip = new ContentType("application", "gzip", null, 4, null);
            FormUrlEncoded = new ContentType("application", "x-www-form-urlencoded", null, 4, null);
            Pdf = new ContentType("application", "pdf", null, 4, null);
            ProtoBuf = new ContentType("application", "protobuf", null, 4, null);
            Wasm = new ContentType("application", "wasm", null, 4, null);
            ProblemJson = new ContentType("application", "problem+json", null, 4, null);
            ProblemXml = new ContentType("application", "problem+xml", null, 4, null);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\r"}, d2={"Lio/ktor/http/ContentType$Audio;", "", "()V", "Any", "Lio/ktor/http/ContentType;", "getAny", "()Lio/ktor/http/ContentType;", "MP4", "getMP4", "MPEG", "getMPEG", "OGG", "getOGG", "ktor-http"})
    public static final class Audio {
        @NotNull
        private static final ContentType Any;
        @NotNull
        private static final ContentType MP4;
        @NotNull
        private static final ContentType MPEG;
        @NotNull
        private static final ContentType OGG;
        @NotNull
        public static final Audio INSTANCE;

        @NotNull
        public final ContentType getAny() {
            return Any;
        }

        @NotNull
        public final ContentType getMP4() {
            return MP4;
        }

        @NotNull
        public final ContentType getMPEG() {
            return MPEG;
        }

        @NotNull
        public final ContentType getOGG() {
            return OGG;
        }

        private Audio() {
        }

        static {
            Audio audio;
            INSTANCE = audio = new Audio();
            Any = new ContentType("audio", "*", null, 4, null);
            MP4 = new ContentType("audio", "mp4", null, 4, null);
            MPEG = new ContentType("audio", "mpeg", null, 4, null);
            OGG = new ContentType("audio", "ogg", null, 4, null);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lio/ktor/http/ContentType$Image;", "", "()V", "Any", "Lio/ktor/http/ContentType;", "getAny", "()Lio/ktor/http/ContentType;", "GIF", "getGIF", "JPEG", "getJPEG", "PNG", "getPNG", "SVG", "getSVG", "XIcon", "getXIcon", "ktor-http"})
    public static final class Image {
        @NotNull
        private static final ContentType Any;
        @NotNull
        private static final ContentType GIF;
        @NotNull
        private static final ContentType JPEG;
        @NotNull
        private static final ContentType PNG;
        @NotNull
        private static final ContentType SVG;
        @NotNull
        private static final ContentType XIcon;
        @NotNull
        public static final Image INSTANCE;

        @NotNull
        public final ContentType getAny() {
            return Any;
        }

        @NotNull
        public final ContentType getGIF() {
            return GIF;
        }

        @NotNull
        public final ContentType getJPEG() {
            return JPEG;
        }

        @NotNull
        public final ContentType getPNG() {
            return PNG;
        }

        @NotNull
        public final ContentType getSVG() {
            return SVG;
        }

        @NotNull
        public final ContentType getXIcon() {
            return XIcon;
        }

        private Image() {
        }

        static {
            Image image;
            INSTANCE = image = new Image();
            Any = new ContentType("image", "*", null, 4, null);
            GIF = new ContentType("image", "gif", null, 4, null);
            JPEG = new ContentType("image", "jpeg", null, 4, null);
            PNG = new ContentType("image", "png", null, 4, null);
            SVG = new ContentType("image", "svg+xml", null, 4, null);
            XIcon = new ContentType("image", "x-icon", null, 4, null);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lio/ktor/http/ContentType$Message;", "", "()V", "Any", "Lio/ktor/http/ContentType;", "getAny", "()Lio/ktor/http/ContentType;", "Http", "getHttp", "ktor-http"})
    public static final class Message {
        @NotNull
        private static final ContentType Any;
        @NotNull
        private static final ContentType Http;
        @NotNull
        public static final Message INSTANCE;

        @NotNull
        public final ContentType getAny() {
            return Any;
        }

        @NotNull
        public final ContentType getHttp() {
            return Http;
        }

        private Message() {
        }

        static {
            Message message2;
            INSTANCE = message2 = new Message();
            Any = new ContentType("message", "*", null, 4, null);
            Http = new ContentType("message", "http", null, 4, null);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lio/ktor/http/ContentType$MultiPart;", "", "()V", "Alternative", "Lio/ktor/http/ContentType;", "getAlternative", "()Lio/ktor/http/ContentType;", "Any", "getAny", "ByteRanges", "getByteRanges", "Encrypted", "getEncrypted", "FormData", "getFormData", "Mixed", "getMixed", "Related", "getRelated", "Signed", "getSigned", "ktor-http"})
    public static final class MultiPart {
        @NotNull
        private static final ContentType Any;
        @NotNull
        private static final ContentType Mixed;
        @NotNull
        private static final ContentType Alternative;
        @NotNull
        private static final ContentType Related;
        @NotNull
        private static final ContentType FormData;
        @NotNull
        private static final ContentType Signed;
        @NotNull
        private static final ContentType Encrypted;
        @NotNull
        private static final ContentType ByteRanges;
        @NotNull
        public static final MultiPart INSTANCE;

        @NotNull
        public final ContentType getAny() {
            return Any;
        }

        @NotNull
        public final ContentType getMixed() {
            return Mixed;
        }

        @NotNull
        public final ContentType getAlternative() {
            return Alternative;
        }

        @NotNull
        public final ContentType getRelated() {
            return Related;
        }

        @NotNull
        public final ContentType getFormData() {
            return FormData;
        }

        @NotNull
        public final ContentType getSigned() {
            return Signed;
        }

        @NotNull
        public final ContentType getEncrypted() {
            return Encrypted;
        }

        @NotNull
        public final ContentType getByteRanges() {
            return ByteRanges;
        }

        private MultiPart() {
        }

        static {
            MultiPart multiPart;
            INSTANCE = multiPart = new MultiPart();
            Any = new ContentType("multipart", "*", null, 4, null);
            Mixed = new ContentType("multipart", "mixed", null, 4, null);
            Alternative = new ContentType("multipart", "alternative", null, 4, null);
            Related = new ContentType("multipart", "related", null, 4, null);
            FormData = new ContentType("multipart", "form-data", null, 4, null);
            Signed = new ContentType("multipart", "signed", null, 4, null);
            Encrypted = new ContentType("multipart", "encrypted", null, 4, null);
            ByteRanges = new ContentType("multipart", "byteranges", null, 4, null);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0011\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lio/ktor/http/ContentType$Text;", "", "()V", "Any", "Lio/ktor/http/ContentType;", "getAny", "()Lio/ktor/http/ContentType;", "CSS", "getCSS", "CSV", "getCSV", "EventStream", "getEventStream", "Html", "getHtml", "JavaScript", "getJavaScript", "Plain", "getPlain", "VCard", "getVCard", "Xml", "getXml", "ktor-http"})
    public static final class Text {
        @NotNull
        private static final ContentType Any;
        @NotNull
        private static final ContentType Plain;
        @NotNull
        private static final ContentType CSS;
        @NotNull
        private static final ContentType CSV;
        @NotNull
        private static final ContentType Html;
        @NotNull
        private static final ContentType JavaScript;
        @NotNull
        private static final ContentType VCard;
        @NotNull
        private static final ContentType Xml;
        @NotNull
        private static final ContentType EventStream;
        @NotNull
        public static final Text INSTANCE;

        @NotNull
        public final ContentType getAny() {
            return Any;
        }

        @NotNull
        public final ContentType getPlain() {
            return Plain;
        }

        @NotNull
        public final ContentType getCSS() {
            return CSS;
        }

        @NotNull
        public final ContentType getCSV() {
            return CSV;
        }

        @NotNull
        public final ContentType getHtml() {
            return Html;
        }

        @NotNull
        public final ContentType getJavaScript() {
            return JavaScript;
        }

        @NotNull
        public final ContentType getVCard() {
            return VCard;
        }

        @NotNull
        public final ContentType getXml() {
            return Xml;
        }

        @NotNull
        public final ContentType getEventStream() {
            return EventStream;
        }

        private Text() {
        }

        static {
            Text text;
            INSTANCE = text = new Text();
            Any = new ContentType("text", "*", null, 4, null);
            Plain = new ContentType("text", "plain", null, 4, null);
            CSS = new ContentType("text", "css", null, 4, null);
            CSV = new ContentType("text", "csv", null, 4, null);
            Html = new ContentType("text", "html", null, 4, null);
            JavaScript = new ContentType("text", "javascript", null, 4, null);
            VCard = new ContentType("text", "vcard", null, 4, null);
            Xml = new ContentType("text", "xml", null, 4, null);
            EventStream = new ContentType("text", "event-stream", null, 4, null);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lio/ktor/http/ContentType$Video;", "", "()V", "Any", "Lio/ktor/http/ContentType;", "getAny", "()Lio/ktor/http/ContentType;", "MP4", "getMP4", "MPEG", "getMPEG", "OGG", "getOGG", "QuickTime", "getQuickTime", "ktor-http"})
    public static final class Video {
        @NotNull
        private static final ContentType Any;
        @NotNull
        private static final ContentType MPEG;
        @NotNull
        private static final ContentType MP4;
        @NotNull
        private static final ContentType OGG;
        @NotNull
        private static final ContentType QuickTime;
        @NotNull
        public static final Video INSTANCE;

        @NotNull
        public final ContentType getAny() {
            return Any;
        }

        @NotNull
        public final ContentType getMPEG() {
            return MPEG;
        }

        @NotNull
        public final ContentType getMP4() {
            return MP4;
        }

        @NotNull
        public final ContentType getOGG() {
            return OGG;
        }

        @NotNull
        public final ContentType getQuickTime() {
            return QuickTime;
        }

        private Video() {
        }

        static {
            Video video;
            INSTANCE = video = new Video();
            Any = new ContentType("video", "*", null, 4, null);
            MPEG = new ContentType("video", "mpeg", null, 4, null);
            MP4 = new ContentType("video", "mp4", null, 4, null);
            OGG = new ContentType("video", "ogg", null, 4, null);
            QuickTime = new ContentType("video", "quicktime", null, 4, null);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lio/ktor/http/ContentType$Companion;", "", "()V", "Any", "Lio/ktor/http/ContentType;", "getAny", "()Lio/ktor/http/ContentType;", "parse", "value", "", "ktor-http"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ContentType parse(@NotNull String value) {
            void parameters2;
            Intrinsics.checkNotNullParameter(value, "value");
            if (StringsKt.isBlank(value)) {
                return this.getAny();
            }
            HeaderValueWithParameters.Companion this_$iv = HeaderValueWithParameters.Companion;
            boolean $i$f$parse = false;
            HeaderValue headerValue$iv = CollectionsKt.single(HttpHeaderValueParserKt.parseHeaderValue(value));
            List<HeaderValueParam> list = headerValue$iv.getParams();
            String parts = headerValue$iv.getValue();
            boolean bl = false;
            int slash = StringsKt.indexOf$default((CharSequence)parts, '/', 0, false, 6, null);
            if (slash == -1) {
                String string = parts;
                boolean bl2 = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                if (Intrinsics.areEqual(((Object)StringsKt.trim((CharSequence)string2)).toString(), "*")) {
                    return Companion.getAny();
                }
                throw (Throwable)new BadContentTypeFormatException(value);
            }
            CharSequence charSequence = parts;
            int n = 0;
            int n2 = 0;
            String string = charSequence;
            if (string == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string.substring(n, slash);
            Intrinsics.checkNotNullExpressionValue(string3, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            charSequence = string3;
            n = 0;
            String string4 = charSequence;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String type2 = ((Object)StringsKt.trim((CharSequence)string4)).toString();
            charSequence = type2;
            n = 0;
            if (charSequence.length() == 0) {
                throw (Throwable)new BadContentTypeFormatException(value);
            }
            CharSequence charSequence2 = parts;
            n2 = slash + 1;
            boolean bl3 = false;
            String string5 = charSequence2;
            if (string5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.substring(n2);
            Intrinsics.checkNotNullExpressionValue(string6, "(this as java.lang.String).substring(startIndex)");
            charSequence2 = string6;
            n2 = 0;
            String string7 = charSequence2;
            if (string7 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String subtype = ((Object)StringsKt.trim((CharSequence)string7)).toString();
            charSequence2 = subtype;
            n2 = 0;
            if (charSequence2.length() == 0 || StringsKt.contains$default((CharSequence)subtype, '/', false, 2, null)) {
                throw (Throwable)new BadContentTypeFormatException(value);
            }
            return new ContentType(type2, subtype, (List<HeaderValueParam>)parameters2);
        }

        @NotNull
        public final ContentType getAny() {
            return Any;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

