/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.client.features.websocket;

import io.ktor.client.request.ClientUpgradeContent;
import io.ktor.http.Headers;
import io.ktor.http.HeadersBuilder;
import io.ktor.http.HttpHeaders;
import io.ktor.http.websocket.UtilsKt;
import io.ktor.util.Base64Kt;
import io.ktor.util.CryptoKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/ktor/client/features/websocket/WebSocketContent;", "Lio/ktor/client/request/ClientUpgradeContent;", "()V", "headers", "Lio/ktor/http/Headers;", "getHeaders", "()Lio/ktor/http/Headers;", "nonce", "", "toString", "verify", "", "ktor-client-core"})
public final class WebSocketContent
extends ClientUpgradeContent {
    private final String nonce;
    @NotNull
    private final Headers headers;

    @Override
    @NotNull
    public Headers getHeaders() {
        return this.headers;
    }

    @Override
    public void verify(@NotNull Headers headers) {
        Intrinsics.checkNotNullParameter(headers, "headers");
        String string = headers.get(HttpHeaders.INSTANCE.getSecWebSocketAccept());
        if (string == null) {
            String string2 = "Server should specify header " + HttpHeaders.INSTANCE.getSecWebSocketAccept();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        String serverAccept = string;
        String expectedAccept = UtilsKt.websocketServerAccept(this.nonce);
        boolean bl = Intrinsics.areEqual(expectedAccept, serverAccept);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string3 = "Failed to verify server accept header. Expected: " + expectedAccept + ", received: " + serverAccept;
            throw (Throwable)new IllegalStateException(string3.toString());
        }
    }

    @NotNull
    public String toString() {
        return "WebSocketContent";
    }

    /*
     * WARNING - void declaration
     */
    public WebSocketContent() {
        void $this$apply;
        void $this$buildString;
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder stringBuilder2 = stringBuilder;
        WebSocketContent webSocketContent = this;
        boolean bl5 = false;
        byte[] nonce = CryptoKt.generateNonce(16);
        $this$buildString.append(Base64Kt.encodeBase64(nonce));
        Unit unit = Unit.INSTANCE;
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        webSocketContent.nonce = string;
        HeadersBuilder headersBuilder = new HeadersBuilder(0, 1, null);
        boolean bl6 = false;
        bl3 = false;
        HeadersBuilder headersBuilder2 = headersBuilder;
        webSocketContent = this;
        boolean bl7 = false;
        $this$apply.append(HttpHeaders.INSTANCE.getUpgrade(), "websocket");
        $this$apply.append(HttpHeaders.INSTANCE.getConnection(), "upgrade");
        $this$apply.append(HttpHeaders.INSTANCE.getSecWebSocketKey(), this.nonce);
        $this$apply.append(HttpHeaders.INSTANCE.getSecWebSocketVersion(), "13");
        unit = Unit.INSTANCE;
        webSocketContent.headers = headersBuilder.build();
    }
}

