/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.PreconditionViolationException;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.StringUtils;

@API(status=API.Status.STABLE, since="1.0")
public final class TestTag
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    public static final Set<String> RESERVED_CHARACTERS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(",", "(", ")", "&", "|", "!")));

    public static boolean isValid(String name2) {
        if (name2 == null) {
            return false;
        }
        return !(name2 = name2.trim()).isEmpty() && StringUtils.doesNotContainWhitespace(name2) && StringUtils.doesNotContainIsoControlCharacter(name2) && TestTag.doesNotContainReservedCharacter(name2);
    }

    private static boolean doesNotContainReservedCharacter(String str) {
        return RESERVED_CHARACTERS.stream().noneMatch(str::contains);
    }

    public static TestTag create(String name2) throws PreconditionViolationException {
        return new TestTag(name2);
    }

    private TestTag(String name2) {
        Preconditions.condition(TestTag.isValid(name2), () -> String.format("Tag name [%s] must be syntactically valid", name2));
        this.name = name2.trim();
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TestTag) {
            TestTag that = (TestTag)obj;
            return Objects.equals(this.name, that.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }
}

