/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.util;

import java.util.ArrayList;
import java.util.List;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.StringUtils;

@API(status=API.Status.INTERNAL, since="1.0")
public class ToStringBuilder {
    private final Class<?> type;
    private final List<String> values = new ArrayList<String>();

    public ToStringBuilder(Object obj) {
        this.type = Preconditions.notNull(obj, "Object must not be null").getClass();
    }

    public ToStringBuilder(Class<?> type2) {
        this.type = Preconditions.notNull(type2, "Class must not be null");
    }

    public ToStringBuilder append(String name2, Object value) {
        Preconditions.notBlank(name2, "Name must not be null or blank");
        this.values.add(name2 + " = " + this.toString(value));
        return this;
    }

    private String toString(Object obj) {
        return obj instanceof CharSequence ? "'" + obj + "'" : StringUtils.nullSafeToString(obj);
    }

    public String toString() {
        return this.type.getSimpleName() + " [" + String.join((CharSequence)", ", this.values) + "]";
    }
}

