/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.PreconditionViolationException;
import org.junit.platform.commons.util.StringUtils;

@API(status=API.Status.INTERNAL, since="1.0")
public final class Preconditions {
    private Preconditions() {
    }

    public static <T> T notNull(T object, String message2) throws PreconditionViolationException {
        Preconditions.condition(object != null, message2);
        return object;
    }

    public static <T> T notNull(T object, Supplier<String> messageSupplier) throws PreconditionViolationException {
        Preconditions.condition(object != null, messageSupplier);
        return object;
    }

    public static <T> T[] notEmpty(T[] array, String message2) throws PreconditionViolationException {
        Preconditions.condition(array != null && array.length > 0, message2);
        return array;
    }

    public static <T> T[] notEmpty(T[] array, Supplier<String> messageSupplier) throws PreconditionViolationException {
        Preconditions.condition(array != null && array.length > 0, messageSupplier);
        return array;
    }

    public static <T extends Collection<?>> T notEmpty(T collection, String message2) throws PreconditionViolationException {
        Preconditions.condition(collection != null && !collection.isEmpty(), message2);
        return collection;
    }

    public static <T extends Collection<?>> T notEmpty(T collection, Supplier<String> messageSupplier) throws PreconditionViolationException {
        Preconditions.condition(collection != null && !collection.isEmpty(), messageSupplier);
        return collection;
    }

    public static <T> T[] containsNoNullElements(T[] array, String message2) throws PreconditionViolationException {
        if (array != null) {
            Arrays.stream(array).forEach(object -> Preconditions.notNull(object, message2));
        }
        return array;
    }

    public static <T> T[] containsNoNullElements(T[] array, Supplier<String> messageSupplier) throws PreconditionViolationException {
        if (array != null) {
            Arrays.stream(array).forEach(object -> Preconditions.notNull(object, messageSupplier));
        }
        return array;
    }

    public static <T extends Collection<?>> T containsNoNullElements(T collection, String message2) throws PreconditionViolationException {
        if (collection != null) {
            collection.forEach(object -> Preconditions.notNull(object, message2));
        }
        return (T)collection;
    }

    public static <T extends Collection<?>> T containsNoNullElements(T collection, Supplier<String> messageSupplier) throws PreconditionViolationException {
        if (collection != null) {
            collection.forEach(object -> Preconditions.notNull(object, messageSupplier));
        }
        return (T)collection;
    }

    public static String notBlank(String str, String message2) throws PreconditionViolationException {
        Preconditions.condition(StringUtils.isNotBlank(str), message2);
        return str;
    }

    public static String notBlank(String str, Supplier<String> messageSupplier) throws PreconditionViolationException {
        Preconditions.condition(StringUtils.isNotBlank(str), messageSupplier);
        return str;
    }

    public static void condition(boolean predicate, String message2) throws PreconditionViolationException {
        if (!predicate) {
            throw new PreconditionViolationException(message2);
        }
    }

    public static void condition(boolean predicate, Supplier<String> messageSupplier) throws PreconditionViolationException {
        if (!predicate) {
            throw new PreconditionViolationException(messageSupplier.get());
        }
    }
}

