/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.util;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.function.Function;

final class CloseablePath
implements Closeable {
    private static final String FILE_URI_SCHEME = "file";
    private static final String JAR_URI_SCHEME = "jar";
    private static final String JAR_FILE_EXTENSION = ".jar";
    private static final String JAR_URI_SEPARATOR = "!";
    private static final Closeable NULL_CLOSEABLE = () -> {};
    private final Path path;
    private final Closeable delegate;

    static CloseablePath create(URI uri) throws IOException, URISyntaxException {
        if (JAR_URI_SCHEME.equals(uri.getScheme())) {
            String[] parts = uri.toString().split(JAR_URI_SEPARATOR);
            String jarUri = parts[0];
            String jarEntry = parts[1];
            return CloseablePath.createForJarFileSystem(new URI(jarUri), fileSystem -> fileSystem.getPath(jarEntry, new String[0]));
        }
        if (uri.getScheme().equals(FILE_URI_SCHEME) && uri.getPath().endsWith(JAR_FILE_EXTENSION)) {
            return CloseablePath.createForJarFileSystem(new URI("jar:" + uri), fileSystem -> fileSystem.getRootDirectories().iterator().next());
        }
        return new CloseablePath(Paths.get(uri), NULL_CLOSEABLE);
    }

    private static CloseablePath createForJarFileSystem(URI jarUri, Function<FileSystem, Path> pathProvider) throws IOException {
        FileSystem fileSystem = FileSystems.newFileSystem(jarUri, Collections.emptyMap());
        Path path2 = pathProvider.apply(fileSystem);
        return new CloseablePath(path2, fileSystem);
    }

    private CloseablePath(Path path2, Closeable delegate) {
        this.path = path2;
        this.delegate = delegate;
    }

    public Path getPath() {
        return this.path;
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }
}

