/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.support;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.util.ReflectionUtils;

@API(status=API.Status.MAINTAINED, since="1.0")
public final class ReflectionSupport {
    private ReflectionSupport() {
    }

    public static Optional<Class<?>> loadClass(String name2) {
        return ReflectionUtils.loadClass(name2);
    }

    public static List<Class<?>> findAllClassesInClasspathRoot(URI root, Predicate<Class<?>> classFilter, Predicate<String> classNameFilter) {
        return ReflectionUtils.findAllClassesInClasspathRoot(root, classFilter, classNameFilter);
    }

    public static List<Class<?>> findAllClassesInPackage(String basePackageName, Predicate<Class<?>> classFilter, Predicate<String> classNameFilter) {
        return ReflectionUtils.findAllClassesInPackage(basePackageName, classFilter, classNameFilter);
    }

    public static List<Class<?>> findAllClassesInModule(String moduleName, Predicate<Class<?>> classFilter, Predicate<String> classNameFilter) {
        return ReflectionUtils.findAllClassesInModule(moduleName, classFilter, classNameFilter);
    }

    public static <T> T newInstance(Class<T> clazz, Object ... args2) {
        return ReflectionUtils.newInstance(clazz, args2);
    }

    public static Object invokeMethod(Method method, Object target, Object ... args2) {
        return ReflectionUtils.invokeMethod(method, target, args2);
    }

    public static Optional<Method> findMethod(Class<?> clazz, String methodName, String parameterTypeNames) {
        return ReflectionUtils.findMethod(clazz, methodName, parameterTypeNames);
    }

    public static Optional<Method> findMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        return ReflectionUtils.findMethod(clazz, methodName, parameterTypes);
    }

    public static List<Method> findMethods(Class<?> clazz, Predicate<Method> predicate, HierarchyTraversalMode traversalMode) {
        return ReflectionUtils.findMethods(clazz, predicate, ReflectionUtils.HierarchyTraversalMode.valueOf(traversalMode.name()));
    }

    public static List<Class<?>> findNestedClasses(Class<?> clazz, Predicate<Class<?>> predicate) {
        return ReflectionUtils.findNestedClasses(clazz, predicate);
    }
}

