/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.extension;

import java.util.List;
import javax.script.Bindings;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.junit.jupiter.api.condition.DisabledIf;
import org.junit.jupiter.api.condition.EnabledIf;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ScriptEvaluationException;
import org.junit.jupiter.engine.extension.ScriptExecutionCondition;
import org.junit.jupiter.engine.script.Script;
import org.junit.jupiter.engine.script.ScriptAccessor;
import org.junit.jupiter.engine.script.ScriptExecutionManager;

class ScriptExecutionEvaluator
implements ScriptExecutionCondition.Evaluator {
    private static final ConditionEvaluationResult ENABLED_ALL = ConditionEvaluationResult.enabled("All results are enabled");
    private final ScriptExecutionManager scriptExecutionManager = new ScriptExecutionManager();

    ScriptExecutionEvaluator() {
    }

    @Override
    public ConditionEvaluationResult evaluate(ExtensionContext context2, List<Script> scripts) {
        Bindings bindings = this.createBindings(context2);
        for (Script script : scripts) {
            ConditionEvaluationResult result2 = this.evaluate(this.scriptExecutionManager, script, bindings);
            if (!result2.isDisabled()) continue;
            return result2;
        }
        return ENABLED_ALL;
    }

    private Bindings createBindings(ExtensionContext context2) {
        ScriptAccessor.ConfigurationParameterAccessor configurationParameterAccessor = new ScriptAccessor.ConfigurationParameterAccessor(context2);
        SimpleBindings bindings = new SimpleBindings();
        bindings.put("junitTags", (Object)context2.getTags());
        bindings.put("junitUniqueId", (Object)context2.getUniqueId());
        bindings.put("junitDisplayName", (Object)context2.getDisplayName());
        bindings.put("junitConfigurationParameter", (Object)configurationParameterAccessor);
        return bindings;
    }

    ConditionEvaluationResult evaluate(ScriptExecutionManager manager, Script script, Bindings bindings) {
        if (script == null) {
            return null;
        }
        try {
            Object result2 = manager.evaluate(script, bindings);
            return this.computeConditionEvaluationResult(script, result2);
        }
        catch (ScriptException e) {
            throw new ScriptEvaluationException("Script evaluation failed for: " + script.getAnnotationAsString(), e);
        }
    }

    ConditionEvaluationResult computeConditionEvaluationResult(Script script, Object result2) {
        if (result2 == null) {
            throw new ScriptEvaluationException("Script returned `null`: " + script.getAnnotationAsString());
        }
        if (result2 instanceof ConditionEvaluationResult) {
            return (ConditionEvaluationResult)result2;
        }
        String resultAsString = String.valueOf(result2);
        String reason = script.toReasonString(resultAsString);
        boolean isTrue = result2 instanceof Boolean ? (Boolean)result2 : Boolean.parseBoolean(resultAsString);
        if (script.getAnnotationType() == EnabledIf.class) {
            return isTrue ? ConditionEvaluationResult.enabled(reason) : ConditionEvaluationResult.disabled(reason);
        }
        if (script.getAnnotationType() == DisabledIf.class) {
            return isTrue ? ConditionEvaluationResult.disabled(reason) : ConditionEvaluationResult.enabled(reason);
        }
        throw new ScriptEvaluationException("Unsupported annotation type: " + script.getAnnotationType());
    }
}

