/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.reflect.Method;
import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.engine.descriptor.TestMethodTestDescriptor;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.jupiter.engine.extension.ExtensionRegistry;
import org.junit.platform.engine.UniqueId;

@API(status=API.Status.INTERNAL, since="5.0")
public class TestTemplateInvocationTestDescriptor
extends TestMethodTestDescriptor {
    public static final String SEGMENT_TYPE = "test-template-invocation";
    private TestTemplateInvocationContext invocationContext;
    private final int index;

    TestTemplateInvocationTestDescriptor(UniqueId uniqueId, Class<?> testClass, Method templateMethod, TestTemplateInvocationContext invocationContext, int index) {
        super(uniqueId, invocationContext.getDisplayName(index), testClass, templateMethod);
        this.invocationContext = invocationContext;
        this.index = index;
    }

    @Override
    public String getLegacyReportingName() {
        return super.getLegacyReportingName() + "[" + this.index + "]";
    }

    @Override
    protected ExtensionRegistry populateNewExtensionRegistry(JupiterEngineExecutionContext context2) {
        ExtensionRegistry registry = super.populateNewExtensionRegistry(context2);
        this.invocationContext.getAdditionalExtensions().forEach(extension -> registry.registerExtension((Extension)extension, this.invocationContext));
        return registry;
    }

    @Override
    public void after(JupiterEngineExecutionContext context2) {
        this.invocationContext = null;
    }
}

