/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.engine.descriptor.ExtensionUtils;
import org.junit.jupiter.engine.descriptor.MethodBasedTestDescriptor;
import org.junit.jupiter.engine.descriptor.MethodExtensionContext;
import org.junit.jupiter.engine.execution.AfterEachMethodAdapter;
import org.junit.jupiter.engine.execution.BeforeEachMethodAdapter;
import org.junit.jupiter.engine.execution.ExecutableInvoker;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.jupiter.engine.execution.ThrowableCollector;
import org.junit.jupiter.engine.extension.ExtensionRegistry;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.hierarchical.Node;

@API(status=API.Status.INTERNAL, since="5.0")
public class TestMethodTestDescriptor
extends MethodBasedTestDescriptor {
    private static final ExecutableInvoker executableInvoker = new ExecutableInvoker();

    public TestMethodTestDescriptor(UniqueId uniqueId, Class<?> testClass, Method testMethod) {
        super(uniqueId, testClass, testMethod);
    }

    TestMethodTestDescriptor(UniqueId uniqueId, String displayName, Class<?> testClass, Method testMethod) {
        super(uniqueId, displayName, testClass, testMethod);
    }

    @Override
    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.TEST;
    }

    @Override
    public JupiterEngineExecutionContext prepare(JupiterEngineExecutionContext context2) throws Exception {
        ExtensionRegistry registry = this.populateNewExtensionRegistry(context2);
        Object testInstance = context2.getTestInstanceProvider().getTestInstance(Optional.of(registry));
        ThrowableCollector throwableCollector = new ThrowableCollector();
        MethodExtensionContext extensionContext = new MethodExtensionContext(context2.getExtensionContext(), context2.getExecutionListener(), this, context2.getConfigurationParameters(), testInstance, throwableCollector);
        return context2.extend().withExtensionRegistry(registry).withExtensionContext(extensionContext).withThrowableCollector(throwableCollector).build();
    }

    protected ExtensionRegistry populateNewExtensionRegistry(JupiterEngineExecutionContext context2) {
        return ExtensionUtils.populateNewExtensionRegistryFromExtendWithAnnotation(context2.getExtensionRegistry(), this.getTestMethod());
    }

    @Override
    public JupiterEngineExecutionContext execute(JupiterEngineExecutionContext context2, Node.DynamicTestExecutor dynamicTestExecutor) throws Exception {
        ThrowableCollector throwableCollector = context2.getThrowableCollector();
        this.invokeBeforeEachCallbacks(context2);
        if (throwableCollector.isEmpty()) {
            this.invokeBeforeEachMethods(context2);
            if (throwableCollector.isEmpty()) {
                this.invokeBeforeTestExecutionCallbacks(context2);
                if (throwableCollector.isEmpty()) {
                    this.invokeTestMethod(context2, dynamicTestExecutor);
                }
                this.invokeAfterTestExecutionCallbacks(context2);
            }
            this.invokeAfterEachMethods(context2);
        }
        this.invokeAfterEachCallbacks(context2);
        throwableCollector.assertEmpty();
        return context2;
    }

    private void invokeBeforeEachCallbacks(JupiterEngineExecutionContext context2) {
        this.invokeBeforeMethodsOrCallbacksUntilExceptionOccurs(context2, (extensionContext, callback) -> () -> callback.beforeEach((ExtensionContext)extensionContext), BeforeEachCallback.class);
    }

    private void invokeBeforeEachMethods(JupiterEngineExecutionContext context2) {
        ExtensionRegistry registry = context2.getExtensionRegistry();
        this.invokeBeforeMethodsOrCallbacksUntilExceptionOccurs(context2, (extensionContext, adapter) -> () -> adapter.invokeBeforeEachMethod((ExtensionContext)extensionContext, registry), BeforeEachMethodAdapter.class);
    }

    private void invokeBeforeTestExecutionCallbacks(JupiterEngineExecutionContext context2) {
        this.invokeBeforeMethodsOrCallbacksUntilExceptionOccurs(context2, (extensionContext, callback) -> () -> callback.beforeTestExecution((ExtensionContext)extensionContext), BeforeTestExecutionCallback.class);
    }

    private <T extends Extension> void invokeBeforeMethodsOrCallbacksUntilExceptionOccurs(JupiterEngineExecutionContext context2, BiFunction<ExtensionContext, T, Executable> generator, Class<T> type2) {
        ExtensionRegistry registry = context2.getExtensionRegistry();
        ExtensionContext extensionContext = context2.getExtensionContext();
        ThrowableCollector throwableCollector = context2.getThrowableCollector();
        for (Extension callback : registry.getExtensions(type2)) {
            Executable executable = generator.apply(extensionContext, (ExtensionContext)((Object)callback));
            throwableCollector.execute(executable);
            if (!throwableCollector.isNotEmpty()) continue;
            break;
        }
    }

    protected void invokeTestMethod(JupiterEngineExecutionContext context2, Node.DynamicTestExecutor dynamicTestExecutor) {
        ExtensionContext extensionContext = context2.getExtensionContext();
        ThrowableCollector throwableCollector = context2.getThrowableCollector();
        throwableCollector.execute(() -> {
            try {
                Method testMethod = this.getTestMethod();
                Object instance = extensionContext.getRequiredTestInstance();
                executableInvoker.invoke(testMethod, instance, extensionContext, context2.getExtensionRegistry());
            }
            catch (Throwable throwable) {
                this.invokeTestExecutionExceptionHandlers(context2.getExtensionRegistry(), extensionContext, throwable);
            }
        });
    }

    private void invokeTestExecutionExceptionHandlers(ExtensionRegistry registry, ExtensionContext context2, Throwable ex) {
        this.invokeTestExecutionExceptionHandlers(ex, registry.getReversedExtensions(TestExecutionExceptionHandler.class), context2);
    }

    private void invokeTestExecutionExceptionHandlers(Throwable ex, List<TestExecutionExceptionHandler> handlers, ExtensionContext context2) {
        if (handlers.isEmpty()) {
            ExceptionUtils.throwAsUncheckedException(ex);
        }
        try {
            handlers.remove(0).handleTestExecutionException(context2, ex);
        }
        catch (Throwable t) {
            this.invokeTestExecutionExceptionHandlers(t, handlers, context2);
        }
    }

    private void invokeAfterTestExecutionCallbacks(JupiterEngineExecutionContext context2) {
        this.invokeAllAfterMethodsOrCallbacks(context2, (extensionContext, callback) -> () -> callback.afterTestExecution((ExtensionContext)extensionContext), AfterTestExecutionCallback.class);
    }

    private void invokeAfterEachMethods(JupiterEngineExecutionContext context2) {
        ExtensionRegistry registry = context2.getExtensionRegistry();
        this.invokeAllAfterMethodsOrCallbacks(context2, (extensionContext, adapter) -> () -> adapter.invokeAfterEachMethod((ExtensionContext)extensionContext, registry), AfterEachMethodAdapter.class);
    }

    private void invokeAfterEachCallbacks(JupiterEngineExecutionContext context2) {
        this.invokeAllAfterMethodsOrCallbacks(context2, (extensionContext, callback) -> () -> callback.afterEach((ExtensionContext)extensionContext), AfterEachCallback.class);
    }

    private <T extends Extension> void invokeAllAfterMethodsOrCallbacks(JupiterEngineExecutionContext context2, BiFunction<ExtensionContext, T, Executable> generator, Class<T> type2) {
        ExtensionRegistry registry = context2.getExtensionRegistry();
        ExtensionContext extensionContext = context2.getExtensionContext();
        ThrowableCollector throwableCollector = context2.getThrowableCollector();
        registry.getReversedExtensions(type2).forEach(callback -> {
            Executable executable = (Executable)generator.apply(extensionContext, callback);
            throwableCollector.execute(executable);
        });
    }
}

