/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api.condition;

import java.util.Optional;
import org.junit.jupiter.api.condition.EnabledIfEnvironmentVariable;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.Preconditions;

class EnabledIfEnvironmentVariableCondition
implements ExecutionCondition {
    private static final ConditionEvaluationResult ENABLED_BY_DEFAULT = ConditionEvaluationResult.enabled("@EnabledIfEnvironmentVariable is not present");

    EnabledIfEnvironmentVariableCondition() {
    }

    @Override
    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context2) {
        Optional<EnabledIfEnvironmentVariable> optional = AnnotationUtils.findAnnotation(context2.getElement(), EnabledIfEnvironmentVariable.class);
        if (!optional.isPresent()) {
            return ENABLED_BY_DEFAULT;
        }
        EnabledIfEnvironmentVariable annotation = optional.get();
        String name2 = annotation.named().trim();
        String regex = annotation.matches();
        Preconditions.notBlank(name2, () -> "The 'named' attribute must not be blank in " + annotation);
        Preconditions.notBlank(regex, () -> "The 'matches' attribute must not be blank in " + annotation);
        String actual = this.getEnvironmentVariable(name2);
        if (actual == null) {
            return ConditionEvaluationResult.disabled(String.format("Environment variable [%s] does not exist", name2));
        }
        if (actual.matches(regex)) {
            return ConditionEvaluationResult.enabled(String.format("Environment variable [%s] with value [%s] matches regular expression [%s]", name2, actual, regex));
        }
        return ConditionEvaluationResult.disabled(String.format("Environment variable [%s] with value [%s] does not match regular expression [%s]", name2, actual, regex));
    }

    protected String getEnvironmentVariable(String name2) {
        return System.getenv(name2);
    }
}

