/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api.condition;

import java.util.Optional;
import org.junit.jupiter.api.condition.DisabledIfSystemProperty;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.Preconditions;

class DisabledIfSystemPropertyCondition
implements ExecutionCondition {
    private static final ConditionEvaluationResult ENABLED_BY_DEFAULT = ConditionEvaluationResult.enabled("@DisabledIfSystemProperty is not present");

    DisabledIfSystemPropertyCondition() {
    }

    @Override
    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context2) {
        Optional<DisabledIfSystemProperty> optional = AnnotationUtils.findAnnotation(context2.getElement(), DisabledIfSystemProperty.class);
        if (!optional.isPresent()) {
            return ENABLED_BY_DEFAULT;
        }
        DisabledIfSystemProperty annotation = optional.get();
        String name2 = annotation.named().trim();
        String regex = annotation.matches();
        Preconditions.notBlank(name2, () -> "The 'named' attribute must not be blank in " + annotation);
        Preconditions.notBlank(regex, () -> "The 'matches' attribute must not be blank in " + annotation);
        String actual = System.getProperty(name2);
        if (actual == null) {
            return ConditionEvaluationResult.enabled(String.format("System property [%s] does not exist", name2));
        }
        if (actual.matches(regex)) {
            return ConditionEvaluationResult.disabled(String.format("System property [%s] with value [%s] matches regular expression [%s]", name2, actual, regex));
        }
        return ConditionEvaluationResult.enabled(String.format("System property [%s] with value [%s] does not match regular expression [%s]", name2, actual, regex));
    }
}

