/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.junit.jupiter.api.AssertAll;
import org.junit.jupiter.api.AssertArrayEquals;
import org.junit.jupiter.api.AssertDoesNotThrow;
import org.junit.jupiter.api.AssertEquals;
import org.junit.jupiter.api.AssertFalse;
import org.junit.jupiter.api.AssertIterableEquals;
import org.junit.jupiter.api.AssertLinesMatch;
import org.junit.jupiter.api.AssertNotEquals;
import org.junit.jupiter.api.AssertNotNull;
import org.junit.jupiter.api.AssertNotSame;
import org.junit.jupiter.api.AssertNull;
import org.junit.jupiter.api.AssertSame;
import org.junit.jupiter.api.AssertThrows;
import org.junit.jupiter.api.AssertTimeout;
import org.junit.jupiter.api.AssertTrue;
import org.junit.jupiter.api.AssertionUtils;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.api.function.ThrowingSupplier;
import org.opentest4j.MultipleFailuresError;

@API(status=API.Status.STABLE, since="5.0")
public final class Assertions {
    private Assertions() {
    }

    public static <V> V fail() {
        AssertionUtils.fail();
        return null;
    }

    public static <V> V fail(String message2) {
        AssertionUtils.fail(message2);
        return null;
    }

    public static <V> V fail(String message2, Throwable cause) {
        AssertionUtils.fail(message2, cause);
        return null;
    }

    public static <V> V fail(Throwable cause) {
        AssertionUtils.fail(cause);
        return null;
    }

    public static <V> V fail(Supplier<String> messageSupplier) {
        AssertionUtils.fail(messageSupplier);
        return null;
    }

    public static void assertTrue(boolean condition) {
        AssertTrue.assertTrue(condition);
    }

    public static void assertTrue(boolean condition, Supplier<String> messageSupplier) {
        AssertTrue.assertTrue(condition, messageSupplier);
    }

    public static void assertTrue(BooleanSupplier booleanSupplier) {
        AssertTrue.assertTrue(booleanSupplier);
    }

    public static void assertTrue(BooleanSupplier booleanSupplier, String message2) {
        AssertTrue.assertTrue(booleanSupplier, message2);
    }

    public static void assertTrue(boolean condition, String message2) {
        AssertTrue.assertTrue(condition, message2);
    }

    public static void assertTrue(BooleanSupplier booleanSupplier, Supplier<String> messageSupplier) {
        AssertTrue.assertTrue(booleanSupplier, messageSupplier);
    }

    public static void assertFalse(boolean condition) {
        AssertFalse.assertFalse(condition);
    }

    public static void assertFalse(boolean condition, String message2) {
        AssertFalse.assertFalse(condition, message2);
    }

    public static void assertFalse(boolean condition, Supplier<String> messageSupplier) {
        AssertFalse.assertFalse(condition, messageSupplier);
    }

    public static void assertFalse(BooleanSupplier booleanSupplier) {
        AssertFalse.assertFalse(booleanSupplier);
    }

    public static void assertFalse(BooleanSupplier booleanSupplier, String message2) {
        AssertFalse.assertFalse(booleanSupplier, message2);
    }

    public static void assertFalse(BooleanSupplier booleanSupplier, Supplier<String> messageSupplier) {
        AssertFalse.assertFalse(booleanSupplier, messageSupplier);
    }

    public static void assertNull(Object actual) {
        AssertNull.assertNull(actual);
    }

    public static void assertNull(Object actual, String message2) {
        AssertNull.assertNull(actual, message2);
    }

    public static void assertNull(Object actual, Supplier<String> messageSupplier) {
        AssertNull.assertNull(actual, messageSupplier);
    }

    public static void assertNotNull(Object actual) {
        AssertNotNull.assertNotNull(actual);
    }

    public static void assertNotNull(Object actual, String message2) {
        AssertNotNull.assertNotNull(actual, message2);
    }

    public static void assertNotNull(Object actual, Supplier<String> messageSupplier) {
        AssertNotNull.assertNotNull(actual, messageSupplier);
    }

    public static void assertEquals(short expected, short actual) {
        AssertEquals.assertEquals(expected, actual);
    }

    public static void assertEquals(short expected, short actual, String message2) {
        AssertEquals.assertEquals(expected, actual, message2);
    }

    public static void assertEquals(short expected, short actual, Supplier<String> messageSupplier) {
        AssertEquals.assertEquals(expected, actual, messageSupplier);
    }

    public static void assertEquals(byte expected, byte actual) {
        AssertEquals.assertEquals(expected, actual);
    }

    public static void assertEquals(byte expected, byte actual, String message2) {
        AssertEquals.assertEquals(expected, actual, message2);
    }

    public static void assertEquals(byte expected, byte actual, Supplier<String> messageSupplier) {
        AssertEquals.assertEquals(expected, actual, messageSupplier);
    }

    public static void assertEquals(int expected, int actual) {
        AssertEquals.assertEquals(expected, actual);
    }

    public static void assertEquals(int expected, int actual, String message2) {
        AssertEquals.assertEquals(expected, actual, message2);
    }

    public static void assertEquals(int expected, int actual, Supplier<String> messageSupplier) {
        AssertEquals.assertEquals(expected, actual, messageSupplier);
    }

    public static void assertEquals(long expected, long actual) {
        AssertEquals.assertEquals(expected, actual);
    }

    public static void assertEquals(long expected, long actual, String message2) {
        AssertEquals.assertEquals(expected, actual, message2);
    }

    public static void assertEquals(long expected, long actual, Supplier<String> messageSupplier) {
        AssertEquals.assertEquals(expected, actual, messageSupplier);
    }

    public static void assertEquals(char expected, char actual) {
        AssertEquals.assertEquals(expected, actual);
    }

    public static void assertEquals(char expected, char actual, String message2) {
        AssertEquals.assertEquals(expected, actual, message2);
    }

    public static void assertEquals(char expected, char actual, Supplier<String> messageSupplier) {
        AssertEquals.assertEquals(expected, actual, messageSupplier);
    }

    public static void assertEquals(float expected, float actual) {
        AssertEquals.assertEquals(expected, actual);
    }

    public static void assertEquals(float expected, float actual, String message2) {
        AssertEquals.assertEquals(expected, actual, message2);
    }

    public static void assertEquals(float expected, float actual, Supplier<String> messageSupplier) {
        AssertEquals.assertEquals(expected, actual, messageSupplier);
    }

    public static void assertEquals(float expected, float actual, float delta) {
        AssertEquals.assertEquals(expected, actual, delta);
    }

    public static void assertEquals(float expected, float actual, float delta, String message2) {
        AssertEquals.assertEquals(expected, actual, delta, message2);
    }

    public static void assertEquals(float expected, float actual, float delta, Supplier<String> messageSupplier) {
        AssertEquals.assertEquals(expected, actual, delta, messageSupplier);
    }

    public static void assertEquals(double expected, double actual) {
        AssertEquals.assertEquals(expected, actual);
    }

    public static void assertEquals(double expected, double actual, String message2) {
        AssertEquals.assertEquals(expected, actual, message2);
    }

    public static void assertEquals(double expected, double actual, Supplier<String> messageSupplier) {
        AssertEquals.assertEquals(expected, actual, messageSupplier);
    }

    public static void assertEquals(double expected, double actual, double delta) {
        AssertEquals.assertEquals(expected, actual, delta);
    }

    public static void assertEquals(double expected, double actual, double delta, String message2) {
        AssertEquals.assertEquals(expected, actual, delta, message2);
    }

    public static void assertEquals(double expected, double actual, double delta, Supplier<String> messageSupplier) {
        AssertEquals.assertEquals(expected, actual, delta, messageSupplier);
    }

    public static void assertEquals(Object expected, Object actual) {
        AssertEquals.assertEquals(expected, actual);
    }

    public static void assertEquals(Object expected, Object actual, String message2) {
        AssertEquals.assertEquals(expected, actual, message2);
    }

    public static void assertEquals(Object expected, Object actual, Supplier<String> messageSupplier) {
        AssertEquals.assertEquals(expected, actual, messageSupplier);
    }

    public static void assertArrayEquals(boolean[] expected, boolean[] actual) {
        AssertArrayEquals.assertArrayEquals(expected, actual);
    }

    public static void assertArrayEquals(boolean[] expected, boolean[] actual, String message2) {
        AssertArrayEquals.assertArrayEquals(expected, actual, message2);
    }

    public static void assertArrayEquals(boolean[] expected, boolean[] actual, Supplier<String> messageSupplier) {
        AssertArrayEquals.assertArrayEquals(expected, actual, messageSupplier);
    }

    public static void assertArrayEquals(char[] expected, char[] actual) {
        AssertArrayEquals.assertArrayEquals(expected, actual);
    }

    public static void assertArrayEquals(char[] expected, char[] actual, String message2) {
        AssertArrayEquals.assertArrayEquals(expected, actual, message2);
    }

    public static void assertArrayEquals(char[] expected, char[] actual, Supplier<String> messageSupplier) {
        AssertArrayEquals.assertArrayEquals(expected, actual, messageSupplier);
    }

    public static void assertArrayEquals(byte[] expected, byte[] actual) {
        AssertArrayEquals.assertArrayEquals(expected, actual);
    }

    public static void assertArrayEquals(byte[] expected, byte[] actual, String message2) {
        AssertArrayEquals.assertArrayEquals(expected, actual, message2);
    }

    public static void assertArrayEquals(byte[] expected, byte[] actual, Supplier<String> messageSupplier) {
        AssertArrayEquals.assertArrayEquals(expected, actual, messageSupplier);
    }

    public static void assertArrayEquals(short[] expected, short[] actual) {
        AssertArrayEquals.assertArrayEquals(expected, actual);
    }

    public static void assertArrayEquals(short[] expected, short[] actual, String message2) {
        AssertArrayEquals.assertArrayEquals(expected, actual, message2);
    }

    public static void assertArrayEquals(short[] expected, short[] actual, Supplier<String> messageSupplier) {
        AssertArrayEquals.assertArrayEquals(expected, actual, messageSupplier);
    }

    public static void assertArrayEquals(int[] expected, int[] actual) {
        AssertArrayEquals.assertArrayEquals(expected, actual);
    }

    public static void assertArrayEquals(int[] expected, int[] actual, String message2) {
        AssertArrayEquals.assertArrayEquals(expected, actual, message2);
    }

    public static void assertArrayEquals(int[] expected, int[] actual, Supplier<String> messageSupplier) {
        AssertArrayEquals.assertArrayEquals(expected, actual, messageSupplier);
    }

    public static void assertArrayEquals(long[] expected, long[] actual) {
        AssertArrayEquals.assertArrayEquals(expected, actual);
    }

    public static void assertArrayEquals(long[] expected, long[] actual, String message2) {
        AssertArrayEquals.assertArrayEquals(expected, actual, message2);
    }

    public static void assertArrayEquals(long[] expected, long[] actual, Supplier<String> messageSupplier) {
        AssertArrayEquals.assertArrayEquals(expected, actual, messageSupplier);
    }

    public static void assertArrayEquals(float[] expected, float[] actual) {
        AssertArrayEquals.assertArrayEquals(expected, actual);
    }

    public static void assertArrayEquals(float[] expected, float[] actual, String message2) {
        AssertArrayEquals.assertArrayEquals(expected, actual, message2);
    }

    public static void assertArrayEquals(float[] expected, float[] actual, Supplier<String> messageSupplier) {
        AssertArrayEquals.assertArrayEquals(expected, actual, messageSupplier);
    }

    public static void assertArrayEquals(float[] expected, float[] actual, float delta) {
        AssertArrayEquals.assertArrayEquals(expected, actual, delta);
    }

    public static void assertArrayEquals(float[] expected, float[] actual, float delta, String message2) {
        AssertArrayEquals.assertArrayEquals(expected, actual, delta, message2);
    }

    public static void assertArrayEquals(float[] expected, float[] actual, float delta, Supplier<String> messageSupplier) {
        AssertArrayEquals.assertArrayEquals(expected, actual, delta, messageSupplier);
    }

    public static void assertArrayEquals(double[] expected, double[] actual) {
        AssertArrayEquals.assertArrayEquals(expected, actual);
    }

    public static void assertArrayEquals(double[] expected, double[] actual, String message2) {
        AssertArrayEquals.assertArrayEquals(expected, actual, message2);
    }

    public static void assertArrayEquals(double[] expected, double[] actual, Supplier<String> messageSupplier) {
        AssertArrayEquals.assertArrayEquals(expected, actual, messageSupplier);
    }

    public static void assertArrayEquals(double[] expected, double[] actual, double delta) {
        AssertArrayEquals.assertArrayEquals(expected, actual, delta);
    }

    public static void assertArrayEquals(double[] expected, double[] actual, double delta, String message2) {
        AssertArrayEquals.assertArrayEquals(expected, actual, delta, message2);
    }

    public static void assertArrayEquals(double[] expected, double[] actual, double delta, Supplier<String> messageSupplier) {
        AssertArrayEquals.assertArrayEquals(expected, actual, delta, messageSupplier);
    }

    public static void assertArrayEquals(Object[] expected, Object[] actual) {
        AssertArrayEquals.assertArrayEquals(expected, actual);
    }

    public static void assertArrayEquals(Object[] expected, Object[] actual, String message2) {
        AssertArrayEquals.assertArrayEquals(expected, actual, message2);
    }

    public static void assertArrayEquals(Object[] expected, Object[] actual, Supplier<String> messageSupplier) {
        AssertArrayEquals.assertArrayEquals(expected, actual, messageSupplier);
    }

    public static void assertIterableEquals(Iterable<?> expected, Iterable<?> actual) {
        AssertIterableEquals.assertIterableEquals(expected, actual);
    }

    public static void assertIterableEquals(Iterable<?> expected, Iterable<?> actual, String message2) {
        AssertIterableEquals.assertIterableEquals(expected, actual, message2);
    }

    public static void assertIterableEquals(Iterable<?> expected, Iterable<?> actual, Supplier<String> messageSupplier) {
        AssertIterableEquals.assertIterableEquals(expected, actual, messageSupplier);
    }

    public static void assertLinesMatch(List<String> expectedLines, List<String> actualLines) {
        AssertLinesMatch.assertLinesMatch(expectedLines, actualLines);
    }

    public static void assertNotEquals(Object unexpected, Object actual) {
        AssertNotEquals.assertNotEquals(unexpected, actual);
    }

    public static void assertNotEquals(Object unexpected, Object actual, String message2) {
        AssertNotEquals.assertNotEquals(unexpected, actual, message2);
    }

    public static void assertNotEquals(Object unexpected, Object actual, Supplier<String> messageSupplier) {
        AssertNotEquals.assertNotEquals(unexpected, actual, messageSupplier);
    }

    public static void assertSame(Object expected, Object actual) {
        AssertSame.assertSame(expected, actual);
    }

    public static void assertSame(Object expected, Object actual, String message2) {
        AssertSame.assertSame(expected, actual, message2);
    }

    public static void assertSame(Object expected, Object actual, Supplier<String> messageSupplier) {
        AssertSame.assertSame(expected, actual, messageSupplier);
    }

    public static void assertNotSame(Object unexpected, Object actual) {
        AssertNotSame.assertNotSame(unexpected, actual);
    }

    public static void assertNotSame(Object unexpected, Object actual, String message2) {
        AssertNotSame.assertNotSame(unexpected, actual, message2);
    }

    public static void assertNotSame(Object unexpected, Object actual, Supplier<String> messageSupplier) {
        AssertNotSame.assertNotSame(unexpected, actual, messageSupplier);
    }

    public static void assertAll(Executable ... executables) throws MultipleFailuresError {
        AssertAll.assertAll(executables);
    }

    public static void assertAll(String heading, Executable ... executables) throws MultipleFailuresError {
        AssertAll.assertAll(heading, executables);
    }

    public static void assertAll(Collection<Executable> executables) throws MultipleFailuresError {
        AssertAll.assertAll(executables);
    }

    public static void assertAll(String heading, Collection<Executable> executables) throws MultipleFailuresError {
        AssertAll.assertAll(heading, executables);
    }

    public static void assertAll(Stream<Executable> executables) throws MultipleFailuresError {
        AssertAll.assertAll(executables);
    }

    public static void assertAll(String heading, Stream<Executable> executables) throws MultipleFailuresError {
        AssertAll.assertAll(heading, executables);
    }

    public static <T extends Throwable> T assertThrows(Class<T> expectedType, Executable executable) {
        return AssertThrows.assertThrows(expectedType, executable);
    }

    public static <T extends Throwable> T assertThrows(Class<T> expectedType, Executable executable, String message2) {
        return AssertThrows.assertThrows(expectedType, executable, message2);
    }

    public static <T extends Throwable> T assertThrows(Class<T> expectedType, Executable executable, Supplier<String> messageSupplier) {
        return AssertThrows.assertThrows(expectedType, executable, messageSupplier);
    }

    public static void assertDoesNotThrow(Executable executable) {
        AssertDoesNotThrow.assertDoesNotThrow(executable);
    }

    public static void assertDoesNotThrow(Executable executable, String message2) {
        AssertDoesNotThrow.assertDoesNotThrow(executable, message2);
    }

    public static void assertDoesNotThrow(Executable executable, Supplier<String> messageSupplier) {
        AssertDoesNotThrow.assertDoesNotThrow(executable, messageSupplier);
    }

    public static <T> T assertDoesNotThrow(ThrowingSupplier<T> supplier) {
        return AssertDoesNotThrow.assertDoesNotThrow(supplier);
    }

    public static <T> T assertDoesNotThrow(ThrowingSupplier<T> supplier, String message2) {
        return AssertDoesNotThrow.assertDoesNotThrow(supplier, message2);
    }

    public static <T> T assertDoesNotThrow(ThrowingSupplier<T> supplier, Supplier<String> messageSupplier) {
        return AssertDoesNotThrow.assertDoesNotThrow(supplier, messageSupplier);
    }

    public static void assertTimeout(Duration timeout2, Executable executable) {
        AssertTimeout.assertTimeout(timeout2, executable);
    }

    public static void assertTimeout(Duration timeout2, Executable executable, String message2) {
        AssertTimeout.assertTimeout(timeout2, executable, message2);
    }

    public static void assertTimeout(Duration timeout2, Executable executable, Supplier<String> messageSupplier) {
        AssertTimeout.assertTimeout(timeout2, executable, messageSupplier);
    }

    public static <T> T assertTimeout(Duration timeout2, ThrowingSupplier<T> supplier) {
        return AssertTimeout.assertTimeout(timeout2, supplier);
    }

    public static <T> T assertTimeout(Duration timeout2, ThrowingSupplier<T> supplier, String message2) {
        return AssertTimeout.assertTimeout(timeout2, supplier, message2);
    }

    public static <T> T assertTimeout(Duration timeout2, ThrowingSupplier<T> supplier, Supplier<String> messageSupplier) {
        return AssertTimeout.assertTimeout(timeout2, supplier, messageSupplier);
    }

    public static void assertTimeoutPreemptively(Duration timeout2, Executable executable) {
        AssertTimeout.assertTimeoutPreemptively(timeout2, executable);
    }

    public static void assertTimeoutPreemptively(Duration timeout2, Executable executable, String message2) {
        AssertTimeout.assertTimeoutPreemptively(timeout2, executable, message2);
    }

    public static void assertTimeoutPreemptively(Duration timeout2, Executable executable, Supplier<String> messageSupplier) {
        AssertTimeout.assertTimeoutPreemptively(timeout2, executable, messageSupplier);
    }

    public static <T> T assertTimeoutPreemptively(Duration timeout2, ThrowingSupplier<T> supplier) {
        return AssertTimeout.assertTimeoutPreemptively(timeout2, supplier);
    }

    public static <T> T assertTimeoutPreemptively(Duration timeout2, ThrowingSupplier<T> supplier, String message2) {
        return AssertTimeout.assertTimeoutPreemptively(timeout2, supplier, message2);
    }

    public static <T> T assertTimeoutPreemptively(Duration timeout2, ThrowingSupplier<T> supplier, Supplier<String> messageSupplier) {
        return AssertTimeout.assertTimeoutPreemptively(timeout2, supplier, messageSupplier);
    }
}

