/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.util.Deque;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.junit.platform.commons.util.StringUtils;
import org.opentest4j.AssertionFailedError;

class AssertionUtils {
    private AssertionUtils() {
    }

    static void fail() {
        throw new AssertionFailedError();
    }

    static void fail(String message2) {
        throw new AssertionFailedError(message2);
    }

    static void fail(String message2, Throwable cause) {
        throw new AssertionFailedError(message2, cause);
    }

    static void fail(Throwable cause) {
        throw new AssertionFailedError(null, cause);
    }

    static void fail(Supplier<String> messageSupplier) {
        throw new AssertionFailedError(AssertionUtils.nullSafeGet(messageSupplier));
    }

    static void fail(String message2, Object expected, Object actual) {
        throw new AssertionFailedError(message2, expected, actual);
    }

    static String nullSafeGet(Supplier<String> messageSupplier) {
        return messageSupplier != null ? messageSupplier.get() : null;
    }

    static String nullSafeGet(Object messageOrSupplier) {
        Object message2;
        if (messageOrSupplier instanceof String) {
            return (String)messageOrSupplier;
        }
        if (messageOrSupplier instanceof Supplier && (message2 = ((Supplier)messageOrSupplier).get()) != null) {
            return message2.toString();
        }
        return null;
    }

    static String buildPrefix(String message2) {
        return StringUtils.isNotBlank(message2) ? message2 + " ==> " : "";
    }

    static String getCanonicalName(Class<?> clazz) {
        try {
            String canonicalName = clazz.getCanonicalName();
            return canonicalName != null ? canonicalName : clazz.getName();
        }
        catch (Throwable t) {
            return clazz.getName();
        }
    }

    static String format(Object expected, Object actual, String message2) {
        return AssertionUtils.buildPrefix(message2) + AssertionUtils.formatValues(expected, actual);
    }

    static String formatValues(Object expected, Object actual) {
        String actualString;
        String expectedString = AssertionUtils.toString(expected);
        if (expectedString.equals(actualString = AssertionUtils.toString(actual))) {
            return String.format("expected: %s but was: %s", AssertionUtils.formatClassAndValue(expected, expectedString), AssertionUtils.formatClassAndValue(actual, actualString));
        }
        return String.format("expected: <%s> but was: <%s>", expectedString, actualString);
    }

    private static String formatClassAndValue(Object value, String valueString) {
        String classAndHash = AssertionUtils.getClassName(value) + AssertionUtils.toHash(value);
        return value instanceof Class ? "<" + classAndHash + ">" : classAndHash + "<" + valueString + ">";
    }

    private static String toString(Object obj) {
        if (obj instanceof Class) {
            return AssertionUtils.getCanonicalName((Class)obj);
        }
        return StringUtils.nullSafeToString(obj);
    }

    private static String toHash(Object obj) {
        return obj == null ? "" : "@" + Integer.toHexString(System.identityHashCode(obj));
    }

    private static String getClassName(Object obj) {
        return obj == null ? "null" : (obj instanceof Class ? AssertionUtils.getCanonicalName((Class)obj) : obj.getClass().getName());
    }

    static String formatIndexes(Deque<Integer> indexes) {
        if (indexes == null || indexes.isEmpty()) {
            return "";
        }
        String indexesString = indexes.stream().map(Object::toString).collect(Collectors.joining("][", "[", "]"));
        return " at index " + indexesString;
    }

    static boolean floatsAreEqual(float value1, float value2, float delta) {
        AssertionUtils.assertValidDelta(delta);
        return AssertionUtils.floatsAreEqual(value1, value2) || Math.abs(value1 - value2) <= delta;
    }

    static void assertValidDelta(float delta) {
        if (Float.isNaN(delta) || (double)delta <= 0.0) {
            AssertionUtils.failIllegalDelta(String.valueOf(delta));
        }
    }

    static void assertValidDelta(double delta) {
        if (Double.isNaN(delta) || delta <= 0.0) {
            AssertionUtils.failIllegalDelta(String.valueOf(delta));
        }
    }

    static boolean floatsAreEqual(float value1, float value2) {
        return Float.floatToIntBits(value1) == Float.floatToIntBits(value2);
    }

    static boolean doublesAreEqual(double value1, double value2, double delta) {
        AssertionUtils.assertValidDelta(delta);
        return AssertionUtils.doublesAreEqual(value1, value2) || Math.abs(value1 - value2) <= delta;
    }

    static boolean doublesAreEqual(double value1, double value2) {
        return Double.doubleToLongBits(value1) == Double.doubleToLongBits(value2);
    }

    static boolean objectsAreEqual(Object obj1, Object obj2) {
        if (obj1 == null) {
            return obj2 == null;
        }
        return obj1.equals(obj2);
    }

    private static void failIllegalDelta(String delta) {
        AssertionUtils.fail("positive delta expected but was: <" + delta + ">");
    }
}

