/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.junit.jupiter.api.AssertionUtils;

class AssertTrue {
    private static final String EXPECTED_TRUE = "expected: <true> but was: <false>";

    private AssertTrue() {
    }

    static void assertTrue(boolean condition) {
        AssertTrue.assertTrue(condition, (String)null);
    }

    static void assertTrue(boolean condition, String message2) {
        if (!condition) {
            AssertionUtils.fail(AssertionUtils.buildPrefix(message2) + EXPECTED_TRUE);
        }
    }

    static void assertTrue(boolean condition, Supplier<String> messageSupplier) {
        if (!condition) {
            AssertionUtils.fail(AssertionUtils.buildPrefix(AssertionUtils.nullSafeGet(messageSupplier)) + EXPECTED_TRUE);
        }
    }

    static void assertTrue(BooleanSupplier booleanSupplier) {
        AssertTrue.assertTrue(booleanSupplier.getAsBoolean(), (String)null);
    }

    static void assertTrue(BooleanSupplier booleanSupplier, String message2) {
        AssertTrue.assertTrue(booleanSupplier.getAsBoolean(), message2);
    }

    static void assertTrue(BooleanSupplier booleanSupplier, Supplier<String> messageSupplier) {
        AssertTrue.assertTrue(booleanSupplier.getAsBoolean(), messageSupplier);
    }
}

