/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.time.Duration;
import java.util.function.Supplier;
import org.junit.jupiter.api.AssertionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.api.function.ThrowingSupplier;
import org.junit.platform.commons.util.ExceptionUtils;

class AssertTimeout {
    private AssertTimeout() {
    }

    static void assertTimeout(Duration timeout2, Executable executable) {
        AssertTimeout.assertTimeout(timeout2, executable, (String)null);
    }

    static void assertTimeout(Duration timeout2, Executable executable, String message2) {
        AssertTimeout.assertTimeout(timeout2, () -> {
            executable.execute();
            return null;
        }, message2);
    }

    static void assertTimeout(Duration timeout2, Executable executable, Supplier<String> messageSupplier) {
        AssertTimeout.assertTimeout(timeout2, () -> {
            executable.execute();
            return null;
        }, messageSupplier);
    }

    static <T> T assertTimeout(Duration timeout2, ThrowingSupplier<T> supplier) {
        return AssertTimeout.assertTimeout(timeout2, supplier, null);
    }

    static <T> T assertTimeout(Duration timeout2, ThrowingSupplier<T> supplier, String message2) {
        return AssertTimeout.assertTimeout(timeout2, supplier, (Object)message2);
    }

    static <T> T assertTimeout(Duration timeout2, ThrowingSupplier<T> supplier, Supplier<String> messageSupplier) {
        return AssertTimeout.assertTimeout(timeout2, supplier, messageSupplier);
    }

    private static <T> T assertTimeout(Duration timeout2, ThrowingSupplier<T> supplier, Object messageOrSupplier) {
        long timeoutInMillis = timeout2.toMillis();
        long start2 = System.currentTimeMillis();
        T result2 = null;
        try {
            result2 = supplier.get();
        }
        catch (Throwable ex) {
            ExceptionUtils.throwAsUncheckedException(ex);
        }
        long timeElapsed = System.currentTimeMillis() - start2;
        if (timeElapsed > timeoutInMillis) {
            Assertions.fail(AssertionUtils.buildPrefix(AssertionUtils.nullSafeGet(messageOrSupplier)) + "execution exceeded timeout of " + timeoutInMillis + " ms by " + (timeElapsed - timeoutInMillis) + " ms");
        }
        return result2;
    }

    static void assertTimeoutPreemptively(Duration timeout2, Executable executable) {
        AssertTimeout.assertTimeoutPreemptively(timeout2, executable, (String)null);
    }

    static void assertTimeoutPreemptively(Duration timeout2, Executable executable, String message2) {
        AssertTimeout.assertTimeoutPreemptively(timeout2, () -> {
            executable.execute();
            return null;
        }, message2);
    }

    static void assertTimeoutPreemptively(Duration timeout2, Executable executable, Supplier<String> messageSupplier) {
        AssertTimeout.assertTimeoutPreemptively(timeout2, () -> {
            executable.execute();
            return null;
        }, messageSupplier);
    }

    static <T> T assertTimeoutPreemptively(Duration timeout2, ThrowingSupplier<T> supplier) {
        return AssertTimeout.assertTimeoutPreemptively(timeout2, supplier, null);
    }

    static <T> T assertTimeoutPreemptively(Duration timeout2, ThrowingSupplier<T> supplier, String message2) {
        return AssertTimeout.assertTimeoutPreemptively(timeout2, supplier, (Object)message2);
    }

    static <T> T assertTimeoutPreemptively(Duration timeout2, ThrowingSupplier<T> supplier, Supplier<String> messageSupplier) {
        return AssertTimeout.assertTimeoutPreemptively(timeout2, supplier, messageSupplier);
    }

    /*
     * Exception decompiling
     */
    private static <T> T assertTimeoutPreemptively(Duration timeout, ThrowingSupplier<T> supplier, Object messageOrSupplier) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static /* synthetic */ Object lambda$assertTimeoutPreemptively$4(ThrowingSupplier supplier) throws Exception {
        try {
            return supplier.get();
        }
        catch (Throwable throwable) {
            throw ExceptionUtils.throwAsUncheckedException(throwable);
        }
    }
}

