/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.util.function.Supplier;
import org.junit.jupiter.api.AssertionUtils;

class AssertNull {
    private AssertNull() {
    }

    static void assertNull(Object actual) {
        AssertNull.assertNull(actual, (String)null);
    }

    static void assertNull(Object actual, String message2) {
        if (actual != null) {
            AssertNull.failNotNull(actual, message2);
        }
    }

    static void assertNull(Object actual, Supplier<String> messageSupplier) {
        if (actual != null) {
            AssertNull.failNotNull(actual, AssertionUtils.nullSafeGet(messageSupplier));
        }
    }

    private static void failNotNull(Object actual, String message2) {
        AssertionUtils.fail(AssertionUtils.buildPrefix(message2) + "expected: <null> but was: <" + actual + ">", null, actual);
    }
}

