/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Vector;
import org.bouncycastle.util.StringList;
import org.bouncycastle.util.encoders.UTF8;

public final class Strings {
    private static String LINE_SEPARATOR;

    public static String fromUTF8ByteArray(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        int n = UTF8.transcodeToUTF16(byArray, cArray);
        if (n < 0) {
            throw new IllegalArgumentException("Invalid UTF-8 input");
        }
        return new String(cArray, 0, n);
    }

    public static byte[] toUTF8ByteArray(String string) {
        return Strings.toUTF8ByteArray(string.toCharArray());
    }

    public static byte[] toUTF8ByteArray(char[] cArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            Strings.toUTF8ByteArray(cArray, byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("cannot encode string to byte array!");
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static void toUTF8ByteArray(char[] cArray, OutputStream outputStream2) throws IOException {
        char[] cArray2 = cArray;
        for (int j = 0; j < cArray2.length; ++j) {
            char c = cArray2[j];
            if (c < '\u0080') {
                outputStream2.write(c);
                continue;
            }
            if (c < '\u0800') {
                outputStream2.write(0xC0 | c >> 6);
                outputStream2.write(0x80 | c & 0x3F);
                continue;
            }
            if (c >= '\ud800' && c <= '\udfff') {
                if (j + 1 >= cArray2.length) {
                    throw new IllegalStateException("invalid UTF-16 codepoint");
                }
                char c2 = c;
                char c3 = c = cArray2[++j];
                if (c2 > '\udbff') {
                    throw new IllegalStateException("invalid UTF-16 codepoint");
                }
                int n = ((c2 & 0x3FF) << 10 | c3 & 0x3FF) + 65536;
                outputStream2.write(0xF0 | n >> 18);
                outputStream2.write(0x80 | n >> 12 & 0x3F);
                outputStream2.write(0x80 | n >> 6 & 0x3F);
                outputStream2.write(0x80 | n & 0x3F);
                continue;
            }
            outputStream2.write(0xE0 | c >> 12);
            outputStream2.write(0x80 | c >> 6 & 0x3F);
            outputStream2.write(0x80 | c & 0x3F);
        }
    }

    public static String toUpperCase(String string) {
        boolean bl = false;
        char[] cArray = string.toCharArray();
        for (int j = 0; j != cArray.length; ++j) {
            char c = cArray[j];
            if ('a' > c || 'z' < c) continue;
            bl = true;
            cArray[j] = (char)(c - 97 + 65);
        }
        if (bl) {
            return new String(cArray);
        }
        return string;
    }

    public static String toLowerCase(String string) {
        boolean bl = false;
        char[] cArray = string.toCharArray();
        for (int j = 0; j != cArray.length; ++j) {
            char c = cArray[j];
            if ('A' > c || 'Z' < c) continue;
            bl = true;
            cArray[j] = (char)(c - 65 + 97);
        }
        if (bl) {
            return new String(cArray);
        }
        return string;
    }

    public static byte[] toByteArray(char[] cArray) {
        byte[] byArray = new byte[cArray.length];
        for (int j = 0; j != byArray.length; ++j) {
            byArray[j] = (byte)cArray[j];
        }
        return byArray;
    }

    public static byte[] toByteArray(String string) {
        byte[] byArray = new byte[string.length()];
        for (int j = 0; j != byArray.length; ++j) {
            char c = string.charAt(j);
            byArray[j] = (byte)c;
        }
        return byArray;
    }

    public static int toByteArray(String string, byte[] byArray, int n) {
        int n2 = string.length();
        for (int j = 0; j < n2; ++j) {
            char c = string.charAt(j);
            byArray[n + j] = (byte)c;
        }
        return n2;
    }

    public static String fromByteArray(byte[] byArray) {
        return new String(Strings.asCharArray(byArray));
    }

    public static char[] asCharArray(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        for (int j = 0; j != cArray.length; ++j) {
            cArray[j] = (char)(byArray[j] & 0xFF);
        }
        return cArray;
    }

    public static String[] split(String string, char c) {
        Vector<String> vector = new Vector<String>();
        boolean bl = true;
        while (bl) {
            int n = string.indexOf(c);
            if (n > 0) {
                String string2 = string.substring(0, n);
                vector.addElement(string2);
                string = string.substring(n + 1);
                continue;
            }
            bl = false;
            vector.addElement(string);
        }
        String[] stringArray = new String[vector.size()];
        for (int j = 0; j != stringArray.length; ++j) {
            stringArray[j] = (String)vector.elementAt(j);
        }
        return stringArray;
    }

    public static StringList newList() {
        return new StringListImpl();
    }

    public static String lineSeparator() {
        return LINE_SEPARATOR;
    }

    static {
        try {
            LINE_SEPARATOR = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("line.separator");
                }
            });
        }
        catch (Exception exception) {
            try {
                LINE_SEPARATOR = String.format("%n", new Object[0]);
            }
            catch (Exception exception2) {
                LINE_SEPARATOR = "\n";
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringListImpl
    extends ArrayList<String>
    implements StringList {
        private StringListImpl() {
        }

        @Override
        public boolean add(String string) {
            return super.add(string);
        }

        @Override
        public String set(int n, String string) {
            return super.set(n, string);
        }

        @Override
        public void add(int n, String string) {
            super.add(n, string);
        }

        @Override
        public String[] toStringArray() {
            String[] stringArray = new String[this.size()];
            for (int j = 0; j != stringArray.length; ++j) {
                stringArray[j] = (String)this.get(j);
            }
            return stringArray;
        }

        @Override
        public String[] toStringArray(int n, int n2) {
            String[] stringArray = new String[n2 - n];
            for (int j = n; j != this.size() && j != n2; ++j) {
                stringArray[j - n] = (String)this.get(j);
            }
            return stringArray;
        }
    }
}

