/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.bouncycastle.crypto.tls.CertChainType;
import org.bouncycastle.crypto.tls.TlsContext;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.crypto.tls.TlsUtils;
import org.bouncycastle.crypto.tls.URLAndHash;

public class CertificateURL {
    protected short type;
    protected Vector urlAndHashList;

    public CertificateURL(short s, Vector vector) {
        if (!CertChainType.isValid(s)) {
            throw new IllegalArgumentException("'type' is not a valid CertChainType value");
        }
        if (vector == null || vector.isEmpty()) {
            throw new IllegalArgumentException("'urlAndHashList' must have length > 0");
        }
        this.type = s;
        this.urlAndHashList = vector;
    }

    public short getType() {
        return this.type;
    }

    public Vector getURLAndHashList() {
        return this.urlAndHashList;
    }

    public void encode(OutputStream outputStream2) throws IOException {
        TlsUtils.writeUint8(this.type, outputStream2);
        ListBuffer16 listBuffer16 = new ListBuffer16();
        for (int j = 0; j < this.urlAndHashList.size(); ++j) {
            URLAndHash uRLAndHash = (URLAndHash)this.urlAndHashList.elementAt(j);
            uRLAndHash.encode(listBuffer16);
        }
        listBuffer16.encodeTo(outputStream2);
    }

    public static CertificateURL parse(TlsContext tlsContext, InputStream inputStream2) throws IOException {
        short s = TlsUtils.readUint8(inputStream2);
        if (!CertChainType.isValid(s)) {
            throw new TlsFatalAlert(50);
        }
        int n = TlsUtils.readUint16(inputStream2);
        if (n < 1) {
            throw new TlsFatalAlert(50);
        }
        byte[] byArray = TlsUtils.readFully(n, inputStream2);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Vector<URLAndHash> vector = new Vector<URLAndHash>();
        while (byteArrayInputStream.available() > 0) {
            URLAndHash uRLAndHash = URLAndHash.parse(tlsContext, byteArrayInputStream);
            vector.addElement(uRLAndHash);
        }
        return new CertificateURL(s, vector);
    }

    class ListBuffer16
    extends ByteArrayOutputStream {
        ListBuffer16() throws IOException {
            TlsUtils.writeUint16(0, this);
        }

        void encodeTo(OutputStream outputStream2) throws IOException {
            int n = this.count - 2;
            TlsUtils.checkUint16(n);
            TlsUtils.writeUint16(n, this.buf, 0);
            outputStream2.write(this.buf, 0, this.count);
            this.buf = null;
        }
    }
}

