/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes.gcm;

import org.bouncycastle.crypto.modes.gcm.GCMMultiplier;
import org.bouncycastle.crypto.modes.gcm.GCMUtil;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

public class Tables64kGCMMultiplier
implements GCMMultiplier {
    private byte[] H;
    private long[][][] T;

    public void init(byte[] byArray) {
        if (this.T == null) {
            this.T = new long[16][256][2];
        } else if (Arrays.areEqual(this.H, byArray)) {
            return;
        }
        this.H = Arrays.clone(byArray);
        for (int j = 0; j < 16; ++j) {
            long[][] lArray = this.T[j];
            if (j == 0) {
                GCMUtil.asLongs(this.H, lArray[1]);
                GCMUtil.multiplyP7(lArray[1], lArray[1]);
            } else {
                GCMUtil.multiplyP8(this.T[j - 1][1], lArray[1]);
            }
            for (int k = 2; k < 256; k += 2) {
                GCMUtil.divideP(lArray[k >> 1], lArray[k]);
                GCMUtil.xor(lArray[k], lArray[1], lArray[k + 1]);
            }
        }
    }

    public void multiplyH(byte[] byArray) {
        long[] lArray = this.T[15][byArray[15] & 0xFF];
        long l = lArray[0];
        long l2 = lArray[1];
        for (int j = 14; j >= 0; --j) {
            lArray = this.T[j][byArray[j] & 0xFF];
            l ^= lArray[0];
            l2 ^= lArray[1];
        }
        Pack.longToBigEndian(l, byArray, 0);
        Pack.longToBigEndian(l2, byArray, 8);
    }
}

