/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import java.net.Socket;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import okhttp3.Address;
import okhttp3.Call;
import okhttp3.EventListener;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Route;
import okhttp3.internal.Util;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.connection.RealConnectionPool;
import okhttp3.internal.connection.RouteDatabase;
import okhttp3.internal.connection.RouteException;
import okhttp3.internal.connection.RouteSelector;
import okhttp3.internal.http.ExchangeCodec;
import okhttp3.internal.http.RealInterceptorChain;
import okhttp3.internal.http2.ConnectionShutdownException;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.StreamResetException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ0\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020%H\u0002J8\u0010&\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020%2\u0006\u0010'\u001a\u00020%H\u0002J\u0006\u0010(\u001a\u00020%J\b\u0010)\u001a\u00020%H\u0002J\u000e\u0010*\u001a\u00020%2\u0006\u0010+\u001a\u00020,J\u000e\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lokhttp3/internal/connection/ExchangeFinder;", "", "connectionPool", "Lokhttp3/internal/connection/RealConnectionPool;", "address", "Lokhttp3/Address;", "call", "Lokhttp3/internal/connection/RealCall;", "eventListener", "Lokhttp3/EventListener;", "(Lokhttp3/internal/connection/RealConnectionPool;Lokhttp3/Address;Lokhttp3/internal/connection/RealCall;Lokhttp3/EventListener;)V", "getAddress$okhttp", "()Lokhttp3/Address;", "connectingConnection", "Lokhttp3/internal/connection/RealConnection;", "connectionShutdownCount", "", "nextRouteToTry", "Lokhttp3/Route;", "otherFailureCount", "refusedStreamCount", "routeSelection", "Lokhttp3/internal/connection/RouteSelector$Selection;", "routeSelector", "Lokhttp3/internal/connection/RouteSelector;", "find", "Lokhttp3/internal/http/ExchangeCodec;", "client", "Lokhttp3/OkHttpClient;", "chain", "Lokhttp3/internal/http/RealInterceptorChain;", "findConnection", "connectTimeout", "readTimeout", "writeTimeout", "pingIntervalMillis", "connectionRetryEnabled", "", "findHealthyConnection", "doExtensiveHealthChecks", "retryAfterFailure", "retryCurrentRoute", "sameHostAndPort", "url", "Lokhttp3/HttpUrl;", "trackFailure", "", "e", "Ljava/io/IOException;", "okhttp"})
public final class ExchangeFinder {
    private RouteSelector.Selection routeSelection;
    private RouteSelector routeSelector;
    private RealConnection connectingConnection;
    private int refusedStreamCount;
    private int connectionShutdownCount;
    private int otherFailureCount;
    private Route nextRouteToTry;
    private final RealConnectionPool connectionPool;
    @NotNull
    private final Address address;
    private final RealCall call;
    private final EventListener eventListener;

    @NotNull
    public final ExchangeCodec find(@NotNull OkHttpClient client, @NotNull RealInterceptorChain chain2) {
        Intrinsics.checkParameterIsNotNull(client, "client");
        Intrinsics.checkParameterIsNotNull(chain2, "chain");
        try {
            RealConnection resultConnection = this.findHealthyConnection(chain2.getConnectTimeoutMillis$okhttp(), chain2.getReadTimeoutMillis$okhttp(), chain2.getWriteTimeoutMillis$okhttp(), client.pingIntervalMillis(), client.retryOnConnectionFailure(), Intrinsics.areEqual(chain2.getRequest$okhttp().method(), "GET") ^ true);
            return resultConnection.newCodec$okhttp(client, chain2);
        }
        catch (RouteException e) {
            this.trackFailure(e.getLastConnectException());
            throw (Throwable)e;
        }
        catch (IOException e) {
            this.trackFailure(e);
            throw (Throwable)new RouteException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final RealConnection findHealthyConnection(int connectTimeout, int readTimeout, int writeTimeout, int pingIntervalMillis, boolean connectionRetryEnabled, boolean doExtensiveHealthChecks) throws IOException {
        RealConnection candidate;
        while (!(candidate = this.findConnection(connectTimeout, readTimeout, writeTimeout, pingIntervalMillis, connectionRetryEnabled)).isHealthy(doExtensiveHealthChecks)) {
            candidate.noNewExchanges();
            RealConnectionPool realConnectionPool = this.connectionPool;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (realConnectionPool) {
                boolean bl3 = false;
                if (this.nextRouteToTry == null) {
                    boolean routesLeft;
                    RouteSelector.Selection selection = this.routeSelection;
                    boolean bl4 = routesLeft = selection != null ? selection.hasNext() : true;
                    if (!routesLeft) {
                        boolean routesSelectionLeft;
                        RouteSelector routeSelector = this.routeSelector;
                        boolean bl5 = routesSelectionLeft = routeSelector != null ? routeSelector.hasNext() : true;
                        if (!routesSelectionLeft) {
                            throw (Throwable)new IOException("exhausted all routes");
                        }
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        return candidate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final RealConnection findConnection(int connectTimeout, int readTimeout, int writeTimeout, int pingIntervalMillis, boolean connectionRetryEnabled) throws IOException {
        boolean newRouteSelection;
        Object object;
        Route selectedRoute;
        RealConnection result2;
        boolean foundPooledConnection;
        block49: {
            RouteSelector localRouteSelector;
            block50: {
                foundPooledConnection = false;
                result2 = null;
                selectedRoute = null;
                Ref.ObjectRef releasedConnection = new Ref.ObjectRef();
                Socket toClose = null;
                RealConnectionPool realConnectionPool = this.connectionPool;
                boolean bl = false;
                boolean bl2 = false;
                synchronized (realConnectionPool) {
                    boolean bl3 = false;
                    if (this.call.isCanceled()) {
                        throw (Throwable)new IOException("Canceled");
                    }
                    RealConnection callConnection = this.call.getConnection();
                    releasedConnection.element = callConnection;
                    Socket socket = toClose = callConnection != null && (callConnection.getNoNewExchanges() || !this.sameHostAndPort(callConnection.route().address().url())) ? this.call.releaseConnectionNoEvents$okhttp() : null;
                    if (this.call.getConnection() != null) {
                        result2 = this.call.getConnection();
                        releasedConnection.element = null;
                    }
                    if (result2 == null) {
                        this.refusedStreamCount = 0;
                        this.connectionShutdownCount = 0;
                        this.otherFailureCount = 0;
                        if (this.connectionPool.callAcquirePooledConnection(this.address, this.call, null, false)) {
                            foundPooledConnection = true;
                            result2 = this.call.getConnection();
                        } else if (this.nextRouteToTry != null) {
                            selectedRoute = this.nextRouteToTry;
                            this.nextRouteToTry = null;
                        }
                    }
                    object = Unit.INSTANCE;
                }
                Socket socket = toClose;
                if (socket != null) {
                    Util.closeQuietly(socket);
                }
                if ((RealConnection)releasedConnection.element != null) {
                    Call call2 = this.call;
                    RealConnection realConnection = (RealConnection)releasedConnection.element;
                    if (realConnection == null) {
                        Intrinsics.throwNpe();
                    }
                    this.eventListener.connectionReleased(call2, realConnection);
                }
                if (foundPooledConnection) {
                    Call call3 = this.call;
                    RealConnection realConnection = result2;
                    if (realConnection == null) {
                        Intrinsics.throwNpe();
                    }
                    this.eventListener.connectionAcquired(call3, realConnection);
                }
                if (result2 != null) {
                    RealConnection realConnection = result2;
                    if (realConnection == null) {
                        Intrinsics.throwNpe();
                    }
                    return realConnection;
                }
                newRouteSelection = false;
                if (selectedRoute != null) break block49;
                if (this.routeSelection == null) break block50;
                RouteSelector.Selection selection = this.routeSelection;
                if (selection == null) {
                    Intrinsics.throwNpe();
                }
                if (selection.hasNext()) break block49;
            }
            if ((localRouteSelector = this.routeSelector) == null) {
                this.routeSelector = localRouteSelector = new RouteSelector(this.address, this.call.getClient().getRouteDatabase(), this.call, this.eventListener);
            }
            newRouteSelection = true;
            this.routeSelection = localRouteSelector.next();
        }
        List<Route> routes = null;
        object = this.connectionPool;
        boolean bl = false;
        boolean bl4 = false;
        synchronized (object) {
            boolean bl5 = false;
            if (this.call.isCanceled()) {
                throw (Throwable)new IOException("Canceled");
            }
            if (newRouteSelection) {
                RouteSelector.Selection selection = this.routeSelection;
                if (selection == null) {
                    Intrinsics.throwNpe();
                }
                if (this.connectionPool.callAcquirePooledConnection(this.address, this.call, routes = selection.getRoutes(), false)) {
                    foundPooledConnection = true;
                    result2 = this.call.getConnection();
                }
            }
            if (!foundPooledConnection) {
                if (selectedRoute == null) {
                    RouteSelector.Selection selection = this.routeSelection;
                    if (selection == null) {
                        Intrinsics.throwNpe();
                    }
                    selectedRoute = selection.next();
                }
                Route route = selectedRoute;
                if (route == null) {
                    Intrinsics.throwNpe();
                }
                this.connectingConnection = result2 = new RealConnection(this.connectionPool, route);
            }
            Unit unit = Unit.INSTANCE;
        }
        if (foundPooledConnection) {
            Call call4 = this.call;
            RealConnection realConnection = result2;
            if (realConnection == null) {
                Intrinsics.throwNpe();
            }
            this.eventListener.connectionAcquired(call4, realConnection);
            RealConnection realConnection2 = result2;
            if (realConnection2 == null) {
                Intrinsics.throwNpe();
            }
            return realConnection2;
        }
        RealConnection realConnection = result2;
        if (realConnection == null) {
            Intrinsics.throwNpe();
        }
        realConnection.connect(connectTimeout, readTimeout, writeTimeout, pingIntervalMillis, connectionRetryEnabled, this.call, this.eventListener);
        RouteDatabase routeDatabase = this.call.getClient().getRouteDatabase();
        RealConnection realConnection3 = result2;
        if (realConnection3 == null) {
            Intrinsics.throwNpe();
        }
        routeDatabase.connected(realConnection3.route());
        Socket socket = null;
        RealConnectionPool realConnectionPool = this.connectionPool;
        boolean bl6 = false;
        boolean bl7 = false;
        synchronized (realConnectionPool) {
            boolean bl8 = false;
            this.connectingConnection = null;
            if (this.connectionPool.callAcquirePooledConnection(this.address, this.call, routes, true)) {
                RealConnection realConnection4 = result2;
                if (realConnection4 == null) {
                    Intrinsics.throwNpe();
                }
                realConnection4.setNoNewExchanges(true);
                RealConnection realConnection5 = result2;
                if (realConnection5 == null) {
                    Intrinsics.throwNpe();
                }
                socket = realConnection5.socket();
                result2 = this.call.getConnection();
                this.nextRouteToTry = selectedRoute;
            } else {
                RealConnection realConnection6 = result2;
                if (realConnection6 == null) {
                    Intrinsics.throwNpe();
                }
                this.connectionPool.put(realConnection6);
                RealConnection realConnection7 = result2;
                if (realConnection7 == null) {
                    Intrinsics.throwNpe();
                }
                this.call.acquireConnectionNoEvents(realConnection7);
            }
            Unit unit = Unit.INSTANCE;
        }
        Socket socket2 = socket;
        if (socket2 != null) {
            Util.closeQuietly(socket2);
        }
        Call call5 = this.call;
        RealConnection realConnection8 = result2;
        if (realConnection8 == null) {
            Intrinsics.throwNpe();
        }
        this.eventListener.connectionAcquired(call5, realConnection8);
        RealConnection realConnection9 = result2;
        if (realConnection9 == null) {
            Intrinsics.throwNpe();
        }
        return realConnection9;
    }

    @Nullable
    public final RealConnection connectingConnection() {
        RealConnectionPool $this$assertThreadHoldsLock$iv = this.connectionPool;
        boolean $i$f$assertThreadHoldsLock = false;
        if (Util.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
            StringBuilder stringBuilder = new StringBuilder().append("Thread ");
            Thread thread2 = Thread.currentThread();
            Intrinsics.checkExpressionValueIsNotNull(thread2, "Thread.currentThread()");
            throw (Throwable)((Object)new AssertionError((Object)stringBuilder.append(thread2.getName()).append(" MUST hold lock on ").append($this$assertThreadHoldsLock$iv).toString()));
        }
        return this.connectingConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void trackFailure(@NotNull IOException e) {
        Intrinsics.checkParameterIsNotNull(e, "e");
        RealConnectionPool $this$assertThreadDoesntHoldLock$iv = this.connectionPool;
        boolean $i$f$assertThreadDoesntHoldLock = false;
        if (Util.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
            StringBuilder stringBuilder = new StringBuilder().append("Thread ");
            Thread thread2 = Thread.currentThread();
            Intrinsics.checkExpressionValueIsNotNull(thread2, "Thread.currentThread()");
            throw (Throwable)((Object)new AssertionError((Object)stringBuilder.append(thread2.getName()).append(" MUST NOT hold lock on ").append($this$assertThreadDoesntHoldLock$iv).toString()));
        }
        RealConnectionPool realConnectionPool = this.connectionPool;
        boolean bl = false;
        int n = 0;
        synchronized (realConnectionPool) {
            int n2;
            boolean bl2 = false;
            this.nextRouteToTry = null;
            if (e instanceof StreamResetException && ((StreamResetException)e).errorCode == ErrorCode.REFUSED_STREAM) {
                int n3 = this.refusedStreamCount;
                this.refusedStreamCount = n3 + 1;
                n2 = n3;
            } else if (e instanceof ConnectionShutdownException) {
                int n4 = this.connectionShutdownCount;
                this.connectionShutdownCount = n4 + 1;
                n2 = n4;
            } else {
                int n5 = this.otherFailureCount;
                this.otherFailureCount = n5 + 1;
                n2 = n5;
            }
            n = n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean retryAfterFailure() {
        RealConnectionPool realConnectionPool = this.connectionPool;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (realConnectionPool) {
            RouteSelector routeSelector;
            block13: {
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                boolean bl3 = false;
                                if (this.refusedStreamCount != 0 || this.connectionShutdownCount != 0 || this.otherFailureCount != 0) break block9;
                                boolean bl4 = false;
                                return bl4;
                            }
                            if (this.nextRouteToTry == null) break block10;
                            boolean bl5 = true;
                            return bl5;
                        }
                        if (!this.retryCurrentRoute()) break block11;
                        RealConnection realConnection = this.call.getConnection();
                        if (realConnection == null) {
                            Intrinsics.throwNpe();
                        }
                        this.nextRouteToTry = realConnection.route();
                        boolean bl6 = true;
                        return bl6;
                    }
                    RouteSelector.Selection selection = this.routeSelection;
                    if (selection == null) break block12;
                    if (!selection.hasNext()) break block12;
                    boolean bl7 = true;
                    return bl7;
                }
                if (this.routeSelector != null) break block13;
                boolean bl8 = true;
                return bl8;
            }
            RouteSelector localRouteSelector = routeSelector;
            boolean bl9 = localRouteSelector.hasNext();
            return bl9;
        }
    }

    private final boolean retryCurrentRoute() {
        if (this.refusedStreamCount > 1 || this.connectionShutdownCount > 1 || this.otherFailureCount > 0) {
            return false;
        }
        RealConnection connection = this.call.getConnection();
        return connection != null && connection.getRouteFailureCount$okhttp() == 0 && Util.canReuseConnectionFor(connection.route().address().url(), this.address.url());
    }

    public final boolean sameHostAndPort(@NotNull HttpUrl url2) {
        Intrinsics.checkParameterIsNotNull(url2, "url");
        HttpUrl routeUrl = this.address.url();
        return url2.port() == routeUrl.port() && Intrinsics.areEqual(url2.host(), routeUrl.host());
    }

    @NotNull
    public final Address getAddress$okhttp() {
        return this.address;
    }

    public ExchangeFinder(@NotNull RealConnectionPool connectionPool, @NotNull Address address, @NotNull RealCall call2, @NotNull EventListener eventListener) {
        Intrinsics.checkParameterIsNotNull(connectionPool, "connectionPool");
        Intrinsics.checkParameterIsNotNull(address, "address");
        Intrinsics.checkParameterIsNotNull(call2, "call");
        Intrinsics.checkParameterIsNotNull(eventListener, "eventListener");
        this.connectionPool = connectionPool;
        this.address = address;
        this.call = call2;
        this.eventListener = eventListener;
    }
}

