/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.internal.JsonExceptionsKt;
import kotlinx.serialization.json.internal.JsonReaderKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\b\n\u0002\u0010\u0001\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\fH\u0002J\u0018\u0010\u0019\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\fH\u0002J \u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\fH\u0002J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00032\b\b\u0002\u0010!\u001a\u00020\fJ\u0018\u0010\"\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010#\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\fH\u0002J\u0018\u0010$\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\fH\u0002J\u0006\u0010%\u001a\u00020\u0014J\u0010\u0010&\u001a\u0004\u0018\u00010\u00032\u0006\u0010'\u001a\u00020\bJ1\u0010(\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\b2\b\b\u0002\u0010!\u001a\u00020\f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00030*H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\b+J-\u0010,\u001a\u00020\u00142\u0006\u0010-\u001a\u00020\u00112\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00030/H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\b0J\u0006\u00101\u001a\u00020\u0014J\u0006\u00102\u001a\u00020\u0003J\u0006\u00103\u001a\u00020\u0003J\u0012\u00104\u001a\u00020\u00032\b\b\u0002\u00105\u001a\u00020\bH\u0002J\u0006\u00106\u001a\u00020\u0003J\b\u00107\u001a\u00020\u0003H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\nR\u000e\u0010\u000e\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00020\u00118\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u00068"}, d2={"Lkotlinx/serialization/json/internal/JsonReader;", "", "source", "", "(Ljava/lang/String;)V", "buf", "", "canBeginValue", "", "getCanBeginValue", "()Z", "currentPosition", "", "isDone", "length", "offset", "tokenClass", "", "tokenPosition", "append", "", "ch", "", "appendEsc", "startPosition", "appendHex", "startPos", "appendRange", "fromIndex", "toIndex", "fail", "", "message", "position", "fromHexChar", "nextLiteral", "nextString", "nextToken", "peekString", "isLenient", "require", "condition", "Lkotlin/Function0;", "require$kotlinx_serialization_json", "requireTokenClass", "expected", "errorMessage", "Lkotlin/Function1;", "requireTokenClass$kotlinx_serialization_json", "skipElement", "takeBooleanStringUnquoted", "takeString", "takeStringInternal", "advance", "takeStringQuoted", "toString", "kotlinx-serialization-json"})
public final class JsonReader {
    @JvmField
    public int currentPosition;
    @JvmField
    public byte tokenClass;
    private int tokenPosition;
    private int offset;
    private int length;
    private char[] buf;
    private final String source;

    public final boolean isDone() {
        return this.tokenClass == 12;
    }

    public final boolean getCanBeginValue() {
        boolean bl;
        switch (this.tokenClass) {
            case 0: 
            case 1: 
            case 6: 
            case 8: 
            case 10: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public final void requireTokenClass$kotlinx_serialization_json(byte expected, @NotNull Function1<? super Character, String> errorMessage2) {
        int $i$f$requireTokenClass$kotlinx_serialization_json = 0;
        Intrinsics.checkNotNullParameter(errorMessage2, "errorMessage");
        if (this.tokenClass != expected) {
            Void void_ = this.fail(errorMessage2.invoke(Character.valueOf((char)this.tokenClass)), this.tokenPosition);
            throw new KotlinNothingValueException();
        }
    }

    @NotNull
    public final String takeString() {
        if (this.tokenClass != 0 && this.tokenClass != 1) {
            Void void_ = this.fail("Expected string or non-null literal", this.tokenPosition);
            throw new KotlinNothingValueException();
        }
        return JsonReader.takeStringInternal$default(this, false, 1, null);
    }

    @Nullable
    public final String peekString(boolean isLenient) {
        return this.tokenClass != 1 && (!isLenient || this.tokenClass != 0) ? null : this.takeStringInternal(false);
    }

    @NotNull
    public final String takeStringQuoted() {
        switch (this.tokenClass) {
            case 1: {
                break;
            }
            case 10: {
                Void void_ = this.fail("Expected string literal but 'null' literal was found.\nUse 'coerceInputValues = true' in 'Json {}` builder to coerce nulls to default values.", this.tokenPosition);
                throw new KotlinNothingValueException();
            }
            default: {
                Void void_ = this.fail("Expected string literal with quotes.\nUse 'isLenient = true' in 'Json {}` builder to accept non-compliant JSON.", this.tokenPosition);
                throw new KotlinNothingValueException();
            }
        }
        return JsonReader.takeStringInternal$default(this, false, 1, null);
    }

    @NotNull
    public final String takeBooleanStringUnquoted() {
        if (this.tokenClass != 0) {
            Void void_ = this.fail("Expected start of the unquoted boolean literal.\nUse 'isLenient = true' in 'Json {}` builder to accept non-compliant JSON.", this.tokenPosition);
            throw new KotlinNothingValueException();
        }
        return JsonReader.takeStringInternal$default(this, false, 1, null);
    }

    private final String takeStringInternal(boolean advance) {
        String string;
        if (this.offset < 0) {
            string = StringsKt.concatToString(this.buf, 0, 0 + this.length);
        } else {
            String string2 = this.source;
            int n = this.offset;
            int n2 = this.offset + this.length;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n, n2);
            string = string4;
            Intrinsics.checkNotNullExpressionValue(string4, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        }
        String prevStr = string;
        if (advance) {
            this.nextToken();
        }
        return prevStr;
    }

    static /* synthetic */ String takeStringInternal$default(JsonReader jsonReader, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return jsonReader.takeStringInternal(bl);
    }

    private final void append(char ch) {
        if (this.length >= this.buf.length) {
            char[] cArray = this.buf;
            int n = 2 * this.buf.length;
            boolean bl = false;
            char[] cArray2 = Arrays.copyOf(cArray, n);
            Intrinsics.checkNotNullExpressionValue(cArray2, "java.util.Arrays.copyOf(this, newSize)");
            this.buf = cArray2;
        }
        int n = this.length;
        this.length = n + 1;
        this.buf[n] = ch;
    }

    /*
     * WARNING - void declaration
     */
    private final void appendRange(String source2, int fromIndex, int toIndex) {
        int n;
        int oldLen = this.length;
        int addLen = toIndex - fromIndex;
        int newLen = oldLen + addLen;
        if (newLen > this.buf.length) {
            char[] cArray = this.buf;
            n = RangesKt.coerceAtLeast(newLen, 2 * this.buf.length);
            boolean bl = false;
            char[] cArray2 = Arrays.copyOf(cArray, n);
            Intrinsics.checkNotNullExpressionValue(cArray2, "java.util.Arrays.copyOf(this, newSize)");
            this.buf = cArray2;
        }
        int n2 = 0;
        n = addLen;
        while (n2 < n) {
            void i2;
            this.buf[oldLen + i2] = source2.charAt(fromIndex + i2);
            ++i2;
        }
        this.length += addLen;
    }

    /*
     * WARNING - void declaration
     */
    public final void nextToken() {
        int currentPosition;
        String source2 = this.source;
        block5: for (currentPosition = this.currentPosition; currentPosition < source2.length(); ++currentPosition) {
            void tc;
            char ch = source2.charAt(currentPosition);
            byte by = JsonReaderKt.charToTokenClass(ch);
            switch (tc) {
                case 3: {
                    continue block5;
                }
                case 0: {
                    this.nextLiteral(source2, currentPosition);
                    return;
                }
                case 1: {
                    this.nextString(source2, currentPosition);
                    return;
                }
            }
            this.tokenPosition = currentPosition;
            this.tokenClass = tc;
            this.currentPosition = currentPosition + 1;
            return;
        }
        this.tokenPosition = currentPosition;
        this.tokenClass = (byte)12;
    }

    private final void nextLiteral(String source2, int startPos) {
        int currentPosition;
        this.tokenPosition = startPos;
        this.offset = startPos;
        for (currentPosition = startPos; currentPosition < source2.length() && JsonReaderKt.charToTokenClass(source2.charAt(currentPosition)) == 0; ++currentPosition) {
        }
        this.currentPosition = currentPosition;
        this.length = currentPosition - this.offset;
        this.tokenClass = (byte)(JsonReaderKt.access$rangeEquals(source2, this.offset, this.length, "null") ? 10 : 0);
    }

    private final void nextString(String source2, int startPosition) {
        this.tokenPosition = startPosition;
        this.length = 0;
        int currentPosition = startPosition + 1;
        if (currentPosition >= source2.length()) {
            Void void_ = this.fail("EOF", currentPosition);
            throw new KotlinNothingValueException();
        }
        int lastPosition = currentPosition;
        while (source2.charAt(currentPosition) != '\"') {
            if (source2.charAt(currentPosition) == '\\') {
                int newPosition;
                this.appendRange(source2, lastPosition, currentPosition);
                currentPosition = newPosition = this.appendEsc(source2, currentPosition + 1);
                lastPosition = newPosition;
                continue;
            }
            if (++currentPosition < source2.length()) continue;
            Void void_ = this.fail("EOF", currentPosition);
            throw new KotlinNothingValueException();
        }
        if (lastPosition == startPosition + 1) {
            this.offset = lastPosition;
            this.length = currentPosition - lastPosition;
        } else {
            this.appendRange(source2, lastPosition, currentPosition);
            this.offset = -1;
        }
        this.currentPosition = currentPosition + 1;
        this.tokenClass = 1;
    }

    /*
     * WARNING - void declaration
     */
    private final int appendEsc(String source2, int startPosition) {
        char currentChar;
        int currentPosition = startPosition;
        JsonReader jsonReader = this;
        boolean condition$iv = currentPosition < source2.length();
        boolean $i$f$require$kotlinx_serialization_json22 = false;
        if (!condition$iv) {
            void this_$iv;
            void var10_9 = this_$iv;
            boolean bl = false;
            String string = "Unexpected EOF after escape character";
            Void void_ = var10_9.fail(string, currentPosition);
            throw new KotlinNothingValueException();
        }
        if ((currentChar = source2.charAt(currentPosition++)) == 'u') {
            return this.appendHex(source2, currentPosition);
        }
        char c = JsonReaderKt.escapeToChar(currentChar);
        JsonReader $i$f$require$kotlinx_serialization_json22 = this;
        boolean condition$iv2 = c != '\u0000';
        boolean $i$f$require$kotlinx_serialization_json = false;
        if (!condition$iv2) {
            void this_$iv;
            void var10_10 = this_$iv;
            boolean bl = false;
            String string = "Invalid escaped char '" + currentChar + '\'';
            Void void_ = var10_10.fail(string, currentPosition);
            throw new KotlinNothingValueException();
        }
        this.append(c);
        return currentPosition;
    }

    private final int appendHex(String source2, int startPos) {
        int curPos = startPos;
        this.append((char)((this.fromHexChar(source2, curPos++) << 12) + (this.fromHexChar(source2, curPos++) << 8) + (this.fromHexChar(source2, curPos++) << 4) + this.fromHexChar(source2, curPos++)));
        return curPos;
    }

    public final void skipElement() {
        Collection collection;
        if (this.tokenClass != 6 && this.tokenClass != 8) {
            this.nextToken();
            return;
        }
        boolean bl = false;
        List tokenStack = new ArrayList();
        do {
            switch (this.tokenClass) {
                case 6: 
                case 8: {
                    tokenStack.add(this.tokenClass);
                    break;
                }
                case 9: {
                    if (((Number)CollectionsKt.last(tokenStack)).byteValue() != 8) {
                        throw (Throwable)JsonExceptionsKt.JsonDecodingException(this.currentPosition, "found ] instead of }", this.source);
                    }
                    tokenStack.remove(tokenStack.size() - 1);
                    break;
                }
                case 7: {
                    if (((Number)CollectionsKt.last(tokenStack)).byteValue() != 6) {
                        throw (Throwable)JsonExceptionsKt.JsonDecodingException(this.currentPosition, "found } instead of ]", this.source);
                    }
                    tokenStack.remove(tokenStack.size() - 1);
                    break;
                }
            }
            this.nextToken();
            collection = tokenStack;
            boolean bl2 = false;
        } while (!collection.isEmpty());
    }

    @NotNull
    public String toString() {
        return "JsonReader(source='" + this.source + "', currentPosition=" + this.currentPosition + ", tokenClass=" + this.tokenClass + ", tokenPosition=" + this.tokenPosition + ", offset=" + this.offset + ')';
    }

    @NotNull
    public final Void fail(@NotNull String message2, int position) {
        Intrinsics.checkNotNullParameter(message2, "message");
        throw (Throwable)JsonExceptionsKt.JsonDecodingException(position, message2, this.source);
    }

    public static /* synthetic */ Void fail$default(JsonReader jsonReader, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = jsonReader.currentPosition;
        }
        return jsonReader.fail(string, n);
    }

    public final void require$kotlinx_serialization_json(boolean condition, int position, @NotNull Function0<String> message2) {
        int $i$f$require$kotlinx_serialization_json = 0;
        Intrinsics.checkNotNullParameter(message2, "message");
        if (!condition) {
            Void void_ = this.fail(message2.invoke(), position);
            throw new KotlinNothingValueException();
        }
    }

    public static /* synthetic */ void require$kotlinx_serialization_json$default(JsonReader this_, boolean condition, int position, Function0 message2, int n, Object object) {
        if ((n & 2) != 0) {
            position = this_.currentPosition;
        }
        boolean $i$f$require$kotlinx_serialization_json = false;
        Intrinsics.checkNotNullParameter(message2, "message");
        if (!condition) {
            Void void_ = this_.fail((String)message2.invoke(), position);
            throw new KotlinNothingValueException();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int fromHexChar(String source2, int currentPosition) {
        int n;
        JsonReader jsonReader = this;
        boolean condition$iv = currentPosition < source2.length();
        boolean $i$f$require$kotlinx_serialization_json = false;
        if (!condition$iv) {
            void this_$iv;
            void var7_7 = this_$iv;
            boolean bl = false;
            String string = "Unexpected EOF during unicode escape";
            Void void_ = var7_7.fail(string, currentPosition);
            throw new KotlinNothingValueException();
        }
        char curChar = source2.charAt(currentPosition);
        char c = curChar;
        if ('0' <= c && '9' >= c) {
            n = curChar - 48;
        } else {
            c = curChar;
            if ('a' <= c && 'f' >= c) {
                n = curChar - 97 + 10;
            } else {
                c = curChar;
                if ('A' <= c && 'F' >= c) {
                    n = curChar - 65 + 10;
                } else {
                    Void void_ = JsonReader.fail$default(this, "Invalid toHexChar char '" + curChar + "' in unicode escape", 0, 2, null);
                    throw new KotlinNothingValueException();
                }
            }
        }
        return n;
    }

    public JsonReader(@NotNull String source2) {
        Intrinsics.checkNotNullParameter(source2, "source");
        this.source = source2;
        this.tokenClass = (byte)12;
        this.offset = -1;
        this.buf = new char[16];
        this.nextToken();
    }

    public static final /* synthetic */ void access$setTokenPosition$p(JsonReader $this, int n) {
        $this.tokenPosition = n;
    }
}

